/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.pkcs7;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.signers.AOSimpleSignInfo;
import es.gob.afirma.core.util.tree.AOTreeModel;
import es.gob.afirma.core.util.tree.AOTreeNode;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1GeneralizedTime;
import org.spongycastle.asn1.ASN1InputStream;
import org.spongycastle.asn1.ASN1Integer;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.ASN1Set;
import org.spongycastle.asn1.ASN1TaggedObject;
import org.spongycastle.asn1.ASN1UTCTime;
import org.spongycastle.asn1.cms.Attribute;
import org.spongycastle.asn1.cms.CMSAttributes;
import org.spongycastle.asn1.cms.IssuerAndSerialNumber;
import org.spongycastle.asn1.cms.SignedData;
import org.spongycastle.asn1.cms.SignerInfo;
import org.spongycastle.asn1.pkcs.PKCSObjectIdentifiers;

public final class ReadNodesTree {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private String stringRetorn = "";
    private AOTreeNode rama;
    private AOTreeNode rama2;
    private int[] seleccionados;
    private final List<String> lista = new ArrayList<String>();
    private final List<X509Certificate[]> listaCert = new ArrayList<X509Certificate[]>();

    int[] getSeleccionados() {
        return this.seleccionados;
    }

    void setSeleccionados(int[] nArray) {
        this.seleccionados = (int[])nArray.clone();
    }

    String getStringRetorn() {
        return this.stringRetorn;
    }

    void setStringRetorn(String string) {
        this.stringRetorn = string;
    }

    public AOTreeModel readNodesTree(byte[] byArray, boolean bl) throws IOException {
        Object object;
        block18: {
            ASN1Set aSN1Set;
            ASN1Set aSN1Set2;
            block17: {
                ASN1Sequence aSN1Sequence;
                Object object2 = new ASN1InputStream(byArray);
                Object object3 = null;
                try {
                    aSN1Sequence = (ASN1Sequence)((ASN1InputStream)object2).readObject();
                }
                catch (Throwable throwable) {
                    object3 = throwable;
                    throw throwable;
                }
                finally {
                    if (object2 != null) {
                        if (object3 != null) {
                            try {
                                ((FilterInputStream)object2).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object3).addSuppressed(throwable);
                            }
                        } else {
                            ((FilterInputStream)object2).close();
                        }
                    }
                }
                object2 = aSN1Sequence.getObjects();
                object2.nextElement();
                object3 = (ASN1TaggedObject)object2.nextElement();
                ASN1Sequence aSN1Sequence2 = (ASN1Sequence)((ASN1TaggedObject)object3).getObject();
                aSN1Set2 = null;
                aSN1Set = null;
                try {
                    object = SignedData.getInstance(aSN1Sequence2);
                    aSN1Set2 = ((SignedData)object).getSignerInfos();
                    aSN1Set = ((SignedData)object).getCertificates();
                }
                catch (Exception exception) {
                    LOGGER.severe("Error obteniendo los SignerInfos del SignedData: " + exception);
                }
                object = new AOTreeNode("Datos");
                if (!bl || aSN1Set2 == null) break block17;
                for (int i = 0; i < aSN1Set2.size(); ++i) {
                    ASN1Sequence aSN1Sequence3 = (ASN1Sequence)aSN1Set2.getObjectAt(i);
                    IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(aSN1Sequence3.getObjectAt(1));
                    X509Certificate[] x509CertificateArray = ReadNodesTree.searchCert(aSN1Set, issuerAndSerialNumber.getSerialNumber());
                    SignerInfo signerInfo = SignerInfo.getInstance(aSN1Sequence3);
                    Date date = ReadNodesTree.getSigningTime(signerInfo);
                    AOSimpleSignInfo aOSimpleSignInfo = new AOSimpleSignInfo(x509CertificateArray, date);
                    aOSimpleSignInfo.setPkcs1(signerInfo.getEncryptedDigest().getOctets());
                    this.rama = new AOTreeNode(aOSimpleSignInfo);
                    this.listaCert.add(x509CertificateArray);
                    this.getUnsignedAtributes(true, signerInfo.getUnauthenticatedAttributes(), this.rama, aSN1Set);
                    ((AOTreeNode)object).add(this.rama);
                }
                break block18;
            }
            if (aSN1Set2 == null) break block18;
            for (int i = 0; i < aSN1Set2.size(); ++i) {
                ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Set2.getObjectAt(i);
                IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(aSN1Sequence.getObjectAt(1));
                String string = ReadNodesTree.searchName(aSN1Set, issuerAndSerialNumber.getSerialNumber());
                SignerInfo signerInfo = SignerInfo.getInstance(aSN1Sequence);
                this.rama = new AOTreeNode(string);
                this.lista.add(string);
                this.getUnsignedAtributes(false, signerInfo.getUnauthenticatedAttributes(), this.rama, aSN1Set);
                ((AOTreeNode)object).add(this.rama);
            }
        }
        return new AOTreeModel((AOTreeNode)object);
    }

    private void getUnsignedAtributes(boolean bl, ASN1Set aSN1Set, AOTreeNode aOTreeNode, ASN1Set aSN1Set2) {
        if (aSN1Set != null) {
            Enumeration enumeration = aSN1Set.getObjects();
            while (enumeration.hasMoreElements()) {
                Attribute attribute = Attribute.getInstance(enumeration.nextElement());
                if (!ReadNodesTree.isValideAttributeType(attribute.getAttrType())) continue;
                ASN1Set aSN1Set3 = attribute.getAttrValues();
                Enumeration enumeration2 = aSN1Set3.getObjects();
                while (enumeration2.hasMoreElements()) {
                    X509Certificate[] x509CertificateArray;
                    Object e = enumeration2.nextElement();
                    if (!(e instanceof ASN1Sequence)) continue;
                    ASN1Sequence aSN1Sequence = (ASN1Sequence)e;
                    IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(aSN1Sequence.getObjectAt(1));
                    SignerInfo signerInfo = SignerInfo.getInstance(aSN1Sequence);
                    if (bl) {
                        x509CertificateArray = ReadNodesTree.searchCert(aSN1Set2, issuerAndSerialNumber.getSerialNumber());
                        Date date = ReadNodesTree.getSigningTime(signerInfo);
                        AOSimpleSignInfo aOSimpleSignInfo = new AOSimpleSignInfo(x509CertificateArray, date);
                        aOSimpleSignInfo.setPkcs1(signerInfo.getEncryptedDigest().getOctets());
                        this.rama2 = new AOTreeNode(aOSimpleSignInfo);
                        this.listaCert.add(x509CertificateArray);
                        aOTreeNode.add(this.rama2);
                        this.getUnsignedAtributes(true, signerInfo.getUnauthenticatedAttributes(), this.rama2, aSN1Set2);
                        continue;
                    }
                    x509CertificateArray = ReadNodesTree.searchName(aSN1Set2, issuerAndSerialNumber.getSerialNumber());
                    this.rama2 = new AOTreeNode(x509CertificateArray);
                    this.lista.add((String)x509CertificateArray);
                    aOTreeNode.add(this.rama2);
                    this.getUnsignedAtributes(false, signerInfo.getUnauthenticatedAttributes(), this.rama2, aSN1Set2);
                }
            }
        }
    }

    private static boolean isValideAttributeType(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return !aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken) && !aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_aa_ets_escTimeStamp) && !aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_aa_ets_revocationRefs) && !aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_aa_ets_revocationValues) && !aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_aa_ets_certificateRefs) && !aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_aa_ets_certValues) && !aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_aa.branch("48"));
    }

    public int[] readNodesFromSigners(String[] stringArray, byte[] byArray) throws IOException {
        this.readNodesTree(byArray, false);
        List<String> list = this.lista;
        int[] nArray = new int[list.size()];
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            for (String string : stringArray) {
                String string2 = list.get(i);
                if (!string2.equals(string)) continue;
                nArray[n] = i;
                ++n;
            }
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        nArray2 = ReadNodesTree.simplyArray(nArray2);
        Arrays.sort(nArray2);
        return nArray2;
    }

    public static int[] simplyArray(int[] nArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < nArray.length; ++i) {
            if (arrayList.contains(nArray[i])) continue;
            arrayList.add(nArray[i]);
        }
        int[] nArray2 = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            nArray2[i] = (Integer)arrayList.get(i);
        }
        return nArray2;
    }

    private static String searchName(ASN1Set aSN1Set, ASN1Integer aSN1Integer) {
        Enumeration enumeration = aSN1Set.getObjects();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate;
            try {
                x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(((ASN1Sequence)enumeration.nextElement()).getEncoded()));
            }
            catch (Exception exception) {
                LOGGER.severe("Error extrayendo los certificados del Set ASN.1, puede que se haya omitido un elemento valido" + exception);
                continue;
            }
            if (!x509Certificate.getSerialNumber().equals(aSN1Integer.getValue())) continue;
            return AOUtil.getCN(x509Certificate);
        }
        LOGGER.info("No se ha encontrado el certificado indicado, se devolvera una cadena vacia");
        return "";
    }

    private static X509Certificate[] searchCert(ASN1Set aSN1Set, ASN1Integer aSN1Integer) {
        Enumeration enumeration = aSN1Set.getObjects();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate;
            try {
                x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(((ASN1Sequence)enumeration.nextElement()).getEncoded()));
            }
            catch (Exception exception) {
                LOGGER.severe("Error extrayendo los certificados del Set ASN.1, puede que se haya omitido un elemento valido" + exception);
                continue;
            }
            if (!x509Certificate.getSerialNumber().equals(aSN1Integer.getValue())) continue;
            return new X509Certificate[]{x509Certificate};
        }
        LOGGER.severe("El certificados pedido no estaba en la lista, se devolvera un array vacio");
        return new X509Certificate[0];
    }

    private static Date getSigningTime(SignerInfo signerInfo) {
        Date date = null;
        if (signerInfo.getAuthenticatedAttributes() != null) {
            Enumeration enumeration = signerInfo.getAuthenticatedAttributes().getObjects();
            while (enumeration.hasMoreElements()) {
                Attribute attribute = Attribute.getInstance(enumeration.nextElement());
                if (!attribute.getAttrType().equals(CMSAttributes.signingTime)) continue;
                ASN1Set aSN1Set = attribute.getAttrValues();
                ASN1Encodable aSN1Encodable = aSN1Set.getObjectAt(0);
                if (aSN1Encodable == null) {
                    LOGGER.severe("El objeto no contiene una fecha");
                    continue;
                }
                if (aSN1Encodable instanceof ASN1GeneralizedTime) {
                    try {
                        date = ((ASN1GeneralizedTime)aSN1Encodable).getDate();
                    }
                    catch (ParseException parseException) {
                        LOGGER.severe("No es posible convertir la fecha: " + parseException);
                    }
                    continue;
                }
                if (aSN1Encodable instanceof ASN1UTCTime) {
                    try {
                        date = ((ASN1UTCTime)aSN1Encodable).getDate();
                    }
                    catch (ParseException parseException) {
                        LOGGER.severe("No es posible convertir la fecha: " + parseException);
                    }
                    continue;
                }
                LOGGER.severe("Formato de fecha deconocido: " + aSN1Encodable.getClass().getName());
            }
        }
        return date;
    }
}

