/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.pkcs7;

import es.gob.afirma.core.AOInvalidFormatException;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.logging.Logger;
import org.spongycastle.asn1.ASN1InputStream;
import org.spongycastle.asn1.ASN1Object;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.ASN1Set;
import org.spongycastle.asn1.ASN1TaggedObject;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.DERSet;
import org.spongycastle.asn1.cms.CMSAttributes;
import org.spongycastle.asn1.cms.ContentInfo;
import org.spongycastle.asn1.cms.SignedData;
import org.spongycastle.asn1.cms.SignerInfo;
import org.spongycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;

public final class ObtainContentSignedData {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    private ObtainContentSignedData() {
    }

    public static byte[] obtainData(byte[] byArray) throws AOInvalidFormatException {
        ASN1TaggedObject aSN1TaggedObject;
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        ASN1Object aSN1Object;
        Object object;
        byte[] byArray2 = null;
        try {
            object = new ASN1InputStream(byArray);
            Throwable throwable = null;
            try {
                aSN1Object = (ASN1Sequence)((ASN1InputStream)object).readObject();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((FilterInputStream)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((FilterInputStream)object).close();
                    }
                }
            }
            object = ((ASN1Sequence)aSN1Object).getObjects();
            aSN1ObjectIdentifier = (ASN1ObjectIdentifier)object.nextElement();
            aSN1TaggedObject = (ASN1TaggedObject)object.nextElement();
        }
        catch (Exception exception) {
            throw new AOInvalidFormatException("Error al parsear la firma ASN.1: " + exception, exception);
        }
        if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.signedData)) {
            aSN1Object = SignedData.getInstance(aSN1TaggedObject.getObject());
            object = ((SignedData)aSN1Object).getEncapContentInfo();
            if (((ContentInfo)object).getContent() != null) {
                byArray2 = ((DEROctetString)((ContentInfo)object).getContent()).getOctets();
            } else {
                LOGGER.warning("No existe contenido en esta firma.");
            }
        } else {
            LOGGER.warning("No se puede obtener el contenido de esta firma.");
        }
        return byArray2;
    }

    public static byte[] obtainMessageDigest(byte[] byArray, String string) throws IOException {
        ASN1Sequence aSN1Sequence;
        Object object = new ASN1InputStream(byArray);
        Object object2 = null;
        try {
            aSN1Sequence = (ASN1Sequence)((ASN1InputStream)object).readObject();
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (object2 != null) {
                    try {
                        ((FilterInputStream)object).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    ((FilterInputStream)object).close();
                }
            }
        }
        object = aSN1Sequence.getObjects();
        object2 = (ASN1ObjectIdentifier)object.nextElement();
        if (!((ASN1Primitive)object2).equals(PKCSObjectIdentifiers.signedData)) {
            LOGGER.warning("No se puede obtener el contenido de esta firma.");
            return null;
        }
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)object.nextElement();
        SignedData signedData = SignedData.getInstance(aSN1TaggedObject.getObject());
        ASN1Set aSN1Set = signedData.getSignerInfos();
        byte[] byArray2 = null;
        for (int i = 0; i < aSN1Set.size(); ++i) {
            SignerInfo signerInfo = SignerInfo.getInstance(aSN1Set.getObjectAt(i));
            AlgorithmIdentifier algorithmIdentifier = signerInfo.getDigestAlgorithm();
            if (!algorithmIdentifier.getAlgorithm().toString().equals(AOAlgorithmID.getOID(string))) continue;
            ASN1Set aSN1Set2 = signerInfo.getAuthenticatedAttributes();
            for (int j = 0; j < aSN1Set2.size(); ++j) {
                ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Set2.getObjectAt(j);
                ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)aSN1Sequence2.getObjectAt(0);
                if (!CMSAttributes.messageDigest.getId().equals(aSN1ObjectIdentifier.toString())) continue;
                DERSet dERSet = (DERSet)aSN1Sequence2.getObjectAt(1);
                DEROctetString dEROctetString = (DEROctetString)dERSet.getObjectAt(0);
                byArray2 = dEROctetString.getOctets();
                break;
            }
            if (byArray2 != null) break;
        }
        if (byArray2 == null) {
            LOGGER.warning("No se ha encontrado en la firma una huella digital generada con el algoritmo: " + string);
        }
        return byArray2;
    }
}

