/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.pkcs7;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Locale;

public final class AOAlgorithmID {
    private static final String OID_SHA1 = "1.3.14.3.2.26";
    private static final String OID_SHA512 = "2.16.840.1.101.3.4.2.3";
    public static final String OID_SHA256 = "2.16.840.1.101.3.4.2.1";
    private static final String OID_SHA384 = "2.16.840.1.101.3.4.2.2";
    private static final String OID_RSA = "1.2.840.113549.1.1.1";
    private static final Dictionary<String, String> OIDS = new Hashtable<String, String>();

    private AOAlgorithmID() {
    }

    public static String getOID(String string) {
        if (string == null) {
            return null;
        }
        String string2 = OIDS.get(string.toUpperCase(Locale.US));
        if (string2 == null) {
            throw new IllegalArgumentException("Se desconoce el algoritmo '" + string + "'");
        }
        return string2;
    }

    static {
        OIDS.put("SHA1", OID_SHA1);
        OIDS.put("SHA-1", OID_SHA1);
        OIDS.put("SHA", OID_SHA1);
        OIDS.put(OID_SHA1, OID_SHA1);
        OIDS.put("SHA-512", OID_SHA512);
        OIDS.put("SHA512", OID_SHA512);
        OIDS.put(OID_SHA512, OID_SHA512);
        OIDS.put("SHA-256", OID_SHA256);
        OIDS.put("SHA256", OID_SHA256);
        OIDS.put(OID_SHA256, OID_SHA256);
        OIDS.put("SHA-384", OID_SHA384);
        OIDS.put("SHA384", OID_SHA384);
        OIDS.put(OID_SHA384, OID_SHA384);
        OIDS.put("RSA", OID_RSA);
        OIDS.put(OID_RSA, OID_RSA);
    }
}

