/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.padestri.client;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.misc.http.UrlHttpManagerFactory;
import es.gob.afirma.core.misc.http.UrlHttpMethod;
import es.gob.afirma.core.signers.AOPkcs1Signer;
import es.gob.afirma.core.signers.TriphaseData;
import es.gob.afirma.core.signers.TriphaseDataSigner;
import es.gob.afirma.core.signers.TriphaseUtil;
import java.io.IOException;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Properties;
import java.util.logging.Logger;

final class PDFTriPhaseSignerUtil {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String OPERATION_PRESIGN = "pre";
    private static final String OPERATION_POSTSIGN = "post";
    private static final String PARAMETER_NAME_OPERATION = "op";
    private static final String CRYPTO_OPERATION_SIGN = "sign";
    private static final String PARAMETER_NAME_CRYPTO_OPERATION = "cop";
    private static final String HTTP_CGI = "?";
    private static final String HTTP_EQUALS = "=";
    private static final String HTTP_AND = "&";
    private static final String PARAMETER_NAME_DOCID = "doc";
    private static final String PARAMETER_NAME_ALGORITHM = "algo";
    private static final String PARAMETER_NAME_FORMAT = "format";
    private static final String PARAMETER_NAME_CERT = "cert";
    private static final String PARAMETER_NAME_EXTRA_PARAM = "params";
    private static final String PARAMETER_NAME_SESSION_DATA = "session";
    private static final String PADES_FORMAT = "pades";
    private static final String SUCCESS = "OK";

    private PDFTriPhaseSignerUtil() {
    }

    static byte[] doPresign(URL uRL, String string, Certificate[] certificateArray, String string2, Properties properties) throws AOException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(uRL).append(HTTP_CGI).append(PARAMETER_NAME_OPERATION).append(HTTP_EQUALS).append(OPERATION_PRESIGN).append(HTTP_AND).append(PARAMETER_NAME_CRYPTO_OPERATION).append(HTTP_EQUALS).append(CRYPTO_OPERATION_SIGN).append(HTTP_AND).append(PARAMETER_NAME_FORMAT).append(HTTP_EQUALS).append(PADES_FORMAT).append(HTTP_AND).append(PARAMETER_NAME_ALGORITHM).append(HTTP_EQUALS).append(string).append(HTTP_AND).append(PARAMETER_NAME_CERT).append(HTTP_EQUALS).append(TriphaseUtil.prepareCertChainParam(certificateArray, properties)).append(HTTP_AND).append(PARAMETER_NAME_DOCID).append(HTTP_EQUALS).append(string2);
            if (properties.size() > 0) {
                stringBuffer.append(HTTP_AND).append(PARAMETER_NAME_EXTRA_PARAM).append(HTTP_EQUALS).append(AOUtil.properties2Base64(properties));
            }
            return UrlHttpManagerFactory.getInstalledManager().readUrl(stringBuffer.toString(), UrlHttpMethod.POST);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new AOException("Error decodificando el certificado del firmante: " + certificateEncodingException, certificateEncodingException);
        }
        catch (IOException iOException) {
            throw new AOException("Error en la llamada de prefirma al servidor: " + iOException, iOException);
        }
    }

    static byte[] doSign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray) throws AOException {
        TriphaseData triphaseData;
        try {
            triphaseData = TriphaseData.parser(Base64.decode(byArray, 0, byArray.length, true));
        }
        catch (Exception exception) {
            LOGGER.severe("Error al analizar la prefirma enviada por el servidor: " + exception);
            throw new AOException("Error al analizar la prefirma enviada por el servidor", exception);
        }
        return TriphaseDataSigner.doSign(new AOPkcs1Signer(), string, privateKey, certificateArray, triphaseData).toString().getBytes();
    }

    static byte[] doPostSign(String string, URL uRL, String string2, Certificate[] certificateArray, String string3, Properties properties) throws AOException {
        byte[] byArray;
        CharSequence charSequence;
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(uRL).append(HTTP_CGI).append(PARAMETER_NAME_OPERATION).append(HTTP_EQUALS).append(OPERATION_POSTSIGN).append(HTTP_AND).append(PARAMETER_NAME_CRYPTO_OPERATION).append(HTTP_EQUALS).append(CRYPTO_OPERATION_SIGN).append(HTTP_AND).append(PARAMETER_NAME_FORMAT).append(HTTP_EQUALS).append(PADES_FORMAT).append(HTTP_AND).append(PARAMETER_NAME_ALGORITHM).append(HTTP_EQUALS).append(string2).append(HTTP_AND).append(PARAMETER_NAME_CERT).append(HTTP_EQUALS).append(TriphaseUtil.prepareCertChainParam(certificateArray, properties)).append(HTTP_AND).append(PARAMETER_NAME_DOCID).append(HTTP_EQUALS).append(string3).append(HTTP_AND).append(PARAMETER_NAME_SESSION_DATA).append(HTTP_EQUALS).append(string);
            if (properties.size() > 0) {
                ((StringBuffer)charSequence).append(HTTP_AND).append(PARAMETER_NAME_EXTRA_PARAM).append(HTTP_EQUALS).append(AOUtil.properties2Base64(properties));
            }
            byArray = UrlHttpManagerFactory.getInstalledManager().readUrl(((StringBuffer)charSequence).toString(), UrlHttpMethod.POST);
            ((StringBuffer)charSequence).setLength(0);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new AOException("Error decodificando el certificado del firmante: " + certificateEncodingException, certificateEncodingException);
        }
        catch (IOException iOException) {
            throw new AOException("Error en la llamada de postfirma al servidor: " + iOException, iOException);
        }
        charSequence = new String(byArray).trim();
        if (!((String)charSequence).startsWith(SUCCESS)) {
            throw new AOException("La firma trifasica no ha finalizado correctamente: " + new String(byArray));
        }
        try {
            return Base64.decode(((String)charSequence).substring("OK NEWID=".length()), true);
        }
        catch (IOException iOException) {
            LOGGER.warning("El resultado de NEWID del servidor no estaba en Base64: " + iOException);
            throw new AOException("El resultado devuelto por el servidor no es correcto", iOException);
        }
    }
}

