/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.padestri.client;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.AOInvalidFormatException;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.signers.AOSignInfo;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.core.util.tree.AOTreeModel;
import es.gob.afirma.signers.padestri.client.PDFTriPhaseSignerUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Logger;

public final class AOPDFTriPhaseSigner
implements AOSigner {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String PROPERTY_NAME_SIGN_SERVER_URL = "serverUrl";
    private static final String PDF_FILE_HEADER = "%PDF-";
    private static final String PDF_FILE_SUFFIX = ".pdf";
    private static final int PDF_MIN_FILE_SIZE = 70;

    @Override
    public byte[] sign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        URL uRL;
        if (properties == null) {
            throw new IllegalArgumentException("Se necesitan parametros adicionales");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("Es necesario proporcionar la clave privada de firma");
        }
        if (certificateArray == null || certificateArray.length == 0) {
            throw new IllegalArgumentException("Es necesario proporcionar el certificado de firma");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("No se ha proporcionado el identificador de documento a firmar");
        }
        try {
            uRL = new URL(properties.getProperty(PROPERTY_NAME_SIGN_SERVER_URL));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("No se ha proporcionado una URL valida para el servidor de firma: " + properties.getProperty(PROPERTY_NAME_SIGN_SERVER_URL), exception);
        }
        String string2 = Base64.encode(byArray, true);
        byte[] byArray2 = PDFTriPhaseSignerUtil.doPresign(uRL, string, certificateArray, string2, properties);
        try {
            LOGGER.info("Recibido el XML de prefirma PAdES:\n" + new String(Base64.decode(new String(byArray2), true)));
        }
        catch (IOException iOException) {
            LOGGER.warning("La prefirma no esta en el formato esperado: " + iOException);
        }
        String string3 = Base64.encode(PDFTriPhaseSignerUtil.doSign(byArray2, string, privateKey, certificateArray), true);
        return PDFTriPhaseSignerUtil.doPostSign(string3, uRL, string, certificateArray, string2, properties);
    }

    @Override
    public byte[] cosign(byte[] byArray, byte[] byArray2, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        return this.sign(byArray2, string, privateKey, certificateArray, properties);
    }

    @Override
    public byte[] cosign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        return this.sign(byArray, string, privateKey, certificateArray, properties);
    }

    @Override
    public byte[] countersign(byte[] byArray, String string, CounterSignTarget counterSignTarget, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        throw new UnsupportedOperationException("No se soportan contrafirmas en PAdES");
    }

    @Override
    public AOTreeModel getSignersStructure(byte[] byArray, boolean bl) {
        throw new UnsupportedOperationException("No soportado para firmas trifasicas");
    }

    @Override
    public boolean isSign(byte[] byArray) {
        return false;
    }

    @Override
    public boolean isValidDataFile(byte[] byArray) {
        if (byArray == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        return AOPDFTriPhaseSigner.isPdfFile(byArray);
    }

    @Override
    public String getSignedName(String string, String string2) {
        String string3;
        String string4 = string3 = string2 != null ? string2 : "";
        if (string == null) {
            return "signed.pdf";
        }
        if (string.toLowerCase(Locale.ENGLISH).endsWith(PDF_FILE_SUFFIX)) {
            return string.substring(0, string.length() - PDF_FILE_SUFFIX.length()) + string3 + PDF_FILE_SUFFIX;
        }
        return string + string3 + PDF_FILE_SUFFIX;
    }

    @Override
    public byte[] getData(byte[] byArray) throws AOException {
        if (!this.isSign(byArray)) {
            throw new AOInvalidFormatException("El documento introducido no contiene una firma valida");
        }
        return byArray;
    }

    @Override
    public AOSignInfo getSignInfo(byte[] byArray) throws AOException {
        if (byArray == null) {
            throw new IllegalArgumentException("No se han introducido datos para analizar");
        }
        if (!this.isSign(byArray)) {
            throw new AOInvalidFormatException("Los datos introducidos no se corresponden con un objeto de firma");
        }
        return new AOSignInfo("Adobe PDF");
    }

    private static boolean isPdfFile(byte[] byArray) {
        if (byArray == null || byArray.length < 70) {
            return false;
        }
        byte[] byArray2 = new byte[PDF_FILE_HEADER.length()];
        try {
            new ByteArrayInputStream(byArray).read(byArray2);
        }
        catch (Exception exception) {
            LOGGER.warning("El contenido parece corrupto o truncado: " + exception);
            return false;
        }
        return PDF_FILE_HEADER.equals(new String(byArray2));
    }
}

