/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.pades;

import com.aowagie.text.DocumentException;
import com.aowagie.text.pdf.PdfDate;
import com.aowagie.text.pdf.PdfReader;
import com.aowagie.text.pdf.PdfStamper;
import es.gob.afirma.signers.pades.AOPDFSigner;
import es.gob.afirma.signers.pades.PdfUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class XmpHelper {
    private static final String TAG_UUID = "$$UUID$$";
    private static final String TAG_DATE = "$$DATE$$";
    private static final String XML_TAG_MODIFYDATE_START = "<xmp:ModifyDate>";
    private static final String XML_TAG_MODIFYDATE_END = "</xmp:ModifyDate>";
    private static final String XML_TAG_CREATEDATE_START = "<xmp:CreateDate>";
    private static final String XML_TAG_CREATEDATE_END = "</xmp:CreateDate>";
    private static final String PROCESSING_INSTRUCTION_SUFFIX = "?>";
    private static final Charset DEFAULT_ENCODING = StandardCharsets.UTF_8;
    private static final String NEW_HISTORY_LIST_ITEM = "<rdf:li rdf:parseType=\"Resource\">\n  <stEvt:action>signed</stEvt:action>\n  <stEvt:instanceID>uuid:$$UUID$$</stEvt:instanceID>\n  <stEvt:parameters>Firmado por el Cliente @firma</stEvt:parameters>\n  <stEvt:softwareAgent>Cliente @firma</stEvt:softwareAgent>\n  <stEvt:when>$$DATE$$</stEvt:when>\n</rdf:li>";

    XmpHelper() {
    }

    private static String getOriginalCreationDateAsW3C(byte[] byArray) {
        String string = new String(byArray);
        int n = string.indexOf("/CreationDate");
        if (n == -1) {
            return null;
        }
        n += "/CreationDate".length();
        if ((n = string.indexOf("(", n)) == -1) {
            return null;
        }
        int n2 = string.indexOf(")", n += "(".length());
        if (n2 == -1) {
            return null;
        }
        String string2 = string.substring(n, n2).trim();
        return PdfDate.getW3CDate(string2);
    }

    static byte[] addSignHistoryToXmp(byte[] byArray, Calendar calendar) throws DOMException, SAXException, IOException, ParserConfigurationException {
        PdfStamper pdfStamper;
        Node node;
        Node node2;
        String string = XmpHelper.getOriginalCreationDateAsW3C(byArray);
        PdfReader pdfReader = new PdfReader(byArray);
        byte[] byArray2 = pdfReader.getMetadata();
        if (!PdfUtil.isPdfAx(byArray2) || new AOPDFSigner().isSign(byArray)) {
            pdfReader.close();
            return byArray;
        }
        String string2 = new String(byArray2, DEFAULT_ENCODING);
        String string3 = string2.substring(0, string2.indexOf(PROCESSING_INSTRUCTION_SUFFIX) + PROCESSING_INSTRUCTION_SUFFIX.length());
        String string4 = string2.substring(string2.lastIndexOf("<?"), string2.length());
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.parse(new ByteArrayInputStream(byArray2));
        String string5 = NEW_HISTORY_LIST_ITEM.replace(TAG_UUID, UUID.nameUUIDFromBytes(BigInteger.valueOf(calendar.getTimeInMillis()).toByteArray()).toString()).replace(TAG_DATE, new PdfDate(calendar).getW3CDate());
        NodeList nodeList = document.getElementsByTagName("xmpMM:History");
        if (nodeList.getLength() != 1) {
            nodeList = document.getElementsByTagName("pdfaid:conformance");
            if (nodeList.getLength() != 1) {
                throw new IllegalStateException("El PDF no tiene una entrada RDF XMP valida");
            }
            node2 = nodeList.item(0).getParentNode();
            string5 = "<xmpMM:History xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:xmpMM=\"http://ns.adobe.com/xap/1.0/mm/\" xmlns:stEvt=\"http://ns.adobe.com/xap/1.0/sType/ResourceEvent#\"><rdf:Seq>" + string5 + "</rdf:Seq></xmpMM:History>";
        } else {
            node = (Element)nodeList.item(0);
            if ((nodeList = node.getElementsByTagName("rdf:Seq")).getLength() != 1) {
                nodeList = document.getElementsByTagName("xmpMM:History");
                string5 = "<rdf:Seq xmlns:stEvt=\"http://ns.adobe.com/xap/1.0/sType/ResourceEvent#\">" + string5 + "</rdf:Seq>";
            }
            node2 = nodeList.item(0);
        }
        node = document.importNode(documentBuilder.parse(new InputSource(new StringReader(string5))).getDocumentElement(), true);
        node2.appendChild(node);
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>(1);
        concurrentHashMap.put("encoding", DEFAULT_ENCODING.name());
        String string6 = new String(XmpHelper.writeXml(document.getDocumentElement()), DEFAULT_ENCODING);
        string6 = string6.replace(string6.substring(0, string6.indexOf(PROCESSING_INSTRUCTION_SUFFIX) + PROCESSING_INSTRUCTION_SUFFIX.length()), string3).concat(string4);
        int n = string6.indexOf(XML_TAG_MODIFYDATE_START);
        if (n != -1) {
            string6 = string6.replace(string6.substring(n + XML_TAG_MODIFYDATE_START.length(), string6.indexOf(XML_TAG_MODIFYDATE_END)), new PdfDate(calendar).getW3CDate());
        }
        if (string != null) {
            string6 = string6.replace(string6.substring(string6.indexOf(XML_TAG_CREATEDATE_START) + XML_TAG_CREATEDATE_START.length(), string6.indexOf(XML_TAG_CREATEDATE_END)), string);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            pdfStamper = new PdfStamper(pdfReader, byteArrayOutputStream, calendar);
        }
        catch (DocumentException documentException) {
            throw new IOException(documentException);
        }
        try {
            pdfStamper.setXmpMetadata(string6.getBytes(DEFAULT_ENCODING));
            pdfStamper.close(calendar);
        }
        catch (DocumentException documentException) {
            throw new IOException(documentException);
        }
        pdfReader.close();
        Logger.getLogger("es.gob.afirma").info("Se ha registrado la firma en el historico XMP del PDF");
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] writeXml(Node node) {
        DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)((Object)node.getOwnerDocument().getImplementation());
        LSSerializer lSSerializer = dOMImplementationLS.createLSSerializer();
        DOMConfiguration dOMConfiguration = lSSerializer.getDomConfig();
        if (dOMConfiguration.canSetParameter("namespaces", Boolean.FALSE)) {
            dOMConfiguration.setParameter("namespaces", Boolean.FALSE);
        }
        if (dOMConfiguration.canSetParameter("canonical-form", Boolean.TRUE)) {
            lSSerializer.getDomConfig().setParameter("canonical-form", Boolean.TRUE);
        }
        LSOutput lSOutput = dOMImplementationLS.createLSOutput();
        lSOutput.setEncoding(DEFAULT_ENCODING.name());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        lSOutput.setByteStream(byteArrayOutputStream);
        lSSerializer.write(node, lSOutput);
        return byteArrayOutputStream.toByteArray();
    }
}

