/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.pades;

import com.aowagie.text.DocumentException;
import com.aowagie.text.Font;
import com.aowagie.text.Image;
import com.aowagie.text.Rectangle;
import com.aowagie.text.pdf.ByteBuffer;
import com.aowagie.text.pdf.PdfSignatureAppearance;
import com.aowagie.text.pdf.PdfStamper;
import com.aowagie.text.pdf.PdfTemplate;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.signers.pades.PdfUtil;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

final class PdfVisibleAreasUtils {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final int DEFAULT_LAYER_2_FONT_SIZE = 12;
    private static final int COURIER = 0;
    private static final int UNDEFINED = -1;
    private static final String BLACK = "black";
    private static final String LAYERTEXT_TAG_DELIMITER = "$$";
    private static final String LAYERTEXT_TAG_DATE_PREFIX = "$$SIGNDATE";
    private static final String LAYERTEXT_TAG_DATE_DELIMITER = "=";
    private static final String LAYERTEXT_TAG_SUBJECTCN = "$$SUBJECTCN$$";
    private static final String LAYERTEXT_TAG_SUBJECTDN = "$$SUBJECTDN$$";
    private static final String LAYERTEXT_TAG_ISSUERCN = "$$ISSUERCN$$";
    private static final String LAYERTEXT_TAG_CERTSERIAL = "$$CERTSERIAL$$";
    private static final String LAYERTEXT_TAG_GIVENNAME = "$$GIVENNAME$$";
    private static final String LAYERTEXT_TAG_SURNAME = "$$SURNAME$$";
    private static final String LAYERTEXT_TAG_ORGANIZATION = "$$ORGANIZATION$$";
    private static final String LAYERTEXT_TAG_REASON = "$$REASON$$";
    private static final String LAYERTEXT_TAG_LOCATION = "$$LOCATION$$";
    private static final String LAYERTEXT_TAG_CONTACT = "$$CONTACT$$";
    private static final Map<String, ColorValues> COLORS = new HashMap<String, ColorValues>(7);

    private PdfVisibleAreasUtils() {
    }

    static Font getFont(int n, int n2, int n3, String string) {
        String string2 = string != null ? string.toLowerCase() : BLACK;
        ColorValues colorValues = COLORS.get(string2) != null ? COLORS.get(string2) : COLORS.get(BLACK);
        try {
            Class<?> clazz = Platform.getOS() == Platform.OS.ANDROID ? Class.forName("harmony.java.awt.Color") : Class.forName("java.awt.Color");
            Object obj = clazz.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(colorValues.getR(), colorValues.getG(), colorValues.getB());
            return (Font)Font.class.getConstructor(Integer.TYPE, Float.TYPE, Integer.TYPE, clazz).newInstance(n == -1 ? 0 : n, Float.valueOf(n2 == -1 ? 12.0f : (float)n2), n3 == -1 ? 0 : n3, obj);
        }
        catch (Exception exception) {
            LOGGER.warning("Error estableciendo el color del tipo de letra para la firma visible PDF, se usara el por defecto: " + exception);
            return new Font(n == -1 ? 0 : n, n2 == -1 ? 12.0f : (float)n2, n3 == -1 ? 0 : n3, null);
        }
    }

    static String getLayerText(String string, X509Certificate x509Certificate, Calendar calendar, String string2, String string3, String string4) {
        Object object;
        String string5;
        String string6;
        if (string == null) {
            return null;
        }
        String string7 = string;
        if (x509Certificate != null) {
            string7 = string7.replace(LAYERTEXT_TAG_SUBJECTCN, AOUtil.getCN(x509Certificate)).replace(LAYERTEXT_TAG_ISSUERCN, AOUtil.getCN(x509Certificate.getIssuerX500Principal().getName())).replace(LAYERTEXT_TAG_CERTSERIAL, x509Certificate.getSerialNumber().toString());
            String string8 = x509Certificate.getSubjectX500Principal().toString();
            string7 = string7.replace(LAYERTEXT_TAG_SUBJECTDN, x509Certificate.getSubjectX500Principal().toString());
            string6 = AOUtil.getRDNvalueFromLdapName("GIVENNAME", string8);
            string7 = string7.replace(LAYERTEXT_TAG_GIVENNAME, string6 != null ? string6 : "");
            string5 = AOUtil.getRDNvalueFromLdapName("SURNAME", string8);
            string7 = string7.replace(LAYERTEXT_TAG_SURNAME, string5 != null ? string5 : "");
            object = AOUtil.getRDNvalueFromLdapName("o", string8);
            string7 = string7.replace(LAYERTEXT_TAG_ORGANIZATION, (CharSequence)(object != null ? object : ""));
        }
        string7 = string7.replace(LAYERTEXT_TAG_REASON, string2 != null ? string2 : "");
        string7 = string7.replace(LAYERTEXT_TAG_LOCATION, string3 != null ? string3 : "");
        string7 = string7.replace(LAYERTEXT_TAG_CONTACT, string4 != null ? string4 : "");
        if (string.contains(LAYERTEXT_TAG_DATE_PREFIX)) {
            int n = string.indexOf(LAYERTEXT_TAG_DATE_PREFIX);
            string6 = string.substring(n, string.indexOf(LAYERTEXT_TAG_DELIMITER, n + LAYERTEXT_TAG_DATE_PREFIX.length()) + LAYERTEXT_TAG_DELIMITER.length());
            Object object2 = object = calendar != null ? calendar.getTime() : new Date();
            if (string6.contains(LAYERTEXT_TAG_DATE_DELIMITER)) {
                String string9 = string6.replace(LAYERTEXT_TAG_DELIMITER, "").split(LAYERTEXT_TAG_DATE_DELIMITER)[1];
                try {
                    string5 = new SimpleDateFormat(string9).format((Date)object);
                }
                catch (Exception exception) {
                    LOGGER.warning("Patron incorrecto para la fecha de firma en la firma visible (" + string9 + "), se usara el por defecto: " + exception);
                    string5 = new SimpleDateFormat().format((Date)object);
                }
            } else {
                string5 = new SimpleDateFormat().format((Date)object);
            }
            string7 = string7.replace(string6, string5);
        }
        return string7;
    }

    static void setVisibleSignatureRotated(PdfStamper pdfStamper, PdfSignatureAppearance pdfSignatureAppearance, Rectangle rectangle, int n, String string, int n2) throws DocumentException, IOException {
        float f = rectangle.getHeight();
        float f2 = rectangle.getWidth();
        float f3 = rectangle.getLeft();
        float f4 = rectangle.getBottom();
        pdfSignatureAppearance.setVisibleSignature(new Rectangle(0.0f, 0.0f, f2, f), n, null);
        pdfSignatureAppearance.getAppearance();
        pdfSignatureAppearance.setVisibleSignature(new Rectangle(f3, f4, f3 + f2, f4 + f), n, string);
        pdfSignatureAppearance.getTopLayer().setWidth(f2);
        pdfSignatureAppearance.getTopLayer().setHeight(f);
        PdfTemplate pdfTemplate = pdfSignatureAppearance.getLayer(2);
        pdfTemplate.setWidth(f2);
        pdfTemplate.setHeight(f);
        PdfTemplate pdfTemplate2 = PdfTemplate.createTemplate(pdfStamper.getWriter(), f2, f);
        try (ByteBuffer byteBuffer = pdfTemplate2.getInternalBuffer();){
            byteBuffer.write(pdfTemplate.toString().getBytes());
            pdfTemplate.reset();
            Image image = Image.getInstance(pdfTemplate2);
            image.setInterpolation(true);
            image.scaleAbsolute(f, f2);
            image.setRotationDegrees(n2);
            image.setAbsolutePosition(0.0f, 0.0f);
            pdfTemplate.addImage(image);
        }
    }

    static Rectangle getSignaturePositionOnPage(Properties properties) {
        return PdfUtil.getPositionOnPage(properties, "signature");
    }

    static {
        COLORS.put(BLACK, new ColorValues(0, 0, 0));
        COLORS.put("white", new ColorValues(255, 255, 255));
        COLORS.put("lightGray", new ColorValues(192, 192, 192));
        COLORS.put("gray", new ColorValues(128, 128, 128));
        COLORS.put("darkGray", new ColorValues(64, 64, 64));
        COLORS.put("red", new ColorValues(255, 0, 0));
        COLORS.put("pink", new ColorValues(255, 175, 175));
    }

    private static final class ColorValues {
        private final int r;
        private final int g;
        private final int b;

        ColorValues(int n, int n2, int n3) {
            this.r = n;
            this.g = n2;
            this.b = n3;
        }

        int getR() {
            return this.r;
        }

        int getG() {
            return this.g;
        }

        int getB() {
            return this.b;
        }
    }
}

