/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.pades;

import com.aowagie.text.Rectangle;
import com.aowagie.text.exceptions.BadPasswordException;
import com.aowagie.text.pdf.AcroFields;
import com.aowagie.text.pdf.PdfArray;
import com.aowagie.text.pdf.PdfDeveloperExtension;
import com.aowagie.text.pdf.PdfDictionary;
import com.aowagie.text.pdf.PdfName;
import com.aowagie.text.pdf.PdfObject;
import com.aowagie.text.pdf.PdfReader;
import com.aowagie.text.pdf.PdfStamper;
import com.aowagie.text.pdf.PdfString;
import com.aowagie.text.pdf.PdfWriter;
import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.ui.AOUIFactory;
import es.gob.afirma.signers.pades.BadPdfPasswordException;
import es.gob.afirma.signers.pades.CommonPdfMessages;
import es.gob.afirma.signers.pades.InvalidPdfException;
import es.gob.afirma.signers.pades.PdfIsCertifiedException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;

public final class PdfUtil {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String FILTER_ADOBE_PKCS7_DETACHED = "/adbe.pkcs7.detached";
    private static final Set<String> SUPPORTED_SUBFILTERS = new HashSet<String>();

    private PdfUtil() {
    }

    static boolean isPdfA1(byte[] byArray) {
        if (byArray == null) {
            return false;
        }
        String string = new String(byArray);
        return string.replace("\n", "").replace("\r", "").replace("\t", "").replace(" ", "").contains("<pdfaid:part>1</pdfaid:part>");
    }

    static boolean isPdfAx(byte[] byArray) {
        if (byArray == null) {
            return false;
        }
        String string = new String(byArray);
        return string.replace("\n", "").replace("\r", "").replace("\t", "").replace(" ", "").contains("<pdfaid:part>");
    }

    static GregorianCalendar getSignTime(String string) {
        Date date;
        if (string == null) {
            return new GregorianCalendar();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy:MM:dd:HH:mm:ss");
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (Exception exception) {
            LOGGER.severe("La fecha indicada ('" + string + "') como momento de firma para PAdES no sigue el patron 'yyyy:MM:dd:HH:mm:ss': " + exception);
            return new GregorianCalendar();
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        return gregorianCalendar;
    }

    static PdfReader getPdfReader(byte[] byArray, Properties properties, boolean bl) throws BadPdfPasswordException, InvalidPdfException, IOException {
        PdfReader pdfReader;
        Properties properties2 = properties != null ? properties : new Properties();
        String string = properties2.getProperty("ownerPassword");
        String string2 = properties2.getProperty("userPassword");
        try {
            pdfReader = string != null ? new PdfReader(byArray, string.getBytes()) : (string2 != null ? new PdfReader(byArray, string2.getBytes()) : new PdfReader(byArray));
        }
        catch (BadPasswordException badPasswordException) {
            if (bl) {
                throw new BadPdfPasswordException(badPasswordException);
            }
            String string3 = new String(AOUIFactory.getPassword(string == null ? CommonPdfMessages.getString("AOPDFSigner.0") : CommonPdfMessages.getString("AOPDFSigner.1"), null));
            if (string3.isEmpty()) {
                throw new AOCancelledOperationException("Entrada de contrasena de PDF cancelada por el usuario", badPasswordException);
            }
            try {
                pdfReader = new PdfReader(byArray, string3.getBytes());
            }
            catch (BadPasswordException badPasswordException2) {
                throw new BadPdfPasswordException(badPasswordException2);
            }
            properties2.put("ownerPassword", string3);
        }
        catch (IOException iOException) {
            throw new InvalidPdfException(iOException);
        }
        return pdfReader;
    }

    static void checkPdfCertification(int n, Properties properties) throws PdfIsCertifiedException {
        if (n != 0) {
            String string = properties.getProperty("allowSigningCertifiedPdfs");
            if ("true".equalsIgnoreCase(string)) {
                return;
            }
            if ("false".equalsIgnoreCase(string)) {
                throw new PdfIsCertifiedException();
            }
            if (Boolean.parseBoolean(properties.getProperty("headless"))) {
                throw new PdfIsCertifiedException();
            }
            if (AOUIFactory.NO_OPTION == AOUIFactory.showConfirmDialog(null, CommonPdfMessages.getString("AOPDFSigner.8"), CommonPdfMessages.getString("AOPDFSigner.9"), AOUIFactory.YES_NO_OPTION, AOUIFactory.WARNING_MESSAGE)) {
                throw new AOCancelledOperationException("El usuario no ha permitido la firma de un PDF certificado");
            }
            properties.setProperty("allowSigningCertifiedPdfs", "true");
        }
    }

    static void enableLtv(PdfStamper pdfStamper) {
        pdfStamper.getWriter().addDeveloperExtension(new PdfDeveloperExtension(new PdfName("ESIC"), PdfWriter.PDF_VERSION_1_7, 1));
    }

    static boolean getAppendMode(Properties properties, PdfReader pdfReader) {
        if (properties.getProperty("ownerPassword") != null || properties.getProperty("userPassword") != null) {
            return true;
        }
        return Boolean.parseBoolean(properties.getProperty("alwaysCreateRevision")) || pdfReader.getAcroFields().getSignatureNames().size() > 0;
    }

    static boolean pdfHasUnregisteredSignatures(byte[] byArray, Properties properties) throws InvalidPdfException, BadPdfPasswordException, IOException {
        Properties properties2 = properties != null ? properties : new Properties();
        PdfReader pdfReader = PdfUtil.getPdfReader(byArray, properties2, Boolean.parseBoolean(properties2.getProperty("headless")));
        return PdfUtil.pdfHasUnregisteredSignatures(pdfReader);
    }

    static String getFirstSupportedSignSubFilter(byte[] byArray, Properties properties) throws IOException, InvalidPdfException, BadPdfPasswordException {
        if (byArray == null) {
            throw new IllegalArgumentException("El PDF de entrada no puede ser nulo");
        }
        Properties properties2 = properties != null ? properties : new Properties();
        PdfReader pdfReader = PdfUtil.getPdfReader(byArray, properties2, Boolean.parseBoolean(properties2.getProperty("headless")));
        for (int i = 0; i < pdfReader.getXrefSize(); ++i) {
            String string;
            PdfDictionary pdfDictionary;
            PdfObject pdfObject = pdfReader.getPdfObject(i);
            if (pdfObject == null || !pdfObject.isDictionary() || !PdfName.SIG.equals((pdfDictionary = (PdfDictionary)pdfObject).get(PdfName.TYPE))) continue;
            String string2 = string = pdfDictionary.get(PdfName.SUBFILTER) != null ? pdfDictionary.get(PdfName.SUBFILTER).toString() : null;
            if (!SUPPORTED_SUBFILTERS.contains(string)) continue;
            return string;
        }
        LOGGER.info("No se ha encontrado ningun filtro de firma soportado, se devolvera null");
        return null;
    }

    static boolean pdfHasUnregisteredSignatures(PdfReader pdfReader) {
        boolean bl = false;
        for (int i = 0; i < pdfReader.getXrefSize(); ++i) {
            String string;
            PdfDictionary pdfDictionary;
            PdfObject pdfObject = pdfReader.getPdfObject(i);
            if (pdfObject == null || !pdfObject.isDictionary() || !PdfName.SIG.equals((pdfDictionary = (PdfDictionary)pdfObject).get(PdfName.TYPE))) continue;
            String string2 = string = pdfDictionary.get(PdfName.SUBFILTER) != null ? pdfDictionary.get(PdfName.SUBFILTER).toString() : null;
            if (string != null && SUPPORTED_SUBFILTERS.contains(string)) continue;
            bl = true;
            try {
                PdfObject pdfObject2 = pdfDictionary.get(PdfName.CERT);
                byte[] byArray = pdfObject2 instanceof PdfString ? ((PdfString)pdfObject2).getOriginalBytes() : ((PdfString)((PdfArray)pdfDictionary.get(PdfName.CERT)).getArrayList().get(0)).getOriginalBytes();
                X509Certificate x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(byArray));
                LOGGER.info("Encontrada firma no registrada, hecha con certificado emitido por: " + x509Certificate.getIssuerX500Principal().toString());
                continue;
            }
            catch (Exception exception) {
                LOGGER.warning("No se ha podido comprobar la identidad de una firma no registrada con el subfiltro: " + string + ": " + exception);
            }
        }
        return bl;
    }

    public static List<SignatureField> getPdfEmptySignatureFields(byte[] byArray) {
        PdfReader pdfReader;
        if (byArray == null) {
            return new ArrayList<SignatureField>(0);
        }
        try {
            pdfReader = new PdfReader(byArray);
        }
        catch (Exception exception) {
            LOGGER.severe("Error leyendo el PDF de entrada: " + exception);
            return new ArrayList<SignatureField>(0);
        }
        AcroFields acroFields = pdfReader.getAcroFields();
        if (acroFields != null) {
            List<String> list = acroFields.getBlankSignatureNames();
            ArrayList<SignatureField> arrayList = new ArrayList<SignatureField>();
            if (list != null) {
                for (String string : list) {
                    float[] fArray = acroFields.getFieldPositions(string);
                    if (fArray == null || fArray.length < 5) continue;
                    arrayList.add(new SignatureField(Math.round(fArray[0]), Math.round(fArray[1]), Math.round(fArray[2]), Math.round(fArray[3]), Math.round(fArray[4]), string));
                }
                return arrayList;
            }
        }
        return new ArrayList<SignatureField>(0);
    }

    public static Rectangle getPositionOnPage(Properties properties, String string) {
        if (properties == null || string == null) {
            LOGGER.severe("Se ha pedido una posicion para un elemento grafico nulo");
            return null;
        }
        if (properties.getProperty(string + "PositionOnPageLowerLeftX") != null && properties.getProperty(string + "PositionOnPageLowerLeftY") != null && properties.getProperty(string + "PositionOnPageUpperRightX") != null && properties.getProperty(string + "PositionOnPageUpperRightY") != null) {
            try {
                return new Rectangle(Integer.parseInt(properties.getProperty(string + "PositionOnPageLowerLeftX").trim()), Integer.parseInt(properties.getProperty(string + "PositionOnPageLowerLeftY").trim()), Integer.parseInt(properties.getProperty(string + "PositionOnPageUpperRightX").trim()), Integer.parseInt(properties.getProperty(string + "PositionOnPageUpperRightY").trim()));
            }
            catch (Exception exception) {
                LOGGER.severe("Se ha indicado una posicion invalida para el elemento grafico '" + string + "': " + exception);
            }
        }
        return null;
    }

    static {
        SUPPORTED_SUBFILTERS.add("/ETSI.RFC3161");
        SUPPORTED_SUBFILTERS.add(FILTER_ADOBE_PKCS7_DETACHED);
        SUPPORTED_SUBFILTERS.add("/ETSI.CAdES.detached");
        SUPPORTED_SUBFILTERS.add("/adbe.pkcs7.sha1");
    }

    public static final class SignatureField {
        private final int signaturePositionOnPageLowerLeftX;
        private final int signaturePositionOnPageLowerLeftY;
        private final int signaturePositionOnPageUpperRightX;
        private final int signaturePositionOnPageUpperRightY;
        private final int page;
        private final String name;

        public SignatureField(int n, int n2, int n3, int n4, int n5, String string) {
            if (string == null) {
                throw new IllegalArgumentException("El campo de firma debe tener un nombre no nulo");
            }
            this.signaturePositionOnPageLowerLeftX = n2;
            this.signaturePositionOnPageLowerLeftY = n3;
            this.signaturePositionOnPageUpperRightX = n4;
            this.signaturePositionOnPageUpperRightY = n5;
            this.page = n;
            this.name = string;
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public int getPage() {
            return this.page;
        }

        public int getSignaturePositionOnPageUpperRightX() {
            return this.signaturePositionOnPageUpperRightX;
        }

        public int getSignaturePositionOnPageUpperRightY() {
            return this.signaturePositionOnPageUpperRightY;
        }

        public int getSignaturePositionOnPageLowerLeftY() {
            return this.signaturePositionOnPageLowerLeftY;
        }

        public int getSignaturePositionOnPageLowerLeftX() {
            return this.signaturePositionOnPageLowerLeftX;
        }
    }
}

