/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.pades;

import com.aowagie.text.DocumentException;
import com.aowagie.text.exceptions.BadPasswordException;
import com.aowagie.text.pdf.PdfDate;
import com.aowagie.text.pdf.PdfDictionary;
import com.aowagie.text.pdf.PdfName;
import com.aowagie.text.pdf.PdfReader;
import com.aowagie.text.pdf.PdfSignature;
import com.aowagie.text.pdf.PdfSignatureAppearance;
import com.aowagie.text.pdf.PdfStamper;
import com.aowagie.text.pdf.PdfString;
import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.signers.pades.PdfIsPasswordProtectedException;
import es.gob.afirma.signers.pades.PdfUtil;
import es.gob.afirma.signers.tsp.pkcs7.CMSTimestamper;
import es.gob.afirma.signers.tsp.pkcs7.TsaParams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Logger;

public final class PdfTimestamper {
    private static final String TIMESTAMP_SUBFILTER = "ETSI.RFC3161";
    private static final int CSIZE = 27000;
    private static final int UNDEFINED = -1;
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final int PDF_MAX_VERSION = 7;
    private static final int PDF_MIN_VERSION = 2;
    private static final int PDF_MIN_COMPRESABLE_VERSION = 5;

    private PdfTimestamper() {
    }

    public static byte[] timestampPdf(byte[] byArray, Properties properties, Calendar calendar) throws AOException, IOException, NoSuchAlgorithmException {
        if (properties != null) {
            String string = properties.getProperty("tsaURL");
            String string2 = properties.getProperty("tsType");
            if (string != null && ("2".equals(string2) || "3".equals(string2))) {
                int n;
                PdfReader pdfReader = PdfUtil.getPdfReader(byArray, properties, Boolean.parseBoolean(properties.getProperty("headless")));
                PdfUtil.checkPdfCertification(pdfReader.getCertificationLevel(), properties);
                try {
                    n = properties.getProperty("pdfVersion") != null ? Integer.parseInt(properties.getProperty("pdfVersion").trim()) : 7;
                }
                catch (Exception exception) {
                    LOGGER.warning("Error en el establecimiento de la version PDF, se usara 7: " + exception);
                    n = 7;
                }
                if (n != -1 && (n < 2 || n > 7)) {
                    LOGGER.warning("Se ha establecido un valor invalido para version, se ignorara: " + n);
                    n = -1;
                }
                try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                    PdfStamper pdfStamper;
                    try {
                        pdfStamper = PdfStamper.createSignature(pdfReader, byteArrayOutputStream, n == -1 ? (char)'\u0000' : Integer.toString(n).toCharArray()[0], null, PdfUtil.getAppendMode(properties, pdfReader), calendar);
                    }
                    catch (BadPasswordException badPasswordException) {
                        throw new PdfIsPasswordProtectedException(badPasswordException);
                    }
                    catch (DocumentException documentException) {
                        throw new AOException("Error de formato en el PDF de entrada: " + documentException, documentException);
                    }
                    PdfSignatureAppearance pdfSignatureAppearance = pdfStamper.getSignatureAppearance();
                    if (n >= 5 && !"false".equalsIgnoreCase(properties.getProperty("compressPdf"))) {
                        pdfStamper.setFullCompression();
                    }
                    PdfUtil.enableLtv(pdfStamper);
                    pdfSignatureAppearance.setAcro6Layers(true);
                    pdfSignatureAppearance.setRender(0);
                    pdfSignatureAppearance.setSignDate(calendar);
                    PdfSignature pdfSignature = new PdfSignature(PdfName.ADOBE_PPKLITE, new PdfName(TIMESTAMP_SUBFILTER));
                    pdfSignature.setDate(new PdfDate(calendar));
                    pdfSignatureAppearance.setCryptoDictionary(pdfSignature);
                    HashMap<PdfName, Integer> hashMap = new HashMap<PdfName, Integer>();
                    hashMap.put(PdfName.CONTENTS, 54002);
                    try {
                        pdfSignatureAppearance.preClose(hashMap, calendar);
                    }
                    catch (DocumentException documentException) {
                        throw new AOException("Error en el procesado del PDF: " + documentException, documentException);
                    }
                    byte[] byArray2 = AOUtil.getDataFromInputStream(pdfSignatureAppearance.getRangeStream());
                    byte[] byArray3 = PdfTimestamper.getTspToken(properties, byArray2, calendar);
                    byte[] byArray4 = new byte[27000];
                    if (byArray3.length > 27000) {
                        throw new AOException("El tamano del sello de tiempo (" + byArray3.length + ") supera el maximo permitido para un PDF (" + 27000 + ")");
                    }
                    PdfDictionary pdfDictionary = new PdfDictionary();
                    System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
                    pdfDictionary.put(PdfName.CONTENTS, new PdfString(byArray4).setHexWriting(true));
                    try {
                        pdfSignatureAppearance.close(pdfDictionary);
                    }
                    catch (Exception exception) {
                        byteArrayOutputStream.close();
                        throw new AOException("Error al cerrar el PDF para finalizar el proceso de firma", exception);
                    }
                    byte[] byArray5 = byteArrayOutputStream.toByteArray();
                    return byArray5;
                }
            }
        }
        return byArray;
    }

    private static byte[] getTspToken(Properties properties, byte[] byArray, Calendar calendar) throws AOException, NoSuchAlgorithmException, IOException {
        TsaParams tsaParams = new TsaParams(properties);
        CMSTimestamper cMSTimestamper = new CMSTimestamper(tsaParams);
        return cMSTimestamper.getTimeStampToken(MessageDigest.getInstance(tsaParams.getTsaHashAlgorithm()).digest(byArray), tsaParams.getTsaHashAlgorithm(), calendar);
    }
}

