/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.pades;

import com.aowagie.text.DocumentException;
import com.aowagie.text.Image;
import com.aowagie.text.Rectangle;
import com.aowagie.text.exceptions.BadPasswordException;
import com.aowagie.text.pdf.PdfDate;
import com.aowagie.text.pdf.PdfName;
import com.aowagie.text.pdf.PdfObject;
import com.aowagie.text.pdf.PdfPKCS7;
import com.aowagie.text.pdf.PdfReader;
import com.aowagie.text.pdf.PdfSignature;
import com.aowagie.text.pdf.PdfSignatureAppearance;
import com.aowagie.text.pdf.PdfStamper;
import com.aowagie.text.pdf.PdfStamperImp;
import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.AOException;
import es.gob.afirma.core.ui.AOUIFactory;
import es.gob.afirma.signers.pades.BadPdfPasswordException;
import es.gob.afirma.signers.pades.CommonPdfMessages;
import es.gob.afirma.signers.pades.InvalidPdfException;
import es.gob.afirma.signers.pades.PdfHasUnregisteredSignaturesException;
import es.gob.afirma.signers.pades.PdfPreProcessor;
import es.gob.afirma.signers.pades.PdfTriPhaseSession;
import es.gob.afirma.signers.pades.PdfUtil;
import es.gob.afirma.signers.pades.PdfVisibleAreasUtils;
import es.gob.afirma.signers.pades.XmpHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Logger;

public final class PdfSessionManager {
    static final int LAST_PAGE = -1;
    static final int NEW_PAGE = -2;
    private static final int UNDEFINED = -1;
    private static final int CSIZE = 27000;
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final int PDF_MAX_VERSION = 7;
    private static final int PDF_MIN_VERSION = 2;
    private static final int DEFAULT_SIGNATURE_ROTATION = 90;

    private PdfSessionManager() {
    }

    public static PdfTriPhaseSession getSessionData(byte[] byArray, Certificate[] certificateArray, Calendar calendar, Properties properties) throws IOException, InvalidPdfException, AOException {
        boolean bl;
        PdfStamper pdfStamper;
        byte[] byArray2;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Properties properties2 = properties != null ? properties : new Properties();
        boolean bl2 = Boolean.parseBoolean(properties2.getProperty("doNotUseCertChainOnPostSign"));
        boolean bl3 = Boolean.parseBoolean(properties2.getProperty("signatureRotation"));
        Image image = PdfPreProcessor.getImage(properties2.getProperty("signatureRubricImage"));
        String string = properties2.getProperty("signReason");
        String string2 = properties2.getProperty("signatureField");
        String string3 = properties2.getProperty("signatureProductionCity");
        String string4 = properties2.getProperty("signerContact");
        int n6 = -1;
        String string5 = properties2.getProperty("signaturePage", Integer.toString(-1));
        if ("append".equalsIgnoreCase(string5)) {
            n6 = -2;
        } else {
            try {
                n6 = Integer.parseInt(string5.trim());
            }
            catch (Exception exception) {
                LOGGER.warning("Se ha indicado un numero de pagina invalido ('" + string5 + "'), se usara la ultima pagina: " + exception);
            }
        }
        String string6 = properties2.getProperty("policyIdentifier");
        String string7 = properties2.getProperty("signatureSubFilter");
        if (string6 != null) {
            string7 = "ETSI.CAdES.detached";
            properties2.setProperty("signatureSubFilter", "ETSI.CAdES.detached");
        }
        try {
            n5 = properties2.getProperty("certificationLevel") != null ? Integer.parseInt(properties2.getProperty("certificationLevel").trim()) : -1;
        }
        catch (Exception exception) {
            LOGGER.warning("Se ha indicado un nivel de certificacion no valido ('" + properties2.getProperty("certificationLevel") + "'): " + exception);
            n5 = -1;
        }
        try {
            n4 = properties2.getProperty("pdfVersion") != null ? Integer.parseInt(properties2.getProperty("pdfVersion").trim()) : 7;
        }
        catch (Exception exception) {
            LOGGER.warning("Error en el establecimiento de la version PDF, se usara 7: " + exception);
            n4 = 7;
        }
        if (n4 != -1 && (n4 < 2 || n4 > 7)) {
            LOGGER.warning("Se ha establecido un valor invalido para version, se ignorara: " + n4);
            n4 = -1;
        }
        String string8 = PdfVisibleAreasUtils.getLayerText(properties2.getProperty("layer4Text"), certificateArray != null && certificateArray.length > 0 ? (X509Certificate)certificateArray[0] : null, calendar, string, string3, string4);
        String string9 = PdfVisibleAreasUtils.getLayerText(properties2.getProperty("layer2Text"), certificateArray != null && certificateArray.length > 0 ? (X509Certificate)certificateArray[0] : null, calendar, string, string3, string4);
        try {
            n3 = properties2.getProperty("layer2FontFamily") != null ? Integer.parseInt(properties2.getProperty("layer2FontFamily").trim()) : -1;
        }
        catch (Exception exception) {
            LOGGER.warning("Se ha indicado un tipo de letra no valido para la capa 2 del PDF ('" + properties2.getProperty("layer2FontFamily") + "'): " + exception);
            n3 = -1;
        }
        try {
            n2 = properties2.getProperty("layer2FontSize") != null ? Integer.parseInt(properties2.getProperty("layer2FontSize").trim()) : -1;
        }
        catch (Exception exception) {
            LOGGER.warning("Se ha indicado un tamano de letra no valido para la capa 2 del PDF ('" + properties2.getProperty("layer2FontSize") + "'): " + exception);
            n2 = -1;
        }
        try {
            n = properties2.getProperty("layer2FontStyle") != null ? Integer.parseInt(properties2.getProperty("layer2FontStyle").trim()) : -1;
        }
        catch (Exception exception) {
            LOGGER.warning("Se ha indicado un estilo de letra no valido para la capa 2 del PDF ('" + properties2.getProperty("layer2FontStyle") + "'): " + exception);
            n = -1;
        }
        String string10 = properties2.getProperty("layer2FontColor");
        try {
            byArray2 = XmpHelper.addSignHistoryToXmp(byArray, calendar);
        }
        catch (Exception exception) {
            LOGGER.warning("No ha podido registrarse la firma en el historico XMP: " + exception);
            byArray2 = byArray;
        }
        PdfReader pdfReader = PdfUtil.getPdfReader(byArray2, properties2, Boolean.parseBoolean(properties2.getProperty("headless")));
        byte[] byArray3 = pdfReader.getMetadata();
        boolean bl4 = PdfUtil.isPdfA1(byArray3);
        if (bl4) {
            LOGGER.info("Detectado PDF-A1, no se comprimira el PDF");
        }
        PdfUtil.checkPdfCertification(pdfReader.getCertificationLevel(), properties2);
        if (PdfUtil.pdfHasUnregisteredSignatures(pdfReader) && !Boolean.TRUE.toString().equalsIgnoreCase(properties2.getProperty("allowCosigningUnregisteredSignatures"))) {
            throw new PdfHasUnregisteredSignaturesException();
        }
        pdfReader.removeUsageRights();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            pdfStamper = PdfStamper.createSignature(pdfReader, byteArrayOutputStream, n4 == -1 ? (char)'\u0000' : Integer.toString(n4).toCharArray()[0], null, PdfUtil.getAppendMode(properties2, pdfReader), calendar);
        }
        catch (DocumentException documentException) {
            LOGGER.severe("Error al crear la firma para estampar: " + documentException);
            throw new AOException("Error al crear la firma para estampar", documentException);
        }
        catch (BadPasswordException badPasswordException) {
            if (Boolean.parseBoolean(properties2.getProperty("headless"))) {
                throw new BadPdfPasswordException(badPasswordException);
            }
            String string11 = new String(AOUIFactory.getPassword(properties2.getProperty("userPassword") == null ? CommonPdfMessages.getString("AOPDFSigner.0") : CommonPdfMessages.getString("AOPDFSigner.1"), null));
            if ("".equals(string11)) {
                throw new AOCancelledOperationException("Entrada de contrasena de PDF cancelada por el usuario", badPasswordException);
            }
            properties2.put("userPassword", string11);
            return PdfSessionManager.getSessionData(byArray2, certificateArray, calendar, properties2);
        }
        Rectangle rectangle = PdfVisibleAreasUtils.getSignaturePositionOnPage(properties2);
        if (n6 == -2 && rectangle != null && string2 == null) {
            pdfStamper.insertPage(pdfReader.getNumberOfPages() + 1, pdfReader.getPageSizeWithRotation(1));
            n6 = -1;
        }
        PdfSignatureAppearance pdfSignatureAppearance = pdfStamper.getSignatureAppearance();
        if (n4 > 2 && !bl4 && !"false".equalsIgnoreCase(properties2.getProperty("compressPdf"))) {
            pdfStamper.setFullCompression();
        }
        if (bl = Boolean.parseBoolean(properties2.getProperty("includeQuestionMark"))) {
            pdfSignatureAppearance.setAcro6Layers(false);
            pdfSignatureAppearance.setLayer4Text("% DSUnknown\nq\n1 G\n1 g\n0.1 0 0 0.1 9 0 cm\n0 J 0 j 4 M []0 d\n1 i \n0 g\n313 292 m\n313 404 325 453 432 529 c\n478 561 504 597 504 645 c\n504 736 440 760 391 760 c\n286 760 271 681 265 626 c\n265 625 l\n100 625 l\n100 828 253 898 381 898 c\n451 898 679 878 679 650 c\n679 555 628 499 538 435 c\n488 399 467 376 467 292 c\n313 292 l\nh\n308 214 170 -164 re\nf\n0.44 G\n1.2 w\n1 1 0.4 rg\n287 318 m\n287 430 299 479 406 555 c\n451 587 478 623 478 671 c\n478 762 414 786 365 786 c\n260 786 245 707 239 652 c\n239 651 l\n74 651 l\n74 854 227 924 355 924 c\n425 924 653 904 653 676 c\n653 581 602 525 512 461 c\n462 425 441 402 441 318 c\n287 318 l\nh\n282 240 170 -164 re\nB\nQ\n");
        } else {
            pdfSignatureAppearance.setAcro6Layers(true);
        }
        PdfUtil.enableLtv(pdfStamper);
        PdfPreProcessor.attachFile(properties2, pdfStamper);
        PdfPreProcessor.addImage(properties2, pdfStamper, pdfReader);
        pdfSignatureAppearance.setRender(0);
        if (string != null) {
            pdfSignatureAppearance.setReason(string);
        }
        pdfSignatureAppearance.setSignDate(calendar);
        if (n6 == -1) {
            n6 = pdfReader.getNumberOfPages();
        }
        pdfSignatureAppearance.setCrypto(null, bl2 ? null : certificateArray, null, null);
        if (string3 != null) {
            pdfSignatureAppearance.setLocation(string3);
        }
        if (string4 != null) {
            pdfSignatureAppearance.setContact(string4);
        }
        if (image != null) {
            if (bl3) {
                LOGGER.warning("Se ha indicado rotar la firma y ademas insertar una imagen, pero las firmas rotadas no aceptan imagenenes. No se usara la imagen proporcionada");
            } else {
                pdfSignatureAppearance.setImage(image);
                pdfSignatureAppearance.setLayer2Text("");
                pdfSignatureAppearance.setLayer4Text("");
            }
        }
        if (string9 != null) {
            pdfSignatureAppearance.setLayer2Text(string9);
            pdfSignatureAppearance.setLayer2Font(PdfVisibleAreasUtils.getFont(n3, n2, n, string10));
        }
        if (string8 != null) {
            pdfSignatureAppearance.setLayer4Text(string8);
        }
        if (rectangle != null && string2 == null) {
            if (!bl3) {
                pdfSignatureAppearance.setVisibleSignature(rectangle, n6, null);
            } else {
                try {
                    PdfVisibleAreasUtils.setVisibleSignatureRotated(pdfStamper, pdfSignatureAppearance, rectangle, n6, null, 90);
                }
                catch (DocumentException documentException) {
                    throw new IOException("Error en la insercion de la firma rotada: " + documentException, documentException);
                }
            }
        } else if (string2 != null) {
            pdfSignatureAppearance.setVisibleSignature(string2);
        }
        PdfSignature pdfSignature = new PdfSignature(PdfName.ADOBE_PPKLITE, string7 != null && !string7.isEmpty() ? new PdfName(string7) : PdfName.ADBE_PKCS7_DETACHED);
        if (pdfSignatureAppearance.getSignDate() != null) {
            pdfSignature.setDate(new PdfDate(pdfSignatureAppearance.getSignDate()));
        }
        if (certificateArray != null && certificateArray.length > 0 && !bl2) {
            pdfSignature.setName(PdfPKCS7.getSubjectFields((X509Certificate)certificateArray[0]).getField("CN"));
        }
        if (pdfSignatureAppearance.getReason() != null) {
            pdfSignature.setReason(pdfSignatureAppearance.getReason());
        }
        if (pdfSignatureAppearance.getLocation() != null) {
            pdfSignature.setLocation(pdfSignatureAppearance.getLocation());
        }
        if (pdfSignatureAppearance.getContact() != null) {
            pdfSignature.setContact(pdfSignatureAppearance.getContact());
        }
        pdfSignatureAppearance.setCryptoDictionary(pdfSignature);
        if (n5 != -1) {
            pdfSignatureAppearance.setCertificationLevel(n5);
        }
        if (n4 != -1) {
            pdfStamper.getWriter().setPdfVersion(Integer.toString(n4).toCharArray()[0]);
        }
        HashMap<PdfName, Integer> hashMap = new HashMap<PdfName, Integer>();
        hashMap.put(PdfName.CONTENTS, 54002);
        try {
            pdfSignatureAppearance.preClose(hashMap, calendar);
        }
        catch (DocumentException documentException) {
            LOGGER.severe("Error al estampar la firma: " + documentException);
            throw new AOException("Error al estampar la firma", documentException);
        }
        PdfObject pdfObject = ((PdfStamperImp)pdfStamper.getWriter()).getFileID();
        return new PdfTriPhaseSession(pdfSignatureAppearance, byteArrayOutputStream, new String(pdfObject.getBytes()));
    }
}

