/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.pades;

import com.aowagie.text.Annotation;
import com.aowagie.text.DocumentException;
import com.aowagie.text.Image;
import com.aowagie.text.Jpeg;
import com.aowagie.text.Rectangle;
import com.aowagie.text.pdf.PdfContentByte;
import com.aowagie.text.pdf.PdfReader;
import com.aowagie.text.pdf.PdfStamper;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.signers.pades.PdfUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public final class PdfPreProcessor {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final int LAST_PAGE = -1;
    private static final int ALL_PAGES = 0;
    private static final int FIRST_PAGE = 1;

    private PdfPreProcessor() {
    }

    public static void addMoreInfo(Map<String, String> map, PdfStamper pdfStamper) {
        if (map == null || map.isEmpty()) {
            return;
        }
        pdfStamper.setMoreInfo(map);
    }

    static void attachFile(Properties properties, PdfStamper pdfStamper) throws IOException {
        if (properties == null) {
            return;
        }
        if (pdfStamper == null) {
            throw new IllegalArgumentException("No se puede adjuntar un fichero a un PdfStamper nulo");
        }
        String string = properties.getProperty("attach");
        String string2 = properties.getProperty("attachFileName");
        String string3 = properties.getProperty("attachDescription");
        if (string != null && string2 != null) {
            byte[] byArray;
            try {
                byArray = Base64.decode(string);
            }
            catch (IOException iOException) {
                LOGGER.warning("Se ha indicado un adjunto, pero no estaba en formato Base64, se ignorara : " + iOException);
                return;
            }
            pdfStamper.getWriter().addFileAttachment(string3, byArray, null, string2);
        }
    }

    public static void addImage(byte[] byArray, int n, int n2, int n3, int n4, int n5, String string, PdfStamper pdfStamper) throws IOException {
        PdfContentByte pdfContentByte = pdfStamper.getOverContent(n5);
        try {
            Jpeg jpeg = new Jpeg(byArray);
            if (string != null) {
                jpeg.setAnnotation(new Annotation(0.0f, 0.0f, 0.0f, 0.0f, string));
            }
            pdfContentByte.addImage(jpeg, n, 0.0f, 0.0f, n2, n3, n4, false);
        }
        catch (DocumentException documentException) {
            throw new IOException("Error durante la insercion de la imagen en el PDF: " + documentException, documentException);
        }
    }

    static void addImage(Properties properties, PdfStamper pdfStamper, PdfReader pdfReader) throws IOException {
        int n;
        int n2;
        if (properties == null || pdfStamper == null) {
            return;
        }
        String string = properties.getProperty("image");
        if (string == null || string.length() < 1) {
            return;
        }
        byte[] byArray = Base64.decode(string);
        Rectangle rectangle = PdfUtil.getPositionOnPage(properties, "image");
        if (rectangle == null) {
            return;
        }
        String string2 = properties.getProperty("imagePage");
        if (string2 == null) {
            return;
        }
        try {
            n2 = Integer.parseInt(string2.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Se ha indicado un numero de pagina con formato invalido para insertar la imagen (" + string2 + "): " + numberFormatException, numberFormatException);
        }
        if (n2 == -1) {
            n2 = pdfReader.getNumberOfPages();
        }
        if (n2 == 0) {
            n2 = 1;
            n = pdfReader.getNumberOfPages();
        } else {
            n = n2;
        }
        for (int i = n2; i <= n; ++i) {
            PdfPreProcessor.addImage(byArray, (int)rectangle.getWidth(), (int)rectangle.getHeight(), (int)rectangle.getLeft(), (int)rectangle.getBottom(), i, null, pdfStamper);
        }
        LOGGER.info("Anadida imagen al PDF antes de la firma");
    }

    static Image getImage(String string) {
        byte[] byArray;
        if (string == null || string.isEmpty()) {
            return null;
        }
        try {
            byArray = Base64.decode(string);
        }
        catch (Exception exception) {
            LOGGER.severe("Se ha proporcionado una imagen de rubrica que no esta codificada en Base64: " + exception);
            return null;
        }
        try {
            return new Jpeg(byArray);
        }
        catch (Exception exception) {
            LOGGER.info("Se ha proporcionado una imagen de rubrica que no esta codificada en JPEG: " + exception);
            return null;
        }
    }
}

