/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.pades;

import com.aowagie.text.pdf.PdfDictionary;
import com.aowagie.text.pdf.PdfName;
import com.aowagie.text.pdf.PdfSignatureAppearance;
import com.aowagie.text.pdf.PdfString;
import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AdESPolicy;
import es.gob.afirma.core.signers.SignEnhancer;
import es.gob.afirma.signers.cades.CAdESSignerMetadataHelper;
import es.gob.afirma.signers.cades.CAdESTriPhaseSigner;
import es.gob.afirma.signers.cades.CommitmentTypeIndicationsHelper;
import es.gob.afirma.signers.pades.InvalidPdfException;
import es.gob.afirma.signers.pades.PdfSessionManager;
import es.gob.afirma.signers.pades.PdfSignResult;
import es.gob.afirma.signers.pades.PdfTriPhaseSession;
import es.gob.afirma.signers.tsp.pkcs7.CMSTimestamper;
import es.gob.afirma.signers.tsp.pkcs7.TsaParams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public final class PAdESTriPhaseSigner {
    private static final String PDF_OID = "1.2.826.0.1089.1.5";
    private static final String PDF_DESC = "Documento en formato PDF";
    public static final int LAST_PAGE = -1;
    private static final int CSIZE = 27000;

    private PAdESTriPhaseSigner() {
    }

    public static PdfSignResult preSign(String string, byte[] byArray, Certificate[] certificateArray, GregorianCalendar gregorianCalendar, Properties properties) throws IOException, AOException, InvalidPdfException {
        byte[] byArray2;
        Properties properties2 = properties != null ? properties : new Properties();
        PdfTriPhaseSession pdfTriPhaseSession = PdfSessionManager.getSessionData(byArray, certificateArray, gregorianCalendar, properties2);
        boolean bl = properties2.containsKey("signingCertificateV2") ? Boolean.parseBoolean(properties2.getProperty("signingCertificateV2")) : !"SHA1".equals(AOSignConstants.getDigestAlgorithmName(string));
        String[] stringArray = null;
        String string2 = properties2.getProperty("signerClaimedRoles");
        if (string2 != null && !string2.isEmpty()) {
            stringArray = string2.split(Pattern.quote("|"));
        }
        byte[] byArray3 = AOUtil.getDataFromInputStream(pdfTriPhaseSession.getSAP().getRangeStream());
        try {
            byArray2 = MessageDigest.getInstance(AOSignConstants.getDigestAlgorithmName(string)).digest(byArray3);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AOException("El algoritmo de huella digital no es valido: " + noSuchAlgorithmException, noSuchAlgorithmException);
        }
        return new PdfSignResult(pdfTriPhaseSession.getFileID(), CAdESTriPhaseSigner.preSign(AOSignConstants.getDigestAlgorithmName(string), null, certificateArray, AdESPolicy.buildAdESPolicy(properties2), bl, byArray2, gregorianCalendar.getTime(), false, true, PDF_OID, PDF_DESC, CommitmentTypeIndicationsHelper.getCommitmentTypeIndications(properties2), stringArray, CAdESSignerMetadataHelper.getCAdESSignerMetadata(properties2), Boolean.parseBoolean(properties2.getProperty("doNotIncludePolicyOnSigningCertificate", "false"))), null, gregorianCalendar, properties2);
    }

    public static byte[] postSign(String string, byte[] byArray, Certificate[] certificateArray, byte[] byArray2, PdfSignResult pdfSignResult, SignEnhancer signEnhancer, Properties properties) throws AOException, IOException, NoSuchAlgorithmException {
        PdfSignResult pdfSignResult2 = PAdESTriPhaseSigner.generatePdfSignature(string, certificateArray, pdfSignResult.getExtraParams(), byArray2, pdfSignResult.getSign(), pdfSignResult.getFileID(), pdfSignResult.getTimestamp(), pdfSignResult.getSignTime(), signEnhancer, properties);
        return PAdESTriPhaseSigner.insertSignatureOnPdf(byArray, certificateArray, pdfSignResult2);
    }

    private static PdfSignResult generatePdfSignature(String string, Certificate[] certificateArray, Properties properties, byte[] byArray, byte[] byArray2, String string2, byte[] byArray3, GregorianCalendar gregorianCalendar, SignEnhancer signEnhancer, Properties properties2) throws AOException, IOException, NoSuchAlgorithmException {
        Properties properties3;
        byte[] byArray4 = CAdESTriPhaseSigner.postSign(AOSignConstants.getDigestAlgorithmName(string), null, certificateArray, byArray, byArray2);
        Properties properties4 = properties3 = properties != null ? properties : new Properties();
        if (!"2".equals(properties3.getProperty("tsType")) && properties3.getProperty("tsaURL") != null) {
            TsaParams tsaParams;
            try {
                tsaParams = new TsaParams(properties3);
            }
            catch (Exception exception) {
                Logger.getLogger("es.gob.afirma").warning("Se ha pedido aplicar sello de tiempo, pero falta informacion necesaria: " + exception);
                tsaParams = null;
            }
            if (tsaParams != null) {
                byArray4 = new CMSTimestamper(tsaParams).addTimestamp(byArray4, tsaParams.getTsaHashAlgorithm(), gregorianCalendar);
            }
        }
        if (signEnhancer != null) {
            byArray4 = signEnhancer.enhance(byArray4, properties2 != null ? properties2 : properties3);
        }
        return new PdfSignResult(string2, byArray4, byArray3, gregorianCalendar, properties != null ? properties : new Properties());
    }

    private static byte[] insertSignatureOnPdf(byte[] byArray, Certificate[] certificateArray, PdfSignResult pdfSignResult) throws AOException, IOException {
        byte[] byArray2;
        PdfTriPhaseSession pdfTriPhaseSession;
        byte[] byArray3 = new byte[27000];
        if (pdfSignResult.getSign().length > 27000) {
            throw new AOException("El tamano de la firma (" + pdfSignResult.getSign().length + ") supera el maximo permitido para un PDF (" + 27000 + ")");
        }
        PdfDictionary pdfDictionary = new PdfDictionary();
        System.arraycopy(pdfSignResult.getSign(), 0, byArray3, 0, pdfSignResult.getSign().length);
        pdfDictionary.put(PdfName.CONTENTS, new PdfString(byArray3).setHexWriting(true));
        try {
            pdfTriPhaseSession = PdfSessionManager.getSessionData(byArray, certificateArray, pdfSignResult.getSignTime(), pdfSignResult.getExtraParams());
        }
        catch (InvalidPdfException invalidPdfException) {
            throw new IOException(invalidPdfException);
        }
        PdfSignatureAppearance pdfSignatureAppearance = pdfTriPhaseSession.getSAP();
        try (ByteArrayOutputStream byteArrayOutputStream = pdfTriPhaseSession.getBAOS();){
            String string = pdfTriPhaseSession.getFileID();
            try {
                pdfSignatureAppearance.close(pdfDictionary);
            }
            catch (Exception exception) {
                byteArrayOutputStream.close();
                throw new AOException("Error al cerrar el PDF para finalizar el proceso de firma", exception);
            }
            byArray2 = new String(byteArrayOutputStream.toByteArray(), StandardCharsets.ISO_8859_1).replace(string, pdfSignResult.getFileID()).getBytes(StandardCharsets.ISO_8859_1);
        }
        return byArray2;
    }
}

