/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.pades;

import com.aowagie.text.exceptions.BadPasswordException;
import com.aowagie.text.pdf.AcroFields;
import com.aowagie.text.pdf.PdfDictionary;
import com.aowagie.text.pdf.PdfName;
import com.aowagie.text.pdf.PdfPKCS7;
import com.aowagie.text.pdf.PdfReader;
import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.AOException;
import es.gob.afirma.core.AOInvalidFormatException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.signers.AOPkcs1Signer;
import es.gob.afirma.core.signers.AOSignInfo;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.AOSimpleSignInfo;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.core.signers.SignEnhancer;
import es.gob.afirma.core.ui.AOUIFactory;
import es.gob.afirma.core.util.tree.AOTreeModel;
import es.gob.afirma.core.util.tree.AOTreeNode;
import es.gob.afirma.signers.pades.CommonPdfMessages;
import es.gob.afirma.signers.pades.PAdESTriPhaseSigner;
import es.gob.afirma.signers.pades.PdfSignResult;
import es.gob.afirma.signers.pades.PdfTimestamper;
import es.gob.afirma.signers.pades.PdfUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Logger;

public final class AOPDFSigner
implements AOSigner {
    private static final String PDF_FILE_SUFFIX = ".pdf";
    private static final String PDF_FILE_HEADER = "%PDF-";
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final PdfName PDFNAME_ETSI_RFC3161 = new PdfName("ETSI.RFC3161");
    private static final PdfName PDFNAME_DOCTIMESTAMP = new PdfName("DocTimeStamp");
    private static final int PDF_MIN_FILE_SIZE = 70;
    private static SignEnhancer enhancer = null;
    private static Properties enhancerConfig = new Properties();

    public static SignEnhancer getSignEnhancer() {
        return enhancer;
    }

    public static Properties getSignEnhancerConfig() {
        return enhancerConfig;
    }

    @Override
    public byte[] sign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        byte[] byArray2;
        byte[] byArray3;
        Certificate[] certificateArray2;
        Properties properties2;
        Properties properties3 = properties2 = properties != null ? properties : new Properties();
        if (Boolean.parseBoolean(properties2.getProperty("includeOnlySignningCertificate", Boolean.FALSE.toString()))) {
            X509Certificate[] x509CertificateArray = new X509Certificate[1];
            certificateArray2 = x509CertificateArray;
            x509CertificateArray[0] = (X509Certificate)certificateArray[0];
        } else {
            certificateArray2 = certificateArray;
        }
        Certificate[] certificateArray3 = certificateArray2;
        GregorianCalendar gregorianCalendar = PdfUtil.getSignTime(properties2.getProperty("signTime"));
        try {
            byArray3 = PdfTimestamper.timestampPdf(byArray, properties2, gregorianCalendar);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("No se soporta el algoritmo indicado para la huella digital del sello de tiempo: " + noSuchAlgorithmException, noSuchAlgorithmException);
        }
        PdfSignResult pdfSignResult = PAdESTriPhaseSigner.preSign(string, byArray3, certificateArray3, gregorianCalendar, properties2);
        try {
            byArray2 = new AOPkcs1Signer().sign(pdfSignResult.getSign(), string, privateKey, certificateArray3, properties2);
        }
        catch (Exception exception) {
            if ("es.gob.jmulticard.CancelledOperationException".equals(exception.getClass().getName())) {
                throw new AOCancelledOperationException();
            }
            throw new AOException("Error durante la firma PAdES: " + exception, exception);
        }
        try {
            return PAdESTriPhaseSigner.postSign(string, byArray3, certificateArray3, byArray2, pdfSignResult, AOPDFSigner.getSignEnhancer(), AOPDFSigner.getSignEnhancerConfig());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AOException("Error el en algoritmo de firma: " + noSuchAlgorithmException, noSuchAlgorithmException);
        }
    }

    @Override
    public byte[] cosign(byte[] byArray, byte[] byArray2, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        return this.sign(byArray2, string, privateKey, certificateArray, properties);
    }

    @Override
    public byte[] cosign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        return this.sign(byArray, string, privateKey, certificateArray, properties);
    }

    @Override
    public byte[] countersign(byte[] byArray, String string, CounterSignTarget counterSignTarget, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) {
        throw new UnsupportedOperationException("No es posible realizar contrafirmas de ficheros PDF");
    }

    @Override
    public String getSignedName(String string, String string2) {
        String string3;
        String string4 = string3 = string2 != null ? string2 : "";
        if (string == null) {
            return "signed.pdf";
        }
        if (string.toLowerCase(Locale.US).endsWith(PDF_FILE_SUFFIX)) {
            return string.substring(0, string.length() - PDF_FILE_SUFFIX.length()) + string3 + PDF_FILE_SUFFIX;
        }
        return string + string3 + PDF_FILE_SUFFIX;
    }

    @Override
    public AOTreeModel getSignersStructure(byte[] byArray, boolean bl) {
        AcroFields acroFields;
        PdfReader pdfReader;
        AOTreeNode aOTreeNode = new AOTreeNode("Datos");
        if (!AOPDFSigner.isPdfFile(byArray)) {
            return new AOTreeModel(aOTreeNode);
        }
        try {
            pdfReader = new PdfReader(byArray);
        }
        catch (BadPasswordException badPasswordException) {
            LOGGER.info("El PDF necesita contrasena: " + badPasswordException);
            try {
                pdfReader = new PdfReader(byArray, new String(AOUIFactory.getPassword(CommonPdfMessages.getString("AOPDFSigner.0"), null)).getBytes());
            }
            catch (BadPasswordException badPasswordException2) {
                LOGGER.severe("La contrasena del PDF no es valida, se devolvera un arbol vacio: " + badPasswordException2);
                return new AOTreeModel(aOTreeNode);
            }
            catch (Exception exception) {
                LOGGER.severe("No se ha podido leer el PDF, se devolvera un arbol vacio: " + exception);
                return new AOTreeModel(aOTreeNode);
            }
        }
        catch (Exception exception) {
            LOGGER.severe("No se ha podido leer el PDF, se devolvera un arbol vacio: " + exception);
            return new AOTreeModel(aOTreeNode);
        }
        try {
            acroFields = pdfReader.getAcroFields();
        }
        catch (Exception exception) {
            LOGGER.severe("No se ha podido obtener la informacion de los firmantes del PDF, se devolvera un arbol vacio: " + exception);
            return new AOTreeModel(aOTreeNode);
        }
        List<String> list = acroFields.getSignatureNames();
        for (String string : list) {
            PdfPKCS7 pdfPKCS7;
            PdfDictionary pdfDictionary = acroFields.getSignatureDictionary(string);
            if (PDFNAME_ETSI_RFC3161.equals(pdfDictionary.get(PdfName.SUBFILTER)) || PDFNAME_DOCTIMESTAMP.equals(pdfDictionary.get(PdfName.SUBFILTER))) continue;
            try {
                pdfPKCS7 = acroFields.verifySignature(string);
            }
            catch (Exception exception) {
                LOGGER.severe("El PDF contiene una firma corrupta o con un formato desconocido (" + string + "), se continua con las siguientes si las hubiese: " + exception);
                continue;
            }
            if (bl) {
                X509Certificate[] x509CertificateArray = new X509Certificate[pdfPKCS7.getSignCertificateChain().length];
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    x509CertificateArray[i] = (X509Certificate)pdfPKCS7.getSignCertificateChain()[i];
                }
                AOSimpleSignInfo aOSimpleSignInfo = new AOSimpleSignInfo(x509CertificateArray, pdfPKCS7.getSignDate().getTime());
                byte[] byArray2 = pdfPKCS7.getPkcs1();
                if (byArray2 != null) {
                    aOSimpleSignInfo.setPkcs1(byArray2);
                }
                aOTreeNode.add(new AOTreeNode(aOSimpleSignInfo));
                continue;
            }
            aOTreeNode.add(new AOTreeNode(AOUtil.getCN(pdfPKCS7.getSigningCertificate())));
        }
        return new AOTreeModel(aOTreeNode);
    }

    @Override
    public boolean isSign(byte[] byArray) {
        if (byArray == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        if (!AOPDFSigner.isPdfFile(byArray)) {
            return false;
        }
        Object object = this.getSignersStructure(byArray, false).getRoot();
        if (object instanceof AOTreeNode) {
            if (AOTreeModel.getChildCount(object) > 0) {
                return true;
            }
            Properties properties = System.getProperties();
            try {
                if (PdfUtil.pdfHasUnregisteredSignatures(byArray, properties) && Boolean.TRUE.toString().equalsIgnoreCase(properties.getProperty("allowCosigningUnregisteredSignatures"))) {
                    return true;
                }
            }
            catch (Exception exception) {
                LOGGER.severe("No se han podido comprobar las firmas no registradas del PDF: " + exception);
            }
        }
        return false;
    }

    private static boolean isPdfFile(byte[] byArray) {
        if (byArray == null || byArray.length < 70) {
            return false;
        }
        byte[] byArray2 = new byte[PDF_FILE_HEADER.length()];
        try {
            new ByteArrayInputStream(byArray).read(byArray2);
        }
        catch (Exception exception) {
            LOGGER.warning("El contenido parece corrupto o truncado: " + exception);
            return false;
        }
        if (!PDF_FILE_HEADER.equals(new String(byArray2))) {
            return false;
        }
        try {
            new PdfReader(byArray);
        }
        catch (BadPasswordException badPasswordException) {
            LOGGER.warning("El PDF esta protegido con contrasena, se toma como PDF valido: " + badPasswordException);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isValidDataFile(byte[] byArray) {
        if (byArray == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        return AOPDFSigner.isPdfFile(byArray);
    }

    public static String getSignedName(String string) {
        if (string == null) {
            return "signed.pdf";
        }
        if (string.endsWith(PDF_FILE_SUFFIX)) {
            return string.replace(PDF_FILE_SUFFIX, ".signed.pdf");
        }
        if (string.endsWith(".PDF")) {
            return string.replace(".PDF", ".signed.pdf");
        }
        return string + ".signed.pdf";
    }

    @Override
    public byte[] getData(byte[] byArray) throws AOInvalidFormatException {
        if (!this.isSign(byArray)) {
            throw new AOInvalidFormatException("El documento introducido no contiene una firma valida");
        }
        return byArray;
    }

    @Override
    public AOSignInfo getSignInfo(byte[] byArray) throws AOException {
        if (byArray == null) {
            throw new IllegalArgumentException("No se han introducido datos para analizar");
        }
        if (!this.isSign(byArray)) {
            throw new AOInvalidFormatException("Los datos introducidos no se corresponden con un objeto de firma");
        }
        return new AOSignInfo("Adobe PDF");
    }

    public static void configureRespectfulProperties(byte[] byArray, Properties properties) {
        if (properties != null && !properties.containsKey("signatureSubFilter")) {
            String string;
            try {
                string = PdfUtil.getFirstSupportedSignSubFilter(byArray, properties);
            }
            catch (Exception exception) {
                LOGGER.warning("Error al configurar la firma PDF para que sea igual a las existentes: " + exception);
                return;
            }
            if (string != null) {
                properties.setProperty("signatureSubFilter", string.substring(string.indexOf(47) + 1));
            }
        }
    }

    static {
        String string = null;
        try {
            enhancerConfig.load(AOPDFSigner.class.getResourceAsStream("/enhancer.properties"));
            string = enhancerConfig.getProperty("enhancerClassFile");
            if (string != null) {
                enhancer = (SignEnhancer)Class.forName(string).getConstructor(new Class[0]).newInstance(new Object[0]);
                LOGGER.info("Se usara el siguiente mejorador de firmas: " + string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.warning("Se ha configurado la clase de mejora '" + string + "', pero esta no se encuentra: " + classNotFoundException);
        }
        catch (Exception exception) {
            LOGGER.info("No hay un mejorador de firmas correctamente instalado: " + exception);
        }
    }
}

