/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.ooxml.relprovider;

import es.gob.afirma.signers.ooxml.relprovider.RelationshipComparator;
import es.gob.afirma.signers.ooxml.relprovider.RelationshipTransformParameterSpec;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.crypto.Data;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class RelationshipTransformService
extends TransformService {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String NAMESPACE_SPEC_NS = "http://www.w3.org/2000/xmlns/";
    private static final String SIGNATURE_SPEC_NS = "http://www.w3.org/2000/09/xmldsig#";
    public static final String TRANSFORM_URI = "http://schemas.openxmlformats.org/package/2006/RelationshipTransform";
    private final List<String> sourceIds = new LinkedList<String>();

    @Override
    public void init(TransformParameterSpec transformParameterSpec) throws InvalidAlgorithmParameterException {
        if (!(transformParameterSpec instanceof RelationshipTransformParameterSpec)) {
            throw new InvalidAlgorithmParameterException();
        }
        RelationshipTransformParameterSpec relationshipTransformParameterSpec = (RelationshipTransformParameterSpec)transformParameterSpec;
        for (String string : relationshipTransformParameterSpec.getSourceIds()) {
            this.sourceIds.add(string);
        }
    }

    @Override
    public void init(XMLStructure xMLStructure, XMLCryptoContext xMLCryptoContext) throws InvalidAlgorithmParameterException {
        NodeList nodeList;
        Object object;
        DOMStructure dOMStructure = (DOMStructure)xMLStructure;
        Node node = dOMStructure.getNode();
        try {
            RelationshipTransformService.toString(node);
        }
        catch (TransformerException transformerException) {
            throw new InvalidAlgorithmParameterException(transformerException);
        }
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            xPath.setNamespaceContext(new NamespaceContext(){

                public Iterator getPrefixes(String string) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public String getPrefix(String string) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public String getNamespaceURI(String string) {
                    if (string == null) {
                        throw new IllegalArgumentException("El prefijo no puede ser nulo");
                    }
                    if ("xml".equals(string)) {
                        return "http://www.w3.org/XML/1998/namespace";
                    }
                    if ("ds".equals(string)) {
                        return RelationshipTransformService.SIGNATURE_SPEC_NS;
                    }
                    if ("mdssi".equals(string)) {
                        return "http://schemas.openxmlformats.org/package/2006/digital-signature";
                    }
                    return "";
                }
            });
            object = xPath.compile("mdssi:RelationshipReference/@SourceId");
            nodeList = (NodeList)object.evaluate(node, XPathConstants.NODESET);
        }
        catch (Exception exception) {
            LOGGER.severe("Error en la transformacion XPath: " + exception);
            throw new InvalidAlgorithmParameterException(exception);
        }
        if (0 == nodeList.getLength()) {
            LOGGER.warning("no RelationshipReference/@SourceId parameters present");
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object = nodeList.item(i);
            String string = object.getTextContent();
            this.sourceIds.add(string);
        }
    }

    @Override
    public void marshalParams(XMLStructure xMLStructure, XMLCryptoContext xMLCryptoContext) {
        DOMStructure dOMStructure = (DOMStructure)xMLStructure;
        Node node = dOMStructure.getNode();
        Element element = (Element)node;
        element.setAttributeNS(NAMESPACE_SPEC_NS, "xmlns:mdssi", "http://schemas.openxmlformats.org/package/2006/digital-signature");
        Document document = node.getOwnerDocument();
        for (String string : this.sourceIds) {
            Element element2 = document.createElementNS("http://schemas.openxmlformats.org/package/2006/digital-signature", "mdssi:RelationshipReference");
            element2.setAttribute("SourceId", string);
            element.appendChild(element2);
        }
    }

    @Override
    public AlgorithmParameterSpec getParameterSpec() {
        return null;
    }

    @Override
    public Data transform(Data data, XMLCryptoContext xMLCryptoContext) throws TransformException {
        Document document;
        Object object;
        Object object2;
        OctetStreamData octetStreamData = (OctetStreamData)data;
        try {
            object2 = octetStreamData.getOctetStream();
            object = null;
            try {
                document = RelationshipTransformService.loadDocument((InputStream)object2);
                ((InputStream)object2).close();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object != null) {
                        try {
                            ((InputStream)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)object2).close();
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new TransformException(exception.getMessage(), exception);
        }
        try {
            RelationshipTransformService.toString(document);
        }
        catch (TransformerException transformerException) {
            throw new TransformException(transformerException.getMessage(), transformerException);
        }
        object2 = document.createElement("ns");
        object2.setAttributeNS(NAMESPACE_SPEC_NS, "xmlns:tns", "http://schemas.openxmlformats.org/package/2006/relationships");
        object = document.getDocumentElement();
        NodeList nodeList = object.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (1 != node.getNodeType()) {
                object.removeChild(node);
                --i;
                continue;
            }
            Element element = (Element)node;
            String string = element.getAttribute("Id");
            if (!this.sourceIds.contains(string)) {
                object.removeChild(node);
                --i;
            }
            if (null != element.getAttributeNode("TargetMode")) continue;
            element.setAttribute("TargetMode", "Internal");
        }
        RelationshipTransformService.sortRelationshipElements((Element)object);
        try {
            return RelationshipTransformService.toOctetStreamData(document);
        }
        catch (TransformerException transformerException) {
            throw new TransformException(transformerException.getMessage(), transformerException);
        }
    }

    private static void sortRelationshipElements(Element element) {
        LinkedList<Element> linkedList = new LinkedList<Element>();
        NodeList nodeList = element.getElementsByTagName("*");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(0);
            Element element2 = (Element)node;
            linkedList.add(element2);
            element.removeChild(node);
        }
        Collections.sort(linkedList, new RelationshipComparator());
        for (Element element3 : linkedList) {
            element.appendChild(element3);
        }
    }

    private static String toString(Node node) throws TransformerException {
        DOMSource dOMSource = new DOMSource(node);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(dOMSource, streamResult);
        return stringWriter.getBuffer().toString();
    }

    private static OctetStreamData toOctetStreamData(Node node) throws TransformerException {
        DOMSource dOMSource = new DOMSource(node);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(byteArrayOutputStream);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(dOMSource, streamResult);
        return new OctetStreamData(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
    }

    private static Document loadDocument(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        InputSource inputSource = new InputSource(inputStream);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        return documentBuilderFactory.newDocumentBuilder().parse(inputSource);
    }

    @Override
    public Data transform(Data data, XMLCryptoContext xMLCryptoContext, OutputStream outputStream) {
        return null;
    }

    @Override
    public boolean isFeatureSupported(String string) {
        return false;
    }
}

