/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.ooxml;

import es.gob.afirma.signers.ooxml.Relationship;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

final class RelationshipsParser {
    private static final String RELATIONSHIPS_SCHEMA = "http://schemas.openxmlformats.org/package/2006/relationships";
    private Relationship[] relations = null;

    RelationshipsParser(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        this.relations = RelationshipsParser.getRelationships(inputStream);
    }

    Relationship[] getRelationships() {
        return this.relations;
    }

    private static Relationship[] getRelationships(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
        Element element = document.getDocumentElement();
        if (!element.getNodeName().equals("Relationships") || element.getAttributeNode("xmlns") == null || !element.getAttribute("xmlns").equals(RELATIONSHIPS_SCHEMA)) {
            throw new IOException("El nodo principal no es una etiqueta Relationships");
        }
        NodeList nodeList = element.getChildNodes();
        ArrayList<Relationship> arrayList = new ArrayList<Relationship>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            arrayList.add(RelationshipsParser.getRelationship(nodeList.item(i)));
        }
        return arrayList.toArray(new Relationship[0]);
    }

    private static Relationship getRelationship(Node node) throws IOException {
        if (!node.getNodeName().equals("Relationship")) {
            throw new IOException("Se ha encontrado un nodo que es de relacion: " + node.getNodeName());
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap.getNamedItem("Id") == null || namedNodeMap.getNamedItem("Type") == null || namedNodeMap.getNamedItem("Target") == null) {
            throw new IOException("Se ha encontrado un nodo de relacion que no disponia de todos sus atributos");
        }
        return new Relationship(namedNodeMap.getNamedItem("Id").getNodeValue(), namedNodeMap.getNamedItem("Type").getNodeValue(), namedNodeMap.getNamedItem("Target").getNodeValue());
    }
}

