/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.ooxml;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.signers.ooxml.NoCloseInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class OOXMLZipHelper {
    private static final String NAMESPACE_SPEC_NS = "http://www.w3.org/2000/xmlns/";
    private static final String RELATIONSHIPS_SCHEMA = "http://schemas.openxmlformats.org/package/2006/relationships";

    private OOXMLZipHelper() {
    }

    static byte[] outputSignedOfficeOpenXMLDocument(byte[] byArray, byte[] byArray2) throws IOException, ParserConfigurationException, SAXException, TransformerException, XPathExpressionException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String string = "_xmlsignatures/sig-" + UUID.randomUUID().toString() + ".xml";
        try (ZipOutputStream zipOutputStream = OOXMLZipHelper.copyOOXMLContent(byArray, string, byteArrayOutputStream);){
            zipOutputStream.putNextEntry(new ZipEntry(string));
            if (byArray2 != null) {
                zipOutputStream.write(byArray2);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static ZipOutputStream copyOOXMLContent(byte[] byArray, String string, OutputStream outputStream) throws IOException, ParserConfigurationException, SAXException, TransformerException, XPathExpressionException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        try (ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(byArray));){
            ZipEntry zipEntry;
            boolean bl = false;
            while (null != (zipEntry = zipInputStream.getNextEntry())) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Document document;
                zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
                if ("[Content_Types].xml".equals(zipEntry.getName())) {
                    document = OOXMLZipHelper.loadDocumentNoClose(zipInputStream);
                    object4 = document.getDocumentElement();
                    object3 = document.createElementNS("http://schemas.openxmlformats.org/package/2006/content-types", "Override");
                    object3.setAttribute("PartName", "/" + string);
                    object3.setAttribute("ContentType", "application/vnd.openxmlformats-package.digital-signature-xmlsignature+xml");
                    object4.appendChild((Node)object3);
                    object2 = XPathFactory.newInstance().newXPath();
                    object2.setNamespaceContext(new NamespaceContext(){

                        public Iterator getPrefixes(String string) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public String getPrefix(String string) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public String getNamespaceURI(String string) {
                            if (string == null) {
                                throw new IllegalArgumentException("El prefijo no puede ser nulo");
                            }
                            if ("xml".equals(string)) {
                                return "http://www.w3.org/XML/1998/namespace";
                            }
                            if ("tns".equals(string)) {
                                return "http://schemas.openxmlformats.org/package/2006/content-types";
                            }
                            return "";
                        }
                    });
                    object = object2.compile("/tns:Types/tns:Default[@Extension='sigs']");
                    NodeList nodeList = (NodeList)object.evaluate(document, XPathConstants.NODESET);
                    if (0 == nodeList.getLength()) {
                        Element element = document.createElementNS("http://schemas.openxmlformats.org/package/2006/content-types", "Default");
                        element.setAttribute("Extension", "sigs");
                        element.setAttribute("ContentType", "application/vnd.openxmlformats-package.digital-signature-origin");
                        object4.appendChild(element);
                    }
                    OOXMLZipHelper.writeDocumentNoClosing(document, zipOutputStream, false);
                    continue;
                }
                if ("_rels/.rels".equals(zipEntry.getName())) {
                    document = OOXMLZipHelper.loadDocumentNoClose(zipInputStream);
                    object4 = XPathFactory.newInstance().newXPath();
                    object4.setNamespaceContext(new NamespaceContext(){

                        public Iterator getPrefixes(String string) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public String getPrefix(String string) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public String getNamespaceURI(String string) {
                            if (string == null) {
                                throw new IllegalArgumentException("El prefijo no puede ser nulo");
                            }
                            if ("xml".equals(string)) {
                                return "http://www.w3.org/XML/1998/namespace";
                            }
                            if ("tns".equals(string)) {
                                return OOXMLZipHelper.RELATIONSHIPS_SCHEMA;
                            }
                            return "";
                        }
                    });
                    object3 = object4.compile("/tns:Relationships/tns:Relationship[@Type='http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin']");
                    object2 = (NodeList)object3.evaluate(document, XPathConstants.NODESET);
                    if (0 == object2.getLength()) {
                        object = document.createElementNS(RELATIONSHIPS_SCHEMA, "Relationship");
                        object.setAttribute("Id", "rel-id-" + UUID.randomUUID().toString());
                        object.setAttribute("Type", "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                        object.setAttribute("Target", "_xmlsignatures/origin.sigs");
                        document.getDocumentElement().appendChild((Node)object);
                    }
                    OOXMLZipHelper.writeDocumentNoClosing(document, zipOutputStream, false);
                    continue;
                }
                if (zipEntry.getName().startsWith("_xmlsignatures/_rels/") && zipEntry.getName().endsWith(".rels")) {
                    bl = true;
                    document = OOXMLZipHelper.loadDocumentNoClose(zipInputStream);
                    object4 = document.createElementNS(RELATIONSHIPS_SCHEMA, "Relationship");
                    object4.setAttribute("Id", "rel-" + UUID.randomUUID().toString());
                    object4.setAttribute("Type", "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/signature");
                    object4.setAttribute("Target", new File(string).getName());
                    document.getDocumentElement().appendChild((Node)object4);
                    OOXMLZipHelper.writeDocumentNoClosing(document, zipOutputStream, false);
                    continue;
                }
                zipOutputStream.write(AOUtil.getDataFromInputStream(zipInputStream));
            }
            if (!bl) {
                OOXMLZipHelper.addOriginSigsRels(string, zipOutputStream);
                OOXMLZipHelper.addOriginSigs(zipOutputStream);
            }
        }
        return zipOutputStream;
    }

    private static void addOriginSigs(ZipOutputStream zipOutputStream) throws IOException {
        zipOutputStream.putNextEntry(new ZipEntry("_xmlsignatures/origin.sigs"));
    }

    private static void addOriginSigsRels(String string, ZipOutputStream zipOutputStream) throws ParserConfigurationException, IOException, TransformerException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = documentBuilderFactory.newDocumentBuilder().newDocument();
        Element element = document.createElementNS(RELATIONSHIPS_SCHEMA, "Relationships");
        element.setAttributeNS(NAMESPACE_SPEC_NS, "xmlns", RELATIONSHIPS_SCHEMA);
        document.appendChild(element);
        Element element2 = document.createElementNS(RELATIONSHIPS_SCHEMA, "Relationship");
        String string2 = "rel-" + UUID.randomUUID().toString();
        element2.setAttribute("Id", string2);
        element2.setAttribute("Type", "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/signature");
        element2.setAttribute("Target", new File(string).getName());
        element.appendChild(element2);
        zipOutputStream.putNextEntry(new ZipEntry("_xmlsignatures/_rels/origin.sigs.rels"));
        OOXMLZipHelper.writeDocumentNoClosing(document, zipOutputStream, false);
    }

    static Document loadDocumentNoClose(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try (NoCloseInputStream noCloseInputStream = new NoCloseInputStream(inputStream);){
            Document document = documentBuilderFactory.newDocumentBuilder().parse(new InputSource(noCloseInputStream));
            return document;
        }
    }

    static void writeDocumentNoClosing(Document document, OutputStream outputStream, boolean bl) throws TransformerException {
        try (NoCloseOutputStream noCloseOutputStream = new NoCloseOutputStream(outputStream);){
            StreamResult streamResult = new StreamResult(noCloseOutputStream);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            if (bl) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            DOMSource dOMSource = new DOMSource(document);
            transformer.transform(dOMSource, streamResult);
        }
    }

    private static final class NoCloseOutputStream
    extends FilterOutputStream {
        NoCloseOutputStream(OutputStream outputStream) {
            super(outputStream);
        }

        @Override
        public void close() {
        }
    }
}

