/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.ooxml;

import es.gob.afirma.signers.ooxml.OOXMLAdvancedSignature;
import es.gob.afirma.signers.ooxml.OOXMLOfficeObjectHelper;
import es.gob.afirma.signers.ooxml.OOXMLPackageObjectHelper;
import es.gob.afirma.signers.xades.XAdESUtil;
import es.gob.afirma.signers.xml.XMLConstants;
import es.uji.crypto.xades.jxades.security.xml.XAdES.CommitmentTypeIndication;
import es.uji.crypto.xades.jxades.security.xml.XAdES.SignatureProductionPlace;
import es.uji.crypto.xades.jxades.security.xml.XAdES.SignatureProductionPlaceImpl;
import es.uji.crypto.xades.jxades.security.xml.XAdES.SignerRole;
import es.uji.crypto.xades.jxades.security.xml.XAdES.SignerRoleImpl;
import es.uji.crypto.xades.jxades.security.xml.XAdES.XAdES;
import es.uji.crypto.xades.jxades.security.xml.XAdES.XAdES_EPES;
import es.uji.crypto.xades.jxades.security.xml.XAdES.XMLAdvancedSignature;
import es.uji.crypto.xades.jxades.util.DOMOutputImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Logger;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

final class OOXMLXAdESSigner {
    private static final String ID_PACKAGE_OBJECT = "idPackageObject";
    private static final String ID_OFFICE_OBJECT = "idOfficeObject";
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String XADESNS = "http://uri.etsi.org/01903/v1.3.2#";
    private static final String XADES_SIGNATURE_PREFIX = "xd";
    private static final String XML_SIGNATURE_PREFIX = "ds";

    private OOXMLXAdESSigner() {
    }

    static byte[] getSignedXML(byte[] byArray, String string, PrivateKey privateKey, X509Certificate[] x509CertificateArray, Properties properties) throws ParserConfigurationException, GeneralSecurityException, IOException, SAXException, MarshalException, XMLSignatureException {
        XMLSignatureFactory xMLSignatureFactory;
        Object object;
        String string2;
        List<CommitmentTypeIndication> list;
        String string3 = XMLConstants.SIGN_ALGOS_URI.get(string);
        if (string3 == null) {
            throw new UnsupportedOperationException("Los formatos de firma XML no soportan el algoritmo de firma '" + string + "'");
        }
        Properties properties2 = properties != null ? properties : new Properties();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = documentBuilderFactory.newDocumentBuilder().newDocument();
        XAdES_EPES xAdES_EPES = (XAdES_EPES)XAdES.newInstance(XAdES.EPES, XADESNS, XADES_SIGNATURE_PREFIX, XML_SIGNATURE_PREFIX, "http://www.w3.org/2001/04/xmlenc#sha512", document, document.getDocumentElement());
        xAdES_EPES.setSigningCertificate(x509CertificateArray[0]);
        SignatureProductionPlace signatureProductionPlace = OOXMLXAdESSigner.getSignatureProductionPlace(properties2.getProperty("signatureProductionCity"), properties2.getProperty("signatureProductionProvince"), properties2.getProperty("signatureProductionPostalCode"), properties2.getProperty("signatureProductionCountry"));
        if (signatureProductionPlace != null) {
            xAdES_EPES.setSignatureProductionPlace(signatureProductionPlace);
        }
        if ((list = XAdESUtil.parseCommitmentTypeIndications(properties2, null)) != null && list.size() > 0) {
            xAdES_EPES.setCommitmentTypeIndications(list);
        }
        if ((string2 = properties2.getProperty("signerClaimedRoles")) != null) {
            object = new SignerRoleImpl();
            object.addClaimedRole(string2);
            xAdES_EPES.setSignerRole((SignerRole)object);
        }
        xAdES_EPES.setSigningTime(new Date());
        object = OOXMLAdvancedSignature.newInstance(xAdES_EPES, byArray);
        ArrayList<Reference> arrayList = new ArrayList<Reference>();
        String string4 = "xmldsig-" + UUID.randomUUID().toString();
        try {
            xMLSignatureFactory = XMLSignatureFactory.getInstance("DOM", (Provider)Class.forName("org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI").getConstructor(new Class[0]).newInstance(new Object[0]));
            LOGGER.info("Se usara la factoria XML de Apache");
        }
        catch (Exception exception) {
            LOGGER.info("No se ha podido usar la factoria XML DOM Apache 'org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI', se usara la por defecto del sistema: " + exception);
            xMLSignatureFactory = XMLSignatureFactory.getInstance("DOM");
        }
        DigestMethod digestMethod = xMLSignatureFactory.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha512", null);
        ((XMLAdvancedSignature)object).addXMLObject(OOXMLPackageObjectHelper.getPackageObject(ID_PACKAGE_OBJECT, xMLSignatureFactory, byArray, document, string4));
        arrayList.add(xMLSignatureFactory.newReference("#idPackageObject", digestMethod, null, "http://www.w3.org/2000/09/xmldsig#Object", null));
        ((XMLAdvancedSignature)object).addXMLObject(OOXMLOfficeObjectHelper.getOfficeObject(ID_OFFICE_OBJECT, xMLSignatureFactory, document, string4, properties2.getProperty("signatureComments"), properties2.getProperty("signatureAddress1"), properties2.getProperty("signatureAddress2"), list != null && list.size() > 0 ? "1" : null));
        arrayList.add(xMLSignatureFactory.newReference("#idOfficeObject", digestMethod, null, "http://www.w3.org/2000/09/xmldsig#Object", null));
        ((OOXMLAdvancedSignature)object).sign(x509CertificateArray, privateKey, XMLConstants.SIGN_ALGOS_URI.get(string), arrayList, string4);
        return OOXMLXAdESSigner.writeXML(document.getDocumentElement());
    }

    private static byte[] writeXML(Node node) {
        String string = StandardCharsets.UTF_8.name();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.warning("La codificacion '" + string + "' no es valida, se usara la por defecto: " + unsupportedEncodingException);
            outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
        }
        OOXMLXAdESSigner.writeXMLwithXALAN(outputStreamWriter, node, string);
        try {
            DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        }
        catch (Exception exception) {
            LOGGER.severe("No se ha podido recargar el XML para insertar los atributos de la cabecera, quizas la codificacion se vea afectada: " + exception);
            return byteArrayOutputStream.toByteArray();
        }
        try {
            return new String(byteArrayOutputStream.toByteArray(), string).getBytes(string);
        }
        catch (Exception exception) {
            LOGGER.warning("La codificacion '" + string + "' no es valida, se usara la por defecto del sistema: " + exception);
            return new String(byteArrayOutputStream.toByteArray()).getBytes();
        }
    }

    private static void writeXMLwithXALAN(Writer writer, Node node, String string) {
        LSSerializer lSSerializer = ((DOMImplementationLS)((Object)node.getOwnerDocument().getImplementation())).createLSSerializer();
        lSSerializer.getDomConfig().setParameter("namespaces", Boolean.FALSE);
        DOMOutputImpl dOMOutputImpl = new DOMOutputImpl();
        dOMOutputImpl.setCharacterStream(writer);
        if (string != null) {
            dOMOutputImpl.setEncoding(string);
        }
        lSSerializer.write(node, dOMOutputImpl);
    }

    private static SignatureProductionPlace getSignatureProductionPlace(String string, String string2, String string3, String string4) {
        if (string == null && string2 == null && string3 == null && string4 == null) {
            return null;
        }
        return new SignatureProductionPlaceImpl(string, string2, string3, string4);
    }
}

