/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.ooxml;

import es.gob.afirma.core.misc.AOFileUtils;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.signers.ooxml.Relationship;
import es.gob.afirma.signers.ooxml.RelationshipsParser;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

final class OOXMLUtil {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String OOXML_SIGNATURE_RELATIONSHIP_TYPE = "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/signature";
    private static final String OOXML_SIGNATURE_ORIGIN_RELATIONSHIP_TYPE = "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin";

    private OOXMLUtil() {
    }

    static int countOOXMLSignatures(byte[] byArray) throws IOException, SAXException, ParserConfigurationException {
        Relationship[] relationshipArray = OOXMLUtil.getOOXMLSignaturesRelationships(byArray);
        return relationshipArray == null ? 0 : relationshipArray.length;
    }

    private static Relationship[] getOOXMLSignaturesRelationships(byte[] byArray) throws IOException, SAXException, ParserConfigurationException {
        ArrayList<Relationship> arrayList = new ArrayList<Relationship>();
        File file = AOFileUtils.createTempFile(byArray);
        try (ZipFile zipFile = new ZipFile(file);){
            ZipEntry zipEntry = OOXMLUtil.getSignaturesRelsEntry(zipFile);
            if (zipEntry == null) {
                throw new IOException("No se ha encontrado el listado de relaciones");
            }
            RelationshipsParser relationshipsParser = new RelationshipsParser(zipFile.getInputStream(zipEntry));
            for (Relationship relationship : relationshipsParser.getRelationships()) {
                if (!OOXML_SIGNATURE_RELATIONSHIP_TYPE.equals(relationship.getType())) continue;
                arrayList.add(relationship);
            }
        }
        catch (Exception exception) {
            LOGGER.severe("No se pudieron leer las firmas del documento OOXML: " + exception);
        }
        if (file != null) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException iOException) {
                LOGGER.warning("No se ha podido eliminar el fichero temporal:  " + iOException);
            }
        }
        return arrayList.toArray(new Relationship[0]);
    }

    static byte[][] getOOXMLSignatures(byte[] byArray) throws IOException, SAXException, ParserConfigurationException {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        boolean bl = false;
        File file = AOFileUtils.createTempFile(byArray);
        try (ZipFile zipFile = new ZipFile(file);){
            ZipEntry zipEntry = OOXMLUtil.getSignaturesRelsEntry(zipFile);
            if (zipEntry == null) {
                throw new IOException("No se han contrado relaciones en el documento");
            }
            RelationshipsParser relationshipsParser = new RelationshipsParser(zipFile.getInputStream(zipEntry));
            for (Relationship relationship : relationshipsParser.getRelationships()) {
                if (!OOXML_SIGNATURE_RELATIONSHIP_TYPE.equals(relationship.getType())) continue;
                String string = relationship.getTarget();
                ZipEntry zipEntry2 = zipFile.getEntry("_xmlsignatures/" + string);
                if (zipEntry2 == null) {
                    zipEntry2 = zipFile.getEntry("_xmlsignatures\\" + string);
                }
                if (zipEntry2 == null) {
                    LOGGER.severe("El documento OOXML no contiene las firmas declaradas");
                    throw new IOException("El documento OOXML no contiene las firmas declaradas");
                }
                arrayList.add(AOUtil.getDataFromInputStream(zipFile.getInputStream(zipEntry2)));
            }
        }
        catch (Exception exception) {
            LOGGER.severe("No se pudieron leer las firmas del documento OOXML: " + exception);
            bl = true;
        }
        if (file != null) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException iOException) {
                LOGGER.warning("No se ha podido eliminar el fichero temporal:  " + iOException);
            }
        }
        if (bl) {
            return new byte[0][];
        }
        return (byte[][])arrayList.toArray((T[])new byte[0][]);
    }

    private static ZipEntry getSignaturesRelsEntry(ZipFile zipFile) {
        RelationshipsParser relationshipsParser;
        ZipEntry zipEntry = zipFile.getEntry("_rels/.rels");
        if (zipEntry == null) {
            zipEntry = zipFile.getEntry("_rels\\.rels");
        }
        try {
            relationshipsParser = new RelationshipsParser(zipFile.getInputStream(zipEntry));
        }
        catch (Exception exception) {
            LOGGER.severe("Error en la lectura del OOXML: " + exception);
            return null;
        }
        ZipEntry zipEntry2 = null;
        for (Relationship relationship : relationshipsParser.getRelationships()) {
            if (!OOXML_SIGNATURE_ORIGIN_RELATIONSHIP_TYPE.equals(relationship.getType())) continue;
            String string = relationship.getTarget().substring(0, "_xmlsignatures".length() + 1);
            String string2 = relationship.getTarget().substring("_xmlsignatures".length() + 1);
            zipEntry2 = zipFile.getEntry(string + "_rels/" + string2 + ".rels");
            if (zipEntry2 != null) break;
            zipEntry2 = zipFile.getEntry(string + "_rels\\" + string2 + ".rels");
            break;
        }
        return zipEntry2;
    }
}

