/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.ooxml;

import es.gob.afirma.core.misc.AOUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.crypto.Data;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.XMLSignatureFactory;

public final class OOXMLURIDereferencer
implements URIDereferencer {
    private final byte[] ooxml;
    private final URIDereferencer baseUriDereferencer;

    OOXMLURIDereferencer(byte[] byArray) {
        if (null == byArray) {
            throw new IllegalArgumentException("El OOXML es nulo");
        }
        this.baseUriDereferencer = XMLSignatureFactory.getInstance().getURIDereferencer();
        this.ooxml = (byte[])byArray.clone();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Data dereference(URIReference uRIReference, XMLCryptoContext xMLCryptoContext) throws URIReferenceException {
        if (null == uRIReference) {
            throw new IllegalArgumentException("La referencia no puede ser nula");
        }
        if (null == xMLCryptoContext) {
            throw new IllegalArgumentException("El contexto de firma no puede ser nulo");
        }
        String string = uRIReference.getURI();
        try {
            string = URLDecoder.decode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.getLogger("es.gob.afirma").warning("No se puede decodificar la URI '" + string + "': " + unsupportedEncodingException);
        }
        try (InputStream inputStream = this.findDataInputStream(string);){
            if (null == inputStream) {
                Data data = this.baseUriDereferencer.dereference(uRIReference, xMLCryptoContext);
                return data;
            }
            byte[] byArray = AOUtil.getDataFromInputStream(inputStream);
            inputStream.close();
            OctetStreamData octetStreamData = new OctetStreamData(new ByteArrayInputStream(byArray), string, null);
            return octetStreamData;
        }
        catch (IOException iOException) {
            throw new URIReferenceException("Error de I/O: " + iOException, iOException);
        }
    }

    private InputStream findDataInputStream(String string) throws IOException {
        ZipEntry zipEntry;
        String string2 = string.startsWith("/") ? string.substring(1) : string;
        if (-1 != string2.indexOf(63)) {
            string2 = string2.substring(0, string2.indexOf(63));
        }
        ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(this.ooxml));
        while (null != (zipEntry = zipInputStream.getNextEntry())) {
            if (!zipEntry.getName().equals(string2)) continue;
            return zipInputStream;
        }
        return null;
    }
}

