/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.ooxml;

import es.gob.afirma.signers.ooxml.ContentTypeManager;
import es.gob.afirma.signers.ooxml.NoCloseInputStream;
import es.gob.afirma.signers.ooxml.relprovider.RelationshipTransformParameterSpec;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureProperties;
import javax.xml.crypto.dsig.SignatureProperty;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class OOXMLPackageObjectHelper {
    private static final String NAMESPACE_SPEC_NS = "http://www.w3.org/2000/xmlns/";
    private static final String DIGITAL_SIGNATURE_SCHEMA = "http://schemas.openxmlformats.org/package/2006/digital-signature";
    private static final String PACKAGE_REL_CONTENT_TYPE = "application/vnd.openxmlformats-package.relationships+xml";
    private static final String[] CONTENT_DIRS = new String[]{"word", "excel", "xl", "powerpoint"};
    private static final Set<String> EXCLUDED_RELATIONSHIPS = new HashSet<String>(6);

    private OOXMLPackageObjectHelper() {
    }

    static XMLObject getPackageObject(String string, XMLSignatureFactory xMLSignatureFactory, byte[] byArray, Document document, String string2) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, IOException, ParserConfigurationException, SAXException {
        LinkedList<XMLStructure> linkedList = new LinkedList<XMLStructure>();
        linkedList.add(OOXMLPackageObjectHelper.constructManifest(xMLSignatureFactory, byArray));
        OOXMLPackageObjectHelper.addSignatureTime(xMLSignatureFactory, document, string2, linkedList);
        return xMLSignatureFactory.newXMLObject(linkedList, string, null, null);
    }

    private static boolean startsWithAnyOfThose(String string, String[] stringArray) {
        for (String string2 : stringArray) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private static boolean alreadyContains(List<Reference> list, Reference reference) {
        if (reference == null || list == null) {
            return true;
        }
        for (Reference reference2 : list) {
            if (!reference2.getURI().equals(reference.getURI())) continue;
            return true;
        }
        return false;
    }

    private static void addParts(XMLSignatureFactory xMLSignatureFactory, ContentTypeManager contentTypeManager, List<Reference> list, byte[] byArray, String[] stringArray, DigestMethod digestMethod) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(byArray));
        while (null != (zipEntry = zipInputStream.getNextEntry())) {
            Reference reference;
            String string;
            if (!OOXMLPackageObjectHelper.startsWithAnyOfThose(zipEntry.getName(), stringArray) || (string = contentTypeManager.getContentType(zipEntry.getName())) == null || OOXMLPackageObjectHelper.alreadyContains(list, reference = xMLSignatureFactory.newReference("/" + zipEntry.getName() + "?ContentType=" + string, digestMethod))) continue;
            list.add(reference);
        }
    }

    private static InputStream getContentTypesXMLInputStream(byte[] byArray) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(byArray));
        while (null != (zipEntry = zipInputStream.getNextEntry())) {
            if (!"[Content_Types].xml".equals(zipEntry.getName())) continue;
            return zipInputStream;
        }
        throw new IllegalStateException("El documento OOXML es invalido ya que no contiene el fichero [Content_Types].xml");
    }

    private static Document loadDocumentNoClose(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        try (NoCloseInputStream noCloseInputStream = new NoCloseInputStream(inputStream);){
            InputSource inputSource = new InputSource(noCloseInputStream);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            return document;
        }
    }

    private static void addRelationshipsReference(XMLSignatureFactory xMLSignatureFactory, String string, Document document, List<Reference> list, String string2, DigestMethod digestMethod) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        Object object;
        RelationshipTransformParameterSpec relationshipTransformParameterSpec = new RelationshipTransformParameterSpec();
        NodeList nodeList = document.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            String string3;
            object = nodeList.item(i);
            if (object.getNodeType() != 1 || EXCLUDED_RELATIONSHIPS.contains(string3 = (element = (Element)object).getAttribute("Type"))) continue;
            String string4 = element.getAttribute("Id");
            relationshipTransformParameterSpec.addRelationshipReference(string4);
        }
        LinkedList<Transform> linkedList = new LinkedList<Transform>();
        linkedList.add(xMLSignatureFactory.newTransform("http://schemas.openxmlformats.org/package/2006/RelationshipTransform", relationshipTransformParameterSpec));
        linkedList.add(xMLSignatureFactory.newTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (TransformParameterSpec)null));
        object = xMLSignatureFactory.newReference("/" + string + "?ContentType=" + string2, digestMethod, linkedList, null, null);
        list.add((Reference)object);
    }

    private static void addRelationshipsReferences(XMLSignatureFactory xMLSignatureFactory, List<Reference> list, byte[] byArray, DigestMethod digestMethod) throws IOException, ParserConfigurationException, SAXException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(byArray));
        while (null != (zipEntry = zipInputStream.getNextEntry())) {
            if (!zipEntry.getName().endsWith(".rels")) continue;
            Document document = OOXMLPackageObjectHelper.loadDocumentNoClose(zipInputStream);
            OOXMLPackageObjectHelper.addRelationshipsReference(xMLSignatureFactory, zipEntry.getName(), document, list, PACKAGE_REL_CONTENT_TYPE, digestMethod);
        }
    }

    private static Manifest constructManifest(XMLSignatureFactory xMLSignatureFactory, byte[] byArray) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, IOException, ParserConfigurationException, SAXException {
        DigestMethod digestMethod = xMLSignatureFactory.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256", null);
        LinkedList<Reference> linkedList = new LinkedList<Reference>();
        OOXMLPackageObjectHelper.addRelationshipsReferences(xMLSignatureFactory, linkedList, byArray, digestMethod);
        try (InputStream inputStream = OOXMLPackageObjectHelper.getContentTypesXMLInputStream(byArray);){
            ContentTypeManager contentTypeManager = new ContentTypeManager(inputStream);
            OOXMLPackageObjectHelper.addParts(xMLSignatureFactory, contentTypeManager, linkedList, byArray, CONTENT_DIRS, digestMethod);
        }
        return xMLSignatureFactory.newManifest(linkedList);
    }

    private static void addSignatureTime(XMLSignatureFactory xMLSignatureFactory, Document document, String string, List<XMLStructure> list) {
        Element element = document.createElementNS(DIGITAL_SIGNATURE_SCHEMA, "mdssi:SignatureTime");
        element.setAttributeNS(NAMESPACE_SPEC_NS, "xmlns:mdssi", DIGITAL_SIGNATURE_SCHEMA);
        Element element2 = document.createElementNS(DIGITAL_SIGNATURE_SCHEMA, "mdssi:Format");
        element2.setTextContent("YYYY-MM-DDThh:mm:ssTZD");
        element.appendChild(element2);
        Element element3 = document.createElementNS(DIGITAL_SIGNATURE_SCHEMA, "mdssi:Value");
        element3.setTextContent(new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss'Z'").format(new Date()));
        element.appendChild(element3);
        LinkedList<DOMStructure> linkedList = new LinkedList<DOMStructure>();
        linkedList.add(new DOMStructure(element));
        SignatureProperty signatureProperty = xMLSignatureFactory.newSignatureProperty(linkedList, "#" + string, "idSignatureTime");
        LinkedList<SignatureProperty> linkedList2 = new LinkedList<SignatureProperty>();
        linkedList2.add(signatureProperty);
        SignatureProperties signatureProperties = xMLSignatureFactory.newSignatureProperties(linkedList2, "id-signature-time-" + UUID.randomUUID().toString());
        list.add(signatureProperties);
    }

    static {
        EXCLUDED_RELATIONSHIPS.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties");
        EXCLUDED_RELATIONSHIPS.add("http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties");
        EXCLUDED_RELATIONSHIPS.add("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        EXCLUDED_RELATIONSHIPS.add("http://schemas.openxmlformats.org/package/2006/relationships/metadata/thumbnail");
        EXCLUDED_RELATIONSHIPS.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/presProps");
        EXCLUDED_RELATIONSHIPS.add("http://schemas.openxmlformats.org/officeDocument/2006/relationships/viewProps");
    }
}

