/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.ooxml;

import es.gob.afirma.core.misc.Platform;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.util.LinkedList;
import java.util.List;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.SignatureProperties;
import javax.xml.crypto.dsig.SignatureProperty;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class OOXMLOfficeObjectHelper {
    private static final String MS_DIGITAL_SIGNATURE_SCHEMA = "http://schemas.microsoft.com/office/2006/digsig";
    private static final String NAMESPACE_SPEC_NS = "http://www.w3.org/2000/xmlns/";

    private OOXMLOfficeObjectHelper() {
    }

    static XMLObject getOfficeObject(String string, XMLSignatureFactory xMLSignatureFactory, Document document, String string2, String string3, String string4, String string5, String string6) {
        Object object;
        Element element;
        Element element2;
        LinkedList<SignatureProperties> linkedList = new LinkedList<SignatureProperties>();
        Element element3 = document.createElementNS(MS_DIGITAL_SIGNATURE_SCHEMA, "SignatureInfoV1");
        element3.setAttributeNS(NAMESPACE_SPEC_NS, "xmlns", MS_DIGITAL_SIGNATURE_SCHEMA);
        element3.appendChild(document.createElementNS(MS_DIGITAL_SIGNATURE_SCHEMA, "SetupID"));
        element3.appendChild(document.createElementNS(MS_DIGITAL_SIGNATURE_SCHEMA, "SignatureText"));
        element3.appendChild(document.createElementNS(MS_DIGITAL_SIGNATURE_SCHEMA, "SignatureImage"));
        if (string3 != null) {
            element2 = document.createElementNS(MS_DIGITAL_SIGNATURE_SCHEMA, "SignatureComments");
            element2.setTextContent(string3);
            element3.appendChild(element2);
        }
        if (Platform.OS.WINDOWS.equals((Object)Platform.getOS())) {
            element2 = document.createElementNS(MS_DIGITAL_SIGNATURE_SCHEMA, "WindowsVersion");
            element2.setTextContent(System.getProperty("os.version"));
            element3.appendChild(element2);
        }
        element2 = document.createElementNS(MS_DIGITAL_SIGNATURE_SCHEMA, "OfficeVersion");
        element2.setTextContent("16.0");
        element3.appendChild(element2);
        Element element4 = document.createElementNS(MS_DIGITAL_SIGNATURE_SCHEMA, "ApplicationVersion");
        element4.setTextContent("16.0");
        element3.appendChild(element4);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Element element5 = document.createElementNS(MS_DIGITAL_SIGNATURE_SCHEMA, "Monitors");
        element5.setTextContent(Integer.toString(graphicsEnvironment.getScreenDevices().length));
        element3.appendChild(element5);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Element element6 = document.createElementNS(MS_DIGITAL_SIGNATURE_SCHEMA, "HorizontalResolutionElement");
        element6.setTextContent(Integer.toString(dimension.width));
        element3.appendChild(element6);
        Element element7 = document.createElementNS(MS_DIGITAL_SIGNATURE_SCHEMA, "VerticalResolutionElement");
        element7.setTextContent(Integer.toString(dimension.height));
        element3.appendChild(element7);
        Element element8 = document.createElementNS(MS_DIGITAL_SIGNATURE_SCHEMA, "ColorDepth");
        element8.setTextContent(Integer.toString(graphicsEnvironment.getScreenDevices()[0].getDisplayMode().getBitDepth()));
        element3.appendChild(element8);
        Element element9 = document.createElementNS(MS_DIGITAL_SIGNATURE_SCHEMA, "SignatureProviderId");
        element9.setTextContent("{00000000-0000-0000-0000-000000000000}");
        element3.appendChild(element9);
        element3.appendChild(document.createElementNS(MS_DIGITAL_SIGNATURE_SCHEMA, "SignatureProviderUrl"));
        Element element10 = document.createElementNS(MS_DIGITAL_SIGNATURE_SCHEMA, "SignatureProviderDetails");
        element10.setTextContent("9");
        element3.appendChild(element10);
        if (string6 != null && !string6.isEmpty()) {
            element = document.createElementNS(MS_DIGITAL_SIGNATURE_SCHEMA, "SignatureType");
            element.setTextContent(string6);
            element3.appendChild(element);
        }
        element = document.createElementNS(MS_DIGITAL_SIGNATURE_SCHEMA, "SignatureInfoV2");
        element.setAttributeNS(NAMESPACE_SPEC_NS, "xmlns", MS_DIGITAL_SIGNATURE_SCHEMA);
        if (string4 != null) {
            object = document.createElementNS(MS_DIGITAL_SIGNATURE_SCHEMA, "Address1");
            object.setTextContent(string4);
            element.appendChild((Node)object);
        }
        if (string5 != null) {
            object = document.createElementNS(MS_DIGITAL_SIGNATURE_SCHEMA, "Address2");
            object.setTextContent(string5);
            element.appendChild((Node)object);
        }
        object = new LinkedList();
        object.add(new DOMStructure(element3));
        object.add(new DOMStructure(element));
        SignatureProperty signatureProperty = xMLSignatureFactory.newSignatureProperty((List<? extends XMLStructure>)object, "#" + string2, "idOfficeV1Details");
        LinkedList<SignatureProperty> linkedList2 = new LinkedList<SignatureProperty>();
        linkedList2.add(signatureProperty);
        SignatureProperties signatureProperties = xMLSignatureFactory.newSignatureProperties(linkedList2, null);
        linkedList.add(signatureProperties);
        return xMLSignatureFactory.newXMLObject(linkedList, string, null, null);
    }
}

