/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.ooxml;

import es.gob.afirma.signers.ooxml.OOXMLURIDereferencer;
import es.gob.afirma.signers.xml.Utils;
import es.uji.crypto.xades.jxades.security.xml.WrappedKeyStorePlace;
import es.uji.crypto.xades.jxades.security.xml.XAdES.SignaturePolicyIdentifierImpl;
import es.uji.crypto.xades.jxades.security.xml.XAdES.XAdES_EPES;
import es.uji.crypto.xades.jxades.security.xml.XAdES.XMLAdvancedSignature;
import es.uji.crypto.xades.jxades.security.xml.XmlWrappedKeyInfo;
import java.security.GeneralSecurityException;
import java.security.KeyException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;

final class OOXMLAdvancedSignature
extends XMLAdvancedSignature {
    private final byte[] ooXmlDocument;

    private OOXMLAdvancedSignature(XAdES_EPES xAdES_EPES, byte[] byArray) {
        super(xAdES_EPES);
        this.ooXmlDocument = (byte[])byArray.clone();
    }

    static OOXMLAdvancedSignature newInstance(XAdES_EPES xAdES_EPES, byte[] byArray) throws GeneralSecurityException {
        xAdES_EPES.setSignaturePolicyIdentifier(new SignaturePolicyIdentifierImpl(true));
        OOXMLAdvancedSignature oOXMLAdvancedSignature = new OOXMLAdvancedSignature(xAdES_EPES, byArray);
        oOXMLAdvancedSignature.setDigestMethod(xAdES_EPES.getDigestMethod());
        oOXMLAdvancedSignature.setXadesNamespace(xAdES_EPES.getXadesNamespace());
        return oOXMLAdvancedSignature;
    }

    void sign(X509Certificate[] x509CertificateArray, PrivateKey privateKey, String string, List<?> list, String string2) throws MarshalException, GeneralSecurityException, XMLSignatureException {
        ArrayList arrayList = new ArrayList(list);
        if (WrappedKeyStorePlace.SIGNING_CERTIFICATE_PROPERTY.equals((Object)this.getWrappedKeyStorePlace()) && x509CertificateArray != null && x509CertificateArray.length > 0) {
            this.xades.setSigningCertificate(x509CertificateArray[0]);
        }
        this.addXMLObject(this.marshalXMLSignature(this.xadesNamespace, this.signedPropertiesTypeUrl, string2, arrayList, Arrays.asList(Utils.getDOMFactory().newTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (TransformParameterSpec)null))));
        XMLSignatureFactory xMLSignatureFactory = this.getXMLSignatureFactory();
        List<Reference> list2 = this.getReferences(arrayList);
        String string3 = this.getKeyInfoId(string2);
        list2.add(xMLSignatureFactory.newReference("#" + string3, this.getDigestMethod()));
        this.signature = xMLSignatureFactory.newXMLSignature(xMLSignatureFactory.newSignedInfo(xMLSignatureFactory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), xMLSignatureFactory.newSignatureMethod(string, null), list2), this.newKeyInfo(x509CertificateArray, string3), this.getXMLObjects(), this.getSignatureId(string2), this.getSignatureValueId(string2));
        this.signContext = new DOMSignContext(privateKey, this.baseElement != null ? this.baseElement : this.getBaseDocument());
        this.signContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", this.xades.getXmlSignaturePrefix());
        this.signContext.putNamespacePrefix(this.xadesNamespace, this.xades.getXadesPrefix());
        this.signContext.setURIDereferencer(new OOXMLURIDereferencer(this.ooXmlDocument));
        this.signature.sign(this.signContext);
    }

    private KeyInfo newKeyInfo(X509Certificate[] x509CertificateArray, String string) throws KeyException {
        KeyInfoFactory keyInfoFactory = this.getXMLSignatureFactory().getKeyInfoFactory();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (!XmlWrappedKeyInfo.PUBLIC_KEY.equals((Object)this.getXmlWrappedKeyInfo())) {
            for (X509Certificate x509Certificate : x509CertificateArray) {
                arrayList.add(x509Certificate);
            }
        }
        ArrayList arrayList2 = new ArrayList();
        arrayList2.add(keyInfoFactory.newKeyValue(x509CertificateArray[0].getPublicKey()));
        arrayList2.add(keyInfoFactory.newX509Data(arrayList));
        return keyInfoFactory.newKeyInfo(arrayList2, string);
    }
}

