/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.ooxml;

import es.gob.afirma.core.AOException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

final class ContentTypeManager {
    private final Map<String, String> defaultContentTypes = new HashMap<String, String>();
    private final Map<String, String> overrideContentTypes = new HashMap<String, String>();
    private static final DocumentBuilderFactory DOC_FACTORY = DocumentBuilderFactory.newInstance();
    private static final String SLASH = "/";

    ContentTypeManager(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        Document document = ContentTypeManager.loadDocument(inputStream);
        NodeList nodeList = document.getChildNodes();
        if (nodeList.getLength() > 0) {
            Node node = nodeList.item(0);
            NodeList nodeList2 = node.getChildNodes();
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                try {
                    NamedNodeMap namedNodeMap;
                    node = nodeList2.item(i);
                    if (node.getNodeType() != 1) continue;
                    if ("Default".equals(node.getNodeName())) {
                        namedNodeMap = node.getAttributes();
                        this.defaultContentTypes.put(ContentTypeManager.getAttributeValue(namedNodeMap, "Extension"), ContentTypeManager.getAttributeValue(namedNodeMap, "ContentType"));
                        continue;
                    }
                    if (!"Override".equals(node.getNodeName())) continue;
                    namedNodeMap = node.getAttributes();
                    this.overrideContentTypes.put(ContentTypeManager.getAttributeValue(namedNodeMap, "PartName"), ContentTypeManager.getAttributeValue(namedNodeMap, "ContentType"));
                    continue;
                }
                catch (AOException aOException) {
                    Logger.getLogger("es.gob.afirma").warning("Se encontro un nodo en el [Content_Types].xml no valido: " + aOException);
                }
            }
        }
    }

    private static Document loadDocument(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        return ContentTypeManager.getNewDocumentBuilder().parse(inputStream);
    }

    private static DocumentBuilder getNewDocumentBuilder() throws ParserConfigurationException {
        return DOC_FACTORY.newDocumentBuilder();
    }

    private static String getAttributeValue(NamedNodeMap namedNodeMap, String string) throws AOException {
        if (namedNodeMap == null) {
            throw new AOException("El nodo no contenia atributos");
        }
        Node node = namedNodeMap.getNamedItem(string);
        if (node == null) {
            throw new AOException("No existe el atributo: " + string);
        }
        return node.getNodeValue();
    }

    String getContentType(String string) {
        String string2 = !string.startsWith(SLASH) ? SLASH.concat(string) : string;
        if (this.overrideContentTypes.containsKey(string2)) {
            return this.overrideContentTypes.get(string2);
        }
        String string3 = ContentTypeManager.getExtension(string2);
        if (string3 != null && this.defaultContentTypes.containsKey(string3)) {
            return this.defaultContentTypes.get(string3);
        }
        return null;
    }

    private static String getExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1 || n == string.length() - 1) {
            return null;
        }
        return string.substring(n + 1);
    }

    static {
        DOC_FACTORY.setNamespaceAware(true);
    }
}

