/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.ooxml;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.AOException;
import es.gob.afirma.core.AOFormatFileException;
import es.gob.afirma.core.AOInvalidFormatException;
import es.gob.afirma.core.misc.AOFileUtils;
import es.gob.afirma.core.misc.MimeHelper;
import es.gob.afirma.core.misc.OfficeAnalizer;
import es.gob.afirma.core.signers.AOSignInfo;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.core.util.tree.AOTreeModel;
import es.gob.afirma.core.util.tree.AOTreeNode;
import es.gob.afirma.signers.ooxml.OOXMLUtil;
import es.gob.afirma.signers.ooxml.OOXMLXAdESSigner;
import es.gob.afirma.signers.ooxml.OOXMLZipHelper;
import es.gob.afirma.signers.ooxml.UnsupportedJreVersionException;
import es.gob.afirma.signers.ooxml.relprovider.OOXMLProvider;
import es.gob.afirma.signers.xades.AOXAdESSigner;
import es.gob.afirma.signers.xml.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;

public final class AOOOXMLSigner
implements AOSigner {
    static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String EXTENSION_DOCX = ".docx";
    private static final String EXTENSION_XLSX = ".xlsx";
    private static final String EXTENSION_PPTX = ".pptx";
    private static final String EXTENSION_PPSX = ".ppsx";
    private static final String EXTENSION_OOXML = ".ooxml";

    public AOOOXMLSigner() {
        if (System.getProperty("java.version").startsWith("1.6")) {
            throw new UnsupportedJreVersionException();
        }
        try {
            Utils.installXmlDSigProvider(true);
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.WARNING, "Error en la instalacion del proveedor XMLdSig: " + throwable, throwable);
        }
        try {
            Provider provider = Security.getProvider("OOXMLProvider");
            if (provider == null) {
                Security.addProvider(new OOXMLProvider());
            }
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.WARNING, "Error en la instalacion del proveedor OOXML: " + throwable, throwable);
        }
    }

    @Override
    public byte[] getData(byte[] byArray) throws AOException {
        if (!this.isSign(byArray)) {
            throw new AOInvalidFormatException("El documento introducido no contiene una firma valida");
        }
        return byArray;
    }

    private static boolean isOOXMLFile(byte[] byArray) throws IOException {
        if (!AOOOXMLSigner.isZipData(byArray)) {
            return false;
        }
        boolean bl = true;
        File file = AOFileUtils.createTempFile(byArray);
        try (ZipFile zipFile = new ZipFile(file);){
            if (zipFile.getEntry("[Content_Types].xml") == null) {
                bl = false;
            } else if (zipFile.getEntry("_rels/.rels") == null && zipFile.getEntry("_rels\\.rels") == null) {
                bl = false;
            } else if (zipFile.getEntry("docProps/app.xml") == null && zipFile.getEntry("docProps\\app.xml") == null) {
                bl = false;
            } else if (zipFile.getEntry("docProps/core.xml") == null && zipFile.getEntry("docProps\\core.xml") == null) {
                bl = false;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (file != null) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException iOException) {
                LOGGER.warning("No se ha podido eliminar el fichero temporal:  " + iOException);
            }
        }
        return bl;
    }

    private static boolean isZipData(byte[] byArray) throws IOException {
        return new MimeHelper(byArray).isZipData();
    }

    @Override
    public AOSignInfo getSignInfo(byte[] byArray) throws AOException {
        if (byArray == null) {
            throw new IllegalArgumentException("No se han introducido datos para analizar");
        }
        if (!this.isSign(byArray)) {
            throw new AOFormatFileException("Los datos introducidos no se corresponden con documento OOXML");
        }
        return new AOSignInfo("OOXML (Office Open XML)");
    }

    @Override
    public String getSignedName(String string, String string2) {
        String string3;
        String string4 = string3 = string2 != null ? string2 : "";
        if (string == null) {
            return string3 + EXTENSION_OOXML;
        }
        String string5 = string.toLowerCase();
        if (string5.endsWith(EXTENSION_DOCX)) {
            return string.substring(0, string.length() - EXTENSION_DOCX.length()) + string3 + EXTENSION_DOCX;
        }
        if (string5.endsWith(EXTENSION_XLSX)) {
            return string.substring(0, string.length() - EXTENSION_XLSX.length()) + string3 + EXTENSION_XLSX;
        }
        if (string5.endsWith(EXTENSION_PPTX)) {
            return string.substring(0, string.length() - EXTENSION_PPTX.length()) + string3 + EXTENSION_PPTX;
        }
        if (string5.endsWith(EXTENSION_PPSX)) {
            return string.substring(0, string.length() - EXTENSION_PPSX.length()) + string3 + EXTENSION_PPSX;
        }
        return string + string3 + EXTENSION_OOXML;
    }

    @Override
    public AOTreeModel getSignersStructure(byte[] byArray, boolean bl) {
        if (byArray == null) {
            throw new IllegalArgumentException("Los datos de firma introducidos son nulos");
        }
        if (!this.isSign(byArray)) {
            LOGGER.severe("La firma indicada no es de tipo OOXML");
            return null;
        }
        AOXAdESSigner aOXAdESSigner = new AOXAdESSigner();
        AOTreeNode aOTreeNode = new AOTreeNode("Datos");
        try {
            for (byte[] byArray2 : OOXMLUtil.getOOXMLSignatures(byArray)) {
                AOTreeModel aOTreeModel = aOXAdESSigner.getSignersStructure(byArray2, bl);
                aOTreeNode.add(((AOTreeNode)aOTreeModel.getRoot()).getChildAt(0));
            }
        }
        catch (Exception exception) {
            LOGGER.severe("La estructura de una de las firmas elementales no es valida: " + exception);
            return null;
        }
        return new AOTreeModel(aOTreeNode);
    }

    @Override
    public boolean isSign(byte[] byArray) {
        if (byArray == null) {
            LOGGER.warning("Se ha introducido una firma nula para su comprobacion");
            return false;
        }
        try {
            return AOOOXMLSigner.isOOXMLFile(byArray) && OOXMLUtil.countOOXMLSignatures(byArray) > 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean isValidDataFile(byte[] byArray) {
        if (byArray == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        try {
            return AOOOXMLSigner.isOOXMLFile(byArray);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public byte[] sign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        if (!OfficeAnalizer.isOOXMLDocument(byArray)) {
            throw new AOFormatFileException("Los datos introducidos no se corresponden con un documento OOXML");
        }
        if (certificateArray == null || certificateArray.length < 1) {
            throw new IllegalArgumentException("Debe proporcionarse a menos el certificado del firmante");
        }
        Properties properties2 = properties != null ? properties : new Properties();
        return AOOOXMLSigner.signOOXML(byArray, string, privateKey, new X509Certificate[]{(X509Certificate)certificateArray[0]}, properties2);
    }

    @Override
    public byte[] cosign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        return this.sign(byArray, string, privateKey, certificateArray, properties);
    }

    @Override
    public byte[] cosign(byte[] byArray, byte[] byArray2, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        return this.cosign(byArray2, string, privateKey, certificateArray, properties);
    }

    @Override
    public byte[] countersign(byte[] byArray, String string, CounterSignTarget counterSignTarget, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) {
        throw new UnsupportedOperationException("No es posible realizar contrafirmas de ficheros OOXML");
    }

    private static byte[] signOOXML(byte[] byArray, String string, PrivateKey privateKey, X509Certificate[] x509CertificateArray, Properties properties) throws AOException {
        if (privateKey == null) {
            throw new IllegalArgumentException("No se ha proporcionado una clave valida");
        }
        try {
            return OOXMLZipHelper.outputSignedOfficeOpenXMLDocument(byArray, OOXMLXAdESSigner.getSignedXML(byArray, string, privateKey, x509CertificateArray, properties));
        }
        catch (Exception exception) {
            if ("es.gob.jmulticard.CancelledOperationException".equals(exception.getClass().getName())) {
                throw new AOCancelledOperationException();
            }
            throw new AOException("Error durante la firma OOXML: " + exception, exception);
        }
    }
}

