/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.odf;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.AOException;
import es.gob.afirma.core.AOFormatFileException;
import es.gob.afirma.core.AOInvalidFormatException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.MimeHelper;
import es.gob.afirma.core.signers.AOSignInfo;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.core.util.tree.AOTreeModel;
import es.gob.afirma.core.util.tree.AOTreeNode;
import es.gob.afirma.signers.odf.OdfXmlUtil;
import es.gob.afirma.signers.xml.Utils;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureProperties;
import javax.xml.crypto.dsig.SignatureProperty;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class AOODFSigner
implements AOSigner {
    private static final String EXTENSION_ODT = ".odt";
    private static final String EXTENSION_ODP = ".odp";
    private static final String EXTENSION_ODS = ".ods";
    private static final String EXTENSION_ODF = ".odf";
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String OPENOFFICE = "urn:oasis:names:tc:opendocument:xmlns:digitalsignature:1.0";
    private static final String MANIFEST_PATH = "META-INF/manifest.xml";
    private static final String SIGNATURES_PATH = "META-INF/documentsignatures.xml";
    private static final String XMLDSIG_NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";
    private static final Set<String> SUPPORTED_FORMATS = new HashSet<String>();
    private static final String CANONICAL_XML_ALGORITHM = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    private static final String DEFAULT_DIGEST_METHOD = "http://www.w3.org/2000/09/xmldsig#sha1";
    private static final String DIGEST_METHOD_ALGORITHM_NAME = "SHA1";

    @Override
    public byte[] sign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        if (!"SHA1withRSA".equals(string)) {
            LOGGER.warning("Se ha indicado '" + string + "' como algoritmo de firma, pero se usara 'SHA1withRSA' por necesidades del formato ODF");
        }
        Properties properties2 = properties != null ? properties : new Properties();
        String string2 = properties2.getProperty("referencesDigestMethod", DEFAULT_DIGEST_METHOD);
        boolean bl = Boolean.parseBoolean(properties2.getProperty("useOpenOffice31Mode"));
        if (!this.isValidDataFile(byArray)) {
            throw new AOFormatFileException("Los datos introducidos no se corresponden con un documento ODF");
        }
        String string3 = MANIFEST_PATH;
        boolean bl2 = false;
        try {
            File file = File.createTempFile("sign", ".zip");
            OutputStream outputStream = new FileOutputStream(file);
            Object object = null;
            try {
                ((FileOutputStream)outputStream).write(byArray);
                outputStream.flush();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (outputStream != null) {
                    if (object != null) {
                        try {
                            ((FileOutputStream)outputStream).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((FileOutputStream)outputStream).close();
                    }
                }
            }
            file.deleteOnExit();
            outputStream = new ByteArrayOutputStream();
            object = new ZipFile(file);
            Throwable throwable = null;
            try {
                Object object2;
                Object object3;
                Element element;
                Document document;
                DigestMethod digestMethod;
                MessageDigest messageDigest;
                byte[] byArray2;
                Object object4 = ((ZipFile)object).getInputStream(((ZipFile)object).getEntry(string3));
                Object object5 = null;
                try {
                    byArray2 = AOUtil.getDataFromInputStream((InputStream)object4);
                }
                catch (Throwable throwable2) {
                    object5 = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object4 != null) {
                        if (object5 != null) {
                            try {
                                ((InputStream)object4).close();
                            }
                            catch (Throwable throwable3) {
                                ((Throwable)object5).addSuppressed(throwable3);
                            }
                        } else {
                            ((InputStream)object4).close();
                        }
                    }
                }
                object4 = DocumentBuilderFactory.newInstance();
                ((DocumentBuilderFactory)object4).setNamespaceAware(true);
                object5 = ((DocumentBuilderFactory)object4).newDocumentBuilder().parse(new ByteArrayInputStream(byArray2));
                Element element2 = object5.getDocumentElement();
                NodeList nodeList = element2.getElementsByTagName("manifest:file-entry");
                try {
                    messageDigest = MessageDigest.getInstance(DIGEST_METHOD_ALGORITHM_NAME);
                }
                catch (Exception exception) {
                    throw new AOException("No se ha podido obtener un generador de huellas digitales con el algoritmo SHA1: " + exception, exception);
                }
                XMLSignatureFactory xMLSignatureFactory = XMLSignatureFactory.getInstance("DOM");
                try {
                    digestMethod = xMLSignatureFactory.newDigestMethod(string2, null);
                }
                catch (Exception exception) {
                    throw new AOException("No se ha podido obtener un generador de huellas digitales con el algoritmo: " + string2, exception);
                }
                ArrayList<Transform> arrayList = new ArrayList<Transform>(1);
                arrayList.add(xMLSignatureFactory.newTransform(CANONICAL_XML_ALGORITHM, (TransformParameterSpec)null));
                ArrayList<Reference> arrayList2 = new ArrayList<Reference>();
                if (!bl) {
                    arrayList2.add(xMLSignatureFactory.newReference("mimetype", digestMethod, null, null, null, messageDigest.digest(AOUtil.getDataFromInputStream(((ZipFile)object).getInputStream(((ZipFile)object).getEntry("mimetype"))))));
                    arrayList2.add(xMLSignatureFactory.newReference(MANIFEST_PATH, digestMethod, arrayList, null, null, messageDigest.digest(OdfXmlUtil.canonicalizeXml(((DocumentBuilderFactory)object4).newDocumentBuilder().parse(new ByteArrayInputStream(byArray2)).getDocumentElement(), CANONICAL_XML_ALGORITHM))));
                }
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    string3 = ((Element)nodeList.item(i)).getAttribute("manifest:full-path");
                    if (string3.endsWith("/")) continue;
                    Reference reference = string3.equals("content.xml") || string3.equals("meta.xml") || string3.equals("styles.xml") || string3.equals("settings.xml") ? xMLSignatureFactory.newReference(string3.replaceAll(" ", "%20"), digestMethod, arrayList, null, null, messageDigest.digest(OdfXmlUtil.canonicalizeXml(((DocumentBuilderFactory)object4).newDocumentBuilder().parse(((ZipFile)object).getInputStream(((ZipFile)object).getEntry(string3))).getDocumentElement(), CANONICAL_XML_ALGORITHM))) : xMLSignatureFactory.newReference(string3.replaceAll(" ", "%20"), digestMethod, null, null, null, messageDigest.digest(AOUtil.getDataFromInputStream(((ZipFile)object).getInputStream(((ZipFile)object).getEntry(string3)))));
                    if (!string3.equals(SIGNATURES_PATH)) {
                        arrayList2.add(reference);
                        continue;
                    }
                    bl2 = true;
                }
                if (!bl2 && ((ZipFile)object).getEntry(SIGNATURES_PATH) != null) {
                    bl2 = true;
                }
                if (bl2) {
                    document = ((DocumentBuilderFactory)object4).newDocumentBuilder().parse(((ZipFile)object).getInputStream(((ZipFile)object).getEntry(SIGNATURES_PATH)));
                    element = document.getDocumentElement();
                } else {
                    document = ((DocumentBuilderFactory)object4).newDocumentBuilder().newDocument();
                    element = document.createElement("document-signatures");
                    element.setAttribute("xmlns", OPENOFFICE);
                    document.appendChild(element);
                    if (bl) {
                        object3 = object5.createElement("manifest:file-entry");
                        object3.setAttribute("manifest:media-type", "");
                        object3.setAttribute("manifest:full-path", SIGNATURES_PATH);
                        element2.appendChild((Node)object3);
                        object2 = object5.createElement("manifest:file-entry");
                        object2.setAttribute("manifest:media-type", "");
                        object2.setAttribute("manifest:full-path", "META-INF/");
                        element2.appendChild((Node)object2);
                    }
                }
                object3 = UUID.randomUUID().toString();
                object2 = UUID.randomUUID().toString();
                arrayList2.add(xMLSignatureFactory.newReference("#" + (String)object2, digestMethod));
                String string4 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss,SS").format(new Date());
                Document document2 = ((DocumentBuilderFactory)object4).newDocumentBuilder().parse(new ByteArrayInputStream(("<dc:date xmlns:dc=\"http://purl.org/dc/elements/1.1/\">" + string4 + "</dc:date>").getBytes()));
                Element element3 = document2.getDocumentElement();
                ArrayList<DOMStructure> arrayList3 = new ArrayList<DOMStructure>();
                arrayList3.add(new DOMStructure(element3));
                ArrayList<SignatureProperty> arrayList4 = new ArrayList<SignatureProperty>();
                arrayList4.add(xMLSignatureFactory.newSignatureProperty(arrayList3, "#" + (String)object3, (String)object2));
                ArrayList<SignatureProperties> arrayList5 = new ArrayList<SignatureProperties>();
                arrayList5.add(xMLSignatureFactory.newSignatureProperties(arrayList4, null));
                ArrayList<XMLObject> arrayList6 = new ArrayList<XMLObject>();
                arrayList6.add(xMLSignatureFactory.newXMLObject(arrayList5, null, null, null));
                KeyInfoFactory keyInfoFactory = xMLSignatureFactory.getKeyInfoFactory();
                ArrayList<Object> arrayList7 = new ArrayList<Object>();
                X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
                arrayList7.add(x509Certificate.getSubjectX500Principal().getName());
                arrayList7.add(x509Certificate);
                XMLSignature xMLSignature = xMLSignatureFactory.newXMLSignature(xMLSignatureFactory.newSignedInfo(xMLSignatureFactory.newCanonicalizationMethod(CANONICAL_XML_ALGORITHM, (C14NMethodParameterSpec)null), xMLSignatureFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), arrayList2), keyInfoFactory.newKeyInfo(Collections.singletonList(keyInfoFactory.newX509Data(arrayList7)), null), arrayList6, (String)object3, null);
                DOMSignContext dOMSignContext = new DOMSignContext(privateKey, (Node)element);
                xMLSignature.sign(dOMSignContext);
                try (ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);){
                    Enumeration<? extends ZipEntry> enumeration = ((ZipFile)object).entries();
                    while (enumeration.hasMoreElements()) {
                        ZipEntry zipEntry = enumeration.nextElement();
                        ZipEntry zipEntry2 = new ZipEntry(zipEntry.getName());
                        if (zipEntry.getName().equals(SIGNATURES_PATH) || zipEntry.getName().equals(MANIFEST_PATH)) continue;
                        zipOutputStream.putNextEntry(zipEntry2);
                        zipOutputStream.write(AOUtil.getDataFromInputStream(((ZipFile)object).getInputStream(zipEntry)));
                    }
                    zipOutputStream.putNextEntry(new ZipEntry(SIGNATURES_PATH));
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    AOODFSigner.writeXML(byteArrayOutputStream, (Node)element, false);
                    zipOutputStream.write(byteArrayOutputStream.toByteArray());
                    zipOutputStream.closeEntry();
                    zipOutputStream.putNextEntry(new ZipEntry(MANIFEST_PATH));
                    ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                    AOODFSigner.writeXML(byteArrayOutputStream2, (Node)element2, false);
                    zipOutputStream.write(byteArrayOutputStream2.toByteArray());
                    zipOutputStream.closeEntry();
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((ZipFile)object).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ((ZipFile)object).close();
                    }
                }
            }
            return ((ByteArrayOutputStream)outputStream).toByteArray();
        }
        catch (SAXException sAXException) {
            throw new AOFormatFileException("Estructura de archivo no valida '" + string3 + "': " + sAXException);
        }
        catch (Exception exception) {
            if ("es.gob.jmulticard.CancelledOperationException".equals(exception.getClass().getName())) {
                throw new AOCancelledOperationException();
            }
            throw new AOException("No ha sido posible generar la firma ODF: " + exception, exception);
        }
    }

    @Override
    public byte[] cosign(byte[] byArray, byte[] byArray2, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        return this.sign(byArray2, string, privateKey, certificateArray, properties);
    }

    @Override
    public byte[] cosign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        return this.sign(byArray, string, privateKey, certificateArray, properties);
    }

    @Override
    public byte[] countersign(byte[] byArray, String string, CounterSignTarget counterSignTarget, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) {
        throw new UnsupportedOperationException("No es posible realizar contrafirmas de ficheros ODF");
    }

    @Override
    public AOTreeModel getSignersStructure(byte[] byArray, boolean bl) throws AOInvalidFormatException, IOException {
        if (!this.isSign(byArray)) {
            throw new AOInvalidFormatException("Los datos indicados no se corresponden con un ODF firmado");
        }
        try {
            File file = File.createTempFile("sign", ".zip");
            Object object = new FileOutputStream(file);
            Object object2 = null;
            try {
                ((FileOutputStream)object).write(byArray);
                ((OutputStream)object).flush();
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (object != null) {
                    if (object2 != null) {
                        try {
                            ((FileOutputStream)object).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        ((FileOutputStream)object).close();
                    }
                }
            }
            object = new AOTreeNode("Datos");
            object2 = new ZipFile(file);
            Throwable throwable = null;
            try (InputStream inputStream = ((ZipFile)object2).getInputStream(((ZipFile)object2).getEntry(SIGNATURES_PATH));){
                int n;
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                Element element = documentBuilderFactory.newDocumentBuilder().parse(inputStream).getDocumentElement();
                NodeList nodeList = element.getElementsByTagNameNS(XMLDSIG_NAMESPACE, "Signature");
                int n2 = nodeList.getLength();
                String[] stringArray = new String[n2];
                String[] stringArray2 = new String[n2];
                AOTreeNode[] aOTreeNodeArray = new AOTreeNode[n2];
                for (n = 0; n < n2; ++n) {
                    Element element2 = (Element)nodeList.item(n);
                    String string = element2.getElementsByTagNameNS(XMLDSIG_NAMESPACE, "X509Certificate").item(0).getTextContent();
                    AOTreeNode aOTreeNode = bl ? new AOTreeNode(Utils.getSimpleSignInfoNode(null, element2)) : new AOTreeNode(AOUtil.getCN(Utils.createCert(string)));
                    stringArray[n] = element2.getAttribute("Id");
                    aOTreeNodeArray[n] = aOTreeNode;
                    String string2 = ((Element)element2.getElementsByTagNameNS(XMLDSIG_NAMESPACE, "Reference").item(0)).getAttribute("Type");
                    if ("http://uri.etsi.org/01903#CountersignedSignature".equals(string2)) {
                        String string3 = ((Element)element2.getElementsByTagNameNS(XMLDSIG_NAMESPACE, "Reference").item(0)).getAttribute("URI");
                        stringArray2[n] = string3.substring(1, string3.length() - 5);
                        continue;
                    }
                    stringArray2[n] = "";
                }
                for (n = n2 - 1; n > 0; --n) {
                    for (int i = 0; i < n2; ++i) {
                        if (!stringArray2[n].equals(stringArray[i])) continue;
                        aOTreeNodeArray[i].add(aOTreeNodeArray[n]);
                    }
                }
                for (n = 0; n < n2; ++n) {
                    if (!"".equals(stringArray2[n])) continue;
                    ((AOTreeNode)object).add(aOTreeNodeArray[n]);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object2 != null) {
                    if (throwable != null) {
                        try {
                            ((ZipFile)object2).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((ZipFile)object2).close();
                    }
                }
            }
            file.deleteOnExit();
            return new AOTreeModel((AOTreeNode)object);
        }
        catch (Exception exception) {
            LOGGER.warning("Se ha producido un error al obtener la estructura de firmas: " + exception);
            return new AOTreeModel(new AOTreeNode("Ra\u00edz"));
        }
    }

    @Override
    public boolean isSign(byte[] byArray) throws IOException {
        File file;
        if (!this.isValidDataFile(byArray)) {
            return false;
        }
        try {
            file = AOODFSigner.createTempFile(byArray);
            file.deleteOnExit();
        }
        catch (Exception exception) {
            LOGGER.warning("No se pudo crear una copia del fichero para su analisis, se devolvera false: " + exception);
            return false;
        }
        try (ZipFile zipFile = new ZipFile(file);){
            boolean bl = zipFile.getEntry(SIGNATURES_PATH) != null;
            return bl;
        }
    }

    @Override
    public boolean isValidDataFile(byte[] byArray) {
        File file;
        if (!AOODFSigner.isZipData(byArray)) {
            return false;
        }
        try {
            file = AOODFSigner.createTempFile(byArray);
            file.deleteOnExit();
        }
        catch (Exception exception) {
            LOGGER.warning("No se pudo crear una copia del fichero para su analisis, se devolvera false: " + exception);
            return false;
        }
        String string = null;
        try {
            string = AOODFSigner.getODFMimeType(file);
        }
        catch (Exception exception) {
            return false;
        }
        return string != null && SUPPORTED_FORMATS.contains(string);
    }

    private static boolean isZipData(byte[] byArray) {
        return new MimeHelper(byArray).isZipData();
    }

    @Override
    public String getSignedName(String string, String string2) {
        String string3;
        String string4 = string3 = string2 != null ? string2 : "";
        if (string == null) {
            return string3 + EXTENSION_ODF;
        }
        String string5 = string.toLowerCase();
        if (string5.length() <= EXTENSION_ODF.length()) {
            return string + string3 + EXTENSION_ODF;
        }
        if (string5.endsWith(EXTENSION_ODT)) {
            return string.substring(0, string.length() - EXTENSION_ODT.length()) + string3 + EXTENSION_ODT;
        }
        if (string5.endsWith(EXTENSION_ODP)) {
            return string.substring(0, string.length() - EXTENSION_ODP.length()) + string3 + EXTENSION_ODP;
        }
        if (string5.endsWith(EXTENSION_ODS)) {
            return string.substring(0, string.length() - EXTENSION_ODS.length()) + string3 + EXTENSION_ODS;
        }
        return string + string3 + EXTENSION_ODF;
    }

    private static void writeXML(OutputStream outputStream, Node node, boolean bl) {
        AOODFSigner.writeXML(new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8)), node, bl);
    }

    private static void writeXML(Writer writer, Node node, boolean bl) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
            if (bl) {
                transformer.setOutputProperty("indent", "yes");
            }
            transformer.transform(new DOMSource(node), new StreamResult(writer));
        }
        catch (Exception exception) {
            LOGGER.severe("Error al escribir el cuerpo del XML: " + exception);
        }
    }

    @Override
    public byte[] getData(byte[] byArray) throws AOInvalidFormatException, IOException {
        if (!this.isSign(byArray)) {
            throw new AOInvalidFormatException("El documento introducido no contiene una firma valida");
        }
        return byArray;
    }

    @Override
    public AOSignInfo getSignInfo(byte[] byArray) throws AOException, IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("No se han introducido datos para analizar");
        }
        if (!this.isSign(byArray)) {
            throw new AOInvalidFormatException("Los datos introducidos no se corresponden con un objeto de firma");
        }
        return new AOSignInfo("ODF (Open Document Format)");
    }

    private static String getODFMimeType(File file) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            ZipEntry zipEntry = zipFile.getEntry("mimetype");
            if (zipEntry != null) {
                String string = new String(AOUtil.getDataFromInputStream(zipFile.getInputStream(zipEntry)));
                return string;
            }
        }
        return null;
    }

    private static File createTempFile(byte[] byArray) throws IOException {
        File file = File.createTempFile("sign", ".zip");
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
        }
        return file;
    }

    static {
        SUPPORTED_FORMATS.add("application/vnd.oasis.opendocument.text");
        SUPPORTED_FORMATS.add("application/vnd.oasis.opendocument.spreadsheet");
        SUPPORTED_FORMATS.add("application/vnd.oasis.opendocument.presentation");
        Utils.installXmlDSigProvider(true);
    }
}

