/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.multi.cades;

import es.gob.afirma.core.AOFormatFileException;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.ASN1Set;
import org.spongycastle.asn1.BERSet;
import org.spongycastle.asn1.cms.AttributeTable;
import org.spongycastle.asn1.cms.SignedData;
import org.spongycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.spongycastle.asn1.x509.Certificate;
import org.spongycastle.cms.CMSException;
import org.spongycastle.cms.CMSSignedData;
import org.spongycastle.cms.SignerInformation;

final class CAdESMultiUtil {
    private static final ASN1ObjectIdentifier ARCHIVE_TIMESTAMP_V2_OID = new ASN1ObjectIdentifier("1.2.840.113549.1.9.16.2.48");
    private static final List<ASN1ObjectIdentifier> UNSUPPORTED_ATTRIBUTES = new ArrayList<ASN1ObjectIdentifier>(8);

    private CAdESMultiUtil() {
    }

    static ASN1Set addCertificates(SignedData signedData, java.security.cert.Certificate[] certificateArray) throws CertificateEncodingException, IOException {
        ASN1Set aSN1Set = signedData.getCertificates();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Enumeration enumeration = aSN1Set.getObjects();
        while (enumeration.hasMoreElements()) {
            aSN1EncodableVector.add((ASN1Encodable)enumeration.nextElement());
        }
        if (certificateArray.length != 0) {
            for (java.security.cert.Certificate certificate : certificateArray) {
                aSN1EncodableVector.add(Certificate.getInstance(ASN1Primitive.fromByteArray(certificate.getEncoded())));
            }
        }
        return new BERSet(aSN1EncodableVector);
    }

    static void checkUnsupportedAttributes(byte[] byArray) throws AOFormatFileException, IOException {
        CMSSignedData cMSSignedData;
        try {
            cMSSignedData = new CMSSignedData(byArray);
        }
        catch (CMSException cMSException) {
            throw new IOException("La firma proporcionada no es un SignedData compatible CMS: " + cMSException, cMSException);
        }
        CAdESMultiUtil.checkUnsupportedAttributes(cMSSignedData);
    }

    private static void checkUnsupportedAttributes(CMSSignedData cMSSignedData) throws AOFormatFileException {
        CAdESMultiUtil.checkUnsupportedAttributes(cMSSignedData.getSignerInfos().getSigners().iterator().next());
    }

    private static void checkUnsupportedAttributes(SignerInformation signerInformation) throws AOFormatFileException {
        AttributeTable attributeTable = signerInformation.getUnsignedAttributes();
        if (attributeTable != null) {
            for (ASN1ObjectIdentifier aSN1ObjectIdentifier : UNSUPPORTED_ATTRIBUTES) {
                if (attributeTable.get(aSN1ObjectIdentifier) == null) continue;
                throw new AOFormatFileException("No se soportan multifirmas de firmas con atributos longevos (encontrado OID=" + aSN1ObjectIdentifier + ")");
            }
        }
    }

    static void checkUnsupported(ASN1ObjectIdentifier aSN1ObjectIdentifier) throws AOFormatFileException {
        for (ASN1ObjectIdentifier aSN1ObjectIdentifier2 : UNSUPPORTED_ATTRIBUTES) {
            if (!aSN1ObjectIdentifier2.equals(aSN1ObjectIdentifier)) continue;
            throw new AOFormatFileException("No se soportan multifirmas de firmas con atributos longevos (encontrado OID=" + aSN1ObjectIdentifier + ")");
        }
    }

    static boolean isCounterSignature(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return PKCSObjectIdentifiers.pkcs_9_at_counterSignature.equals(aSN1ObjectIdentifier);
    }

    static {
        UNSUPPORTED_ATTRIBUTES.add(ARCHIVE_TIMESTAMP_V2_OID);
        UNSUPPORTED_ATTRIBUTES.add(PKCSObjectIdentifiers.id_aa_ets_revocationRefs);
        UNSUPPORTED_ATTRIBUTES.add(PKCSObjectIdentifiers.id_aa_ets_archiveTimestamp);
        UNSUPPORTED_ATTRIBUTES.add(PKCSObjectIdentifiers.id_aa_ets_certificateRefs);
        UNSUPPORTED_ATTRIBUTES.add(PKCSObjectIdentifiers.id_aa_ets_revocationValues);
        UNSUPPORTED_ATTRIBUTES.add(PKCSObjectIdentifiers.id_aa_ets_certValues);
        UNSUPPORTED_ATTRIBUTES.add(PKCSObjectIdentifiers.id_aa_ets_escTimeStamp);
    }
}

