/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.multi.cades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.AOFormatFileException;
import es.gob.afirma.core.signers.AOPkcs1Signer;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AOSimpleSigner;
import es.gob.afirma.core.signers.AdESPolicy;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.signers.cades.CAdESSignerMetadata;
import es.gob.afirma.signers.cades.CAdESUtils;
import es.gob.afirma.signers.cades.CommitmentTypeIndicationBean;
import es.gob.afirma.signers.multi.cades.CAdESMultiUtil;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import es.gob.afirma.signers.pkcs7.SigUtils;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1InputStream;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1OctetString;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.ASN1Set;
import org.spongycastle.asn1.ASN1TaggedObject;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.DERSet;
import org.spongycastle.asn1.cms.Attribute;
import org.spongycastle.asn1.cms.AttributeTable;
import org.spongycastle.asn1.cms.CMSAttributes;
import org.spongycastle.asn1.cms.ContentInfo;
import org.spongycastle.asn1.cms.IssuerAndSerialNumber;
import org.spongycastle.asn1.cms.SignedData;
import org.spongycastle.asn1.cms.SignerIdentifier;
import org.spongycastle.asn1.cms.SignerInfo;
import org.spongycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.spongycastle.asn1.x500.X500Name;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.asn1.x509.TBSCertificate;

final class CAdESCounterSigner {
    private AOSimpleSigner ss = new AOPkcs1Signer();
    private Date date = null;

    CAdESCounterSigner() {
    }

    void setPkcs1Signer(AOSimpleSigner aOSimpleSigner, Date date) {
        if (aOSimpleSigner == null) {
            throw new IllegalArgumentException("El firmador PKCS#1 no puede ser nulo");
        }
        if (date == null) {
            Logger.getLogger("es.gob.afirma").warning("Se ha establecido una fecha nula, se usara la actual");
        }
        this.ss = aOSimpleSigner;
        this.date = date;
    }

    byte[] counterSign(String string, byte[] byArray, CounterSignTarget counterSignTarget, PrivateKey privateKey, Certificate[] certificateArray, AdESPolicy adESPolicy, boolean bl, List<CommitmentTypeIndicationBean> list, String[] stringArray, boolean bl2, CAdESSignerMetadata cAdESSignerMetadata, boolean bl3) throws IOException, NoSuchAlgorithmException, CertificateException, AOException {
        ASN1Sequence aSN1Sequence;
        try (Object object = new ASN1InputStream(byArray);){
            aSN1Sequence = (ASN1Sequence)((ASN1InputStream)object).readObject();
        }
        object = aSN1Sequence.getObjects();
        var15_14 = object.nextElement();
        if (!(var15_14 instanceof ASN1ObjectIdentifier) && ((ASN1ObjectIdentifier)((Object)var15_14)).equals(PKCSObjectIdentifiers.signedData)) {
            throw new AOFormatFileException("No se ha encontrado un SignedData en los datos a contrafirmar");
        }
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)object.nextElement();
        SignedData signedData = SignedData.getInstance(aSN1TaggedObject.getObject());
        ASN1Set aSN1Set = signedData.getSignerInfos();
        ASN1Set aSN1Set2 = CAdESMultiUtil.addCertificates(signedData, certificateArray);
        ASN1EncodableVector aSN1EncodableVector = this.counterSignSignerInfos(aSN1Set, string, privateKey, certificateArray, adESPolicy, bl, list, stringArray, bl2, cAdESSignerMetadata, counterSignTarget, bl3);
        return new ContentInfo(PKCSObjectIdentifiers.signedData, new SignedData(signedData.getDigestAlgorithms(), signedData.getEncapContentInfo(), aSN1Set2, null, new DERSet(aSN1EncodableVector))).getEncoded("DER");
    }

    private ASN1EncodableVector counterSignSignerInfos(ASN1Set aSN1Set, String string, PrivateKey privateKey, Certificate[] certificateArray, AdESPolicy adESPolicy, boolean bl, List<CommitmentTypeIndicationBean> list, String[] stringArray, boolean bl2, CAdESSignerMetadata cAdESSignerMetadata, CounterSignTarget counterSignTarget, boolean bl3) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i = 0; i < aSN1Set.size(); ++i) {
            SignerInfo signerInfo = SignerInfo.getInstance(aSN1Set.getObjectAt(i));
            aSN1EncodableVector.add(this.counterSignSignerInfo(signerInfo, string, privateKey, certificateArray, adESPolicy, bl, list, stringArray, bl2, cAdESSignerMetadata, counterSignTarget, bl3));
        }
        return aSN1EncodableVector;
    }

    private SignerInfo counterSignSignerInfo(SignerInfo signerInfo, String string, PrivateKey privateKey, Certificate[] certificateArray, AdESPolicy adESPolicy, boolean bl, List<CommitmentTypeIndicationBean> list, String[] stringArray, boolean bl2, CAdESSignerMetadata cAdESSignerMetadata, CounterSignTarget counterSignTarget, boolean bl3) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        boolean bl4 = true;
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            Enumeration enumeration = signerInfo.getUnauthenticatedAttributes().getObjects();
            while (enumeration.hasMoreElements()) {
                Attribute attribute = Attribute.getInstance(enumeration.nextElement());
                CAdESMultiUtil.checkUnsupported(attribute.getAttrType());
                if (CAdESMultiUtil.isCounterSignature(attribute.getAttrType())) {
                    bl4 = false;
                    List<SignerInfo> list2 = CAdESCounterSigner.getSignerInfoFromUnauthenticatedAttributes(attribute);
                    for (SignerInfo signerInfo2 : list2) {
                        aSN1EncodableVector.add(this.counterSignSignerInfo(signerInfo2, string, privateKey, certificateArray, adESPolicy, bl, list, stringArray, bl2, cAdESSignerMetadata, counterSignTarget, bl3));
                    }
                    continue;
                }
                arrayList.add(attribute);
            }
        }
        if (CounterSignTarget.TREE.equals((Object)counterSignTarget) || CounterSignTarget.LEAFS.equals((Object)counterSignTarget) && bl4) {
            aSN1EncodableVector.add(this.signSignerInfo(signerInfo, string, privateKey, certificateArray, adESPolicy, bl, list, stringArray, bl2, cAdESSignerMetadata, bl3));
        }
        arrayList.add(new Attribute(CMSAttributes.counterSignature, new DERSet(aSN1EncodableVector)));
        return new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(arrayList.toArray(new ASN1Encodable[arrayList.size()])));
    }

    private SignerInfo signSignerInfo(SignerInfo signerInfo, String string, PrivateKey privateKey, Certificate[] certificateArray, AdESPolicy adESPolicy, boolean bl, List<CommitmentTypeIndicationBean> list, String[] stringArray, boolean bl2, CAdESSignerMetadata cAdESSignerMetadata, boolean bl3) throws NoSuchAlgorithmException, IOException, CertificateException {
        DEROctetString dEROctetString;
        String string2 = AOSignConstants.getDigestAlgorithmName(string);
        ASN1EncodableVector aSN1EncodableVector = CAdESUtils.generateSignerInfo(certificateArray[0], string2, signerInfo.getEncryptedDigest().getOctets(), adESPolicy, bl, null, this.date != null ? this.date : new Date(), bl2, false, PKCSObjectIdentifiers.data.toString(), null, list, stringArray, cAdESSignerMetadata, true, bl3);
        ASN1Set aSN1Set = SigUtils.getAttributeSet(new AttributeTable(aSN1EncodableVector));
        try {
            dEROctetString = new DEROctetString(this.pkcs1Sign(aSN1Set.getEncoded("DER"), string, privateKey, certificateArray));
        }
        catch (AOException aOException) {
            throw new IOException("Error al realizar la firma: " + aOException, aOException);
        }
        AlgorithmIdentifier algorithmIdentifier = SigUtils.makeAlgId(AOAlgorithmID.getOID(string2));
        AlgorithmIdentifier algorithmIdentifier2 = SigUtils.makeAlgId(AOAlgorithmID.getOID("RSA"));
        TBSCertificate tBSCertificate = TBSCertificate.getInstance(ASN1Primitive.fromByteArray(((X509Certificate)certificateArray[0]).getTBSCertificate()));
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(X500Name.getInstance(tBSCertificate.getIssuer()), tBSCertificate.getSerialNumber().getValue());
        SignerIdentifier signerIdentifier = new SignerIdentifier(issuerAndSerialNumber);
        ASN1Set aSN1Set2 = SigUtils.getAttributeSet(new AttributeTable(aSN1EncodableVector));
        return new SignerInfo(signerIdentifier, algorithmIdentifier, aSN1Set2, algorithmIdentifier2, (ASN1OctetString)dEROctetString, null);
    }

    private static List<SignerInfo> getSignerInfoFromUnauthenticatedAttributes(Attribute attribute) {
        ArrayList<SignerInfo> arrayList = new ArrayList<SignerInfo>();
        ASN1Set aSN1Set = attribute.getAttrValues();
        Enumeration enumeration = aSN1Set.getObjects();
        while (enumeration.hasMoreElements()) {
            try {
                arrayList.add(SignerInfo.getInstance(enumeration.nextElement()));
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    private byte[] pkcs1Sign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray) throws AOException {
        try {
            return this.ss.sign(byArray, string, privateKey, certificateArray, null);
        }
        catch (IOException iOException) {
            throw new AOException("Error en la firma PKCS#1 de la contrafirma CAdES: " + iOException, iOException);
        }
    }
}

