/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.multi.cades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.signers.AOPkcs1Signer;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AdESPolicy;
import es.gob.afirma.signers.cades.CAdESSignerMetadata;
import es.gob.afirma.signers.cades.CAdESUtils;
import es.gob.afirma.signers.cades.CommitmentTypeIndicationBean;
import es.gob.afirma.signers.multi.cades.CAdESMultiUtil;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import es.gob.afirma.signers.pkcs7.ContainsNoDataException;
import es.gob.afirma.signers.pkcs7.P7ContentSignerParameters;
import es.gob.afirma.signers.pkcs7.SigUtils;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1InputStream;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1OctetString;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.ASN1Set;
import org.spongycastle.asn1.ASN1TaggedObject;
import org.spongycastle.asn1.BEROctetString;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.DERSet;
import org.spongycastle.asn1.cms.AttributeTable;
import org.spongycastle.asn1.cms.CMSAttributes;
import org.spongycastle.asn1.cms.ContentInfo;
import org.spongycastle.asn1.cms.IssuerAndSerialNumber;
import org.spongycastle.asn1.cms.SignedData;
import org.spongycastle.asn1.cms.SignerIdentifier;
import org.spongycastle.asn1.cms.SignerInfo;
import org.spongycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.spongycastle.asn1.x500.X500Name;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.asn1.x509.TBSCertificate;
import org.spongycastle.cms.CMSException;
import org.spongycastle.cms.CMSProcessableByteArray;

final class CAdESCoSigner {
    private ASN1Set signedAttr2;

    CAdESCoSigner() {
    }

    private static SignedData readData(byte[] byArray) throws IOException {
        ASN1Sequence aSN1Sequence;
        Object object = new ASN1InputStream(byArray);
        Object object2 = null;
        try {
            aSN1Sequence = (ASN1Sequence)((ASN1InputStream)object).readObject();
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (object2 != null) {
                    try {
                        ((FilterInputStream)object).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    ((FilterInputStream)object).close();
                }
            }
        }
        object = aSN1Sequence.getObjects();
        object.nextElement();
        object2 = (ASN1TaggedObject)object.nextElement();
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)((ASN1TaggedObject)object2).getObject();
        return SignedData.getInstance(aSN1Sequence2);
    }

    byte[] coSigner(P7ContentSignerParameters p7ContentSignerParameters, byte[] byArray, boolean bl, AdESPolicy adESPolicy, boolean bl2, PrivateKey privateKey, Certificate[] certificateArray, byte[] byArray2, String string, String string2, List<CommitmentTypeIndicationBean> list, String[] stringArray, boolean bl3, CAdESSignerMetadata cAdESSignerMetadata, boolean bl4) throws IOException, NoSuchAlgorithmException, CertificateException {
        ASN1OctetString aSN1OctetString;
        ASN1Set aSN1Set;
        Object object;
        Object object2;
        Object object3;
        SignedData signedData = CAdESCoSigner.readData(byArray);
        ContentInfo contentInfo = null;
        ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier(PKCSObjectIdentifiers.data.getId());
        byte[] byArray3 = null;
        if (!bl) {
            object3 = new ByteArrayOutputStream();
            byArray3 = p7ContentSignerParameters.getContent();
            object2 = new CMSProcessableByteArray(byArray3);
            try {
                object2.write((OutputStream)object3);
            }
            catch (CMSException cMSException) {
                throw new IOException("Error en la escritura del procesable CMS: " + cMSException, cMSException);
            }
            contentInfo = new ContentInfo(aSN1ObjectIdentifier, new BEROctetString(((ByteArrayOutputStream)object3).toByteArray()));
        } else {
            contentInfo = new ContentInfo(aSN1ObjectIdentifier, null);
        }
        object3 = CAdESMultiUtil.addCertificates(signedData, certificateArray);
        object2 = p7ContentSignerParameters.getSignatureAlgorithm();
        String string3 = AOSignConstants.getDigestAlgorithmName((String)object2);
        AlgorithmIdentifier algorithmIdentifier = SigUtils.makeAlgId(AOAlgorithmID.getOID(AOSignConstants.getDigestAlgorithmName((String)object2)));
        TBSCertificate tBSCertificate = TBSCertificate.getInstance(ASN1Primitive.fromByteArray(((X509Certificate)certificateArray[0]).getTBSCertificate()));
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(X500Name.getInstance(tBSCertificate.getIssuer()), tBSCertificate.getSerialNumber().getValue());
        SignerIdentifier signerIdentifier = new SignerIdentifier(issuerAndSerialNumber);
        if (byArray2 == null) {
            object = CAdESUtils.generateSignerInfo(certificateArray[0], string3, byArray3 != null ? byArray3 : p7ContentSignerParameters.getContent(), adESPolicy, bl2, null, new Date(), bl3, false, string, string2, list, stringArray, cAdESSignerMetadata, false, bl4);
            this.signedAttr2 = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object));
            aSN1Set = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object));
        } else {
            object = CAdESUtils.generateSignerInfo(certificateArray[0], string3, null, adESPolicy, bl2, byArray2, new Date(), bl3, false, string, string2, list, stringArray, cAdESSignerMetadata, false, bl4);
            this.signedAttr2 = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object));
            aSN1Set = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object));
        }
        object = SigUtils.makeAlgId(AOAlgorithmID.getOID("RSA"));
        ASN1Set aSN1Set2 = signedData.getSignerInfos();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i = 0; i < aSN1Set2.size(); ++i) {
            aSN1EncodableVector.add(SignerInfo.getInstance(aSN1Set2.getObjectAt(i)));
        }
        try {
            aSN1OctetString = this.firma((String)object2, privateKey, certificateArray);
        }
        catch (AOException aOException) {
            throw new IOException("Error al realizar la firma: " + aOException, aOException);
        }
        aSN1EncodableVector.add(new SignerInfo(signerIdentifier, algorithmIdentifier, aSN1Set, (AlgorithmIdentifier)object, aSN1OctetString, null));
        return new ContentInfo(PKCSObjectIdentifiers.signedData, new SignedData(signedData.getDigestAlgorithms(), contentInfo, (ASN1Set)object3, null, new DERSet(aSN1EncodableVector))).getEncoded("DER");
    }

    byte[] coSigner(String string, X509Certificate[] x509CertificateArray, InputStream inputStream, AdESPolicy adESPolicy, boolean bl, PrivateKey privateKey, Certificate[] certificateArray, byte[] byArray, String string2, String string3, List<CommitmentTypeIndicationBean> list, String[] stringArray, boolean bl2, CAdESSignerMetadata cAdESSignerMetadata, boolean bl3) throws IOException, NoSuchAlgorithmException, CertificateException, ContainsNoDataException {
        ASN1Set aSN1Set;
        Object object;
        Object object3;
        ASN1Sequence aSN1Sequence;
        Object object4 = new ASN1InputStream(inputStream);
        Object object5 = null;
        try {
            aSN1Sequence = (ASN1Sequence)((ASN1InputStream)object4).readObject();
        }
        catch (Throwable throwable) {
            object5 = throwable;
            throw throwable;
        }
        finally {
            if (object4 != null) {
                if (object5 != null) {
                    try {
                        ((FilterInputStream)object4).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object5).addSuppressed(throwable);
                    }
                } else {
                    ((FilterInputStream)object4).close();
                }
            }
        }
        object4 = aSN1Sequence.getObjects();
        object4.nextElement();
        object5 = (ASN1TaggedObject)object4.nextElement();
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)((ASN1TaggedObject)object5).getObject();
        SignedData signedData = SignedData.getInstance(aSN1Sequence2);
        ContentInfo contentInfo = signedData.getEncapContentInfo();
        DEROctetString dEROctetString = (DEROctetString)contentInfo.getContent();
        byte[] byArray2 = null;
        if (dEROctetString != null) {
            byArray2 = AOUtil.getDataFromInputStream(dEROctetString.getOctetStream());
        }
        ASN1Set aSN1Set2 = null;
        ASN1Set aSN1Set3 = signedData.getCertificates();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Enumeration enumeration = aSN1Set3.getObjects();
        while (enumeration.hasMoreElements()) {
            aSN1EncodableVector.add((ASN1Encodable)enumeration.nextElement());
        }
        if (x509CertificateArray.length != 0) {
            object3 = new ArrayList();
            for (X509Certificate x509Certificate : x509CertificateArray) {
                object3.add(org.spongycastle.asn1.x509.Certificate.getInstance(ASN1Primitive.fromByteArray(x509Certificate.getEncoded())));
            }
            aSN1Set2 = SigUtils.fillRestCerts((List<ASN1Encodable>)object3, aSN1EncodableVector);
        }
        object3 = AOSignConstants.getDigestAlgorithmName(string);
        AlgorithmIdentifier algorithmIdentifier = SigUtils.makeAlgId(AOAlgorithmID.getOID((String)object3));
        TBSCertificate tBSCertificate = TBSCertificate.getInstance(ASN1Primitive.fromByteArray(x509CertificateArray[0].getTBSCertificate()));
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(X500Name.getInstance(tBSCertificate.getIssuer()), tBSCertificate.getSerialNumber().getValue());
        SignerIdentifier signerIdentifier = new SignerIdentifier(issuerAndSerialNumber);
        AlgorithmIdentifier algorithmIdentifier2 = SigUtils.makeAlgId(AOAlgorithmID.getOID("RSA"));
        ASN1Set aSN1Set4 = signedData.getSignerInfos();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        byte[] byArray3 = byArray != null ? (byte[])byArray.clone() : null;
        for (int i = 0; i < aSN1Set4.size(); ++i) {
            object = SignerInfo.getInstance(aSN1Set4.getObjectAt(i));
            AlgorithmIdentifier algorithmIdentifier3 = ((SignerInfo)object).getDigestAlgorithm();
            if (algorithmIdentifier3.getAlgorithm().toString().equals(AOAlgorithmID.getOID((String)object3))) {
                ASN1Set aSN1Set5 = ((SignerInfo)object).getAuthenticatedAttributes();
                for (int j = 0; j < aSN1Set5.size(); ++j) {
                    ASN1Sequence aSN1Sequence3 = (ASN1Sequence)aSN1Set5.getObjectAt(j);
                    ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)aSN1Sequence3.getObjectAt(0);
                    if (!CMSAttributes.messageDigest.getId().equals(aSN1ObjectIdentifier.toString())) continue;
                    DERSet dERSet = (DERSet)aSN1Sequence3.getObjectAt(1);
                    DEROctetString dEROctetString2 = (DEROctetString)dERSet.getObjectAt(0);
                    byArray3 = dEROctetString2.getOctets();
                }
            }
            aSN1EncodableVector2.add((ASN1Encodable)object);
        }
        if (byArray2 != null) {
            object = CAdESUtils.generateSignerInfo(x509CertificateArray[0], (String)object3, byArray2, adESPolicy, bl, null, new Date(), bl2, false, string2, string3, list, stringArray, cAdESSignerMetadata, false, bl3);
            this.signedAttr2 = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object));
            aSN1Set = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object));
        } else if (byArray3 != null) {
            object = CAdESUtils.generateSignerInfo(x509CertificateArray[0], (String)object3, null, adESPolicy, bl, byArray3, new Date(), bl2, false, string2, string3, list, stringArray, cAdESSignerMetadata, false, bl3);
            this.signedAttr2 = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object));
            aSN1Set = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object));
        } else {
            throw new ContainsNoDataException("No se puede crear la cofirma ya que no se han encontrado ni los datos firmados ni una huella digital compatible con el algoritmo de firma");
        }
        try {
            object = this.firma(string, privateKey, certificateArray);
        }
        catch (AOException aOException) {
            throw new IOException("Error al realizar la firma: " + aOException, aOException);
        }
        aSN1EncodableVector2.add(new SignerInfo(signerIdentifier, algorithmIdentifier, aSN1Set, algorithmIdentifier2, (ASN1OctetString)object, null));
        return new ContentInfo(PKCSObjectIdentifiers.signedData, new SignedData(signedData.getDigestAlgorithms(), contentInfo, aSN1Set2, null, new DERSet(aSN1EncodableVector2))).getEncoded("DER");
    }

    private ASN1OctetString firma(String string, PrivateKey privateKey, Certificate[] certificateArray) throws AOException {
        byte[] byArray;
        try {
            byArray = this.signedAttr2.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new AOException("Error al obtener los datos a firmar", iOException);
        }
        return new DEROctetString(new AOPkcs1Signer().sign(byArray, string, privateKey, certificateArray, null));
    }
}

