/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.multi.cades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.signers.AOCounterSigner;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AOSimpleSigner;
import es.gob.afirma.core.signers.AdESPolicy;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.signers.cades.CAdESSignerMetadataHelper;
import es.gob.afirma.signers.cades.CommitmentTypeIndicationsHelper;
import es.gob.afirma.signers.multi.cades.CAdESCounterSigner;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class AOCAdESCounterSigner
implements AOCounterSigner {
    private static final String SHA1_ALGORITHM = "SHA1";
    private final AOSimpleSigner ss;
    private final Date date;
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    public AOCAdESCounterSigner() {
        this.ss = null;
        this.date = null;
    }

    public AOCAdESCounterSigner(AOSimpleSigner aOSimpleSigner, Date date) {
        if (aOSimpleSigner == null) {
            throw new IllegalArgumentException("El firmador PKCS#1 no puede ser nulo");
        }
        if (date == null) {
            LOGGER.warning("Se ha establecido una fecha nula, se usara la actual");
        }
        this.ss = aOSimpleSigner;
        this.date = date;
    }

    @Override
    public final byte[] countersign(byte[] byArray, String string, CounterSignTarget counterSignTarget, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        boolean bl;
        Certificate[] certificateArray2;
        Certificate[] certificateArray3;
        Properties properties2;
        Properties properties3 = properties2 = properties != null ? properties : new Properties();
        if (Boolean.parseBoolean(properties2.getProperty("includeOnlySignningCertificate", Boolean.FALSE.toString()))) {
            X509Certificate[] x509CertificateArray = new X509Certificate[1];
            certificateArray3 = x509CertificateArray;
            x509CertificateArray[0] = (X509Certificate)certificateArray[0];
        } else {
            certificateArray3 = certificateArray2 = certificateArray;
        }
        if (AOSignConstants.isSHA2SignatureAlgorithm(string)) {
            bl = true;
            if (properties2.containsKey("signingCertificateV2")) {
                LOGGER.warning("Se ignorara la propiedad 'signingCertificateV2' porque las firmas SHA2 siempre usan SigningCertificateV2");
            }
        } else {
            bl = properties2.containsKey("signingCertificateV2") ? Boolean.parseBoolean(properties2.getProperty("signingCertificateV2")) : !SHA1_ALGORITHM.equals(AOSignConstants.getDigestAlgorithmName(string));
        }
        boolean bl2 = Boolean.parseBoolean(properties2.getProperty("doNotIncludePolicyOnSigningCertificate", Boolean.FALSE.toString()));
        String[] stringArray = null;
        String string2 = properties2.getProperty("signerClaimedRoles");
        if (string2 != null && !string2.isEmpty()) {
            stringArray = string2.split(Pattern.quote("|"));
        }
        CAdESCounterSigner cAdESCounterSigner = new CAdESCounterSigner();
        if (this.ss != null) {
            cAdESCounterSigner.setPkcs1Signer(this.ss, this.date);
        }
        if (counterSignTarget == CounterSignTarget.NODES || counterSignTarget == CounterSignTarget.SIGNERS) {
            throw new AOException("No se soporta la firma de nodos individuales");
        }
        byte[] byArray2 = null;
        try {
            byArray2 = cAdESCounterSigner.counterSign(string, byArray, counterSignTarget != null ? counterSignTarget : CounterSignTarget.LEAFS, privateKey, certificateArray2, AdESPolicy.buildAdESPolicy(properties2), bl, CommitmentTypeIndicationsHelper.getCommitmentTypeIndications(properties2), stringArray, Boolean.parseBoolean(properties2.getProperty("includeSigningTimeAttribute", Boolean.FALSE.toString())), CAdESSignerMetadataHelper.getCAdESSignerMetadata(properties2), bl2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AOException("Error generando la Contrafirma CAdES: " + noSuchAlgorithmException, noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            throw new AOException("Error generando la Contrafirma CAdES: " + certificateException, certificateException);
        }
        return byArray2;
    }
}

