/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.multi.cades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.MimeHelper;
import es.gob.afirma.core.signers.AOCoSigner;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AdESPolicy;
import es.gob.afirma.signers.cades.AOCAdESSigner;
import es.gob.afirma.signers.cades.CAdESSignerMetadataHelper;
import es.gob.afirma.signers.cades.CommitmentTypeIndicationsHelper;
import es.gob.afirma.signers.multi.cades.CAdESCoSigner;
import es.gob.afirma.signers.multi.cades.CAdESMultiUtil;
import es.gob.afirma.signers.pkcs7.P7ContentSignerParameters;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public final class AOCAdESCoSigner
implements AOCoSigner {
    private static final String SHA1_ALGORITHM = "SHA1";
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    @Override
    public byte[] cosign(byte[] byArray, byte[] byArray2, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        Object object;
        boolean bl;
        CAdESMultiUtil.checkUnsupportedAttributes(byArray2);
        Properties properties2 = properties != null ? properties : new Properties();
        boolean bl2 = Boolean.parseBoolean(properties2.getProperty("includeOnlySignningCertificate"));
        String string2 = properties2.getProperty("mode", "explicit");
        String string3 = properties2.getProperty("precalculatedHashAlgorithm");
        if (string3 != null && properties2.containsKey("mode")) {
            LOGGER.warning("Se ignorara el parametro 'mode' por haberse proporcionado tambien el parametro 'precalculatedHashAlgorithm'. La firma sera explicita.");
        }
        if (AOSignConstants.isSHA2SignatureAlgorithm(string)) {
            bl = true;
            if (properties2.containsKey("signingCertificateV2")) {
                LOGGER.warning("Se ignorara la propiedad 'signingCertificateV2' porque las firmas SHA2 siempre usan SigningCertificateV2");
            }
        } else {
            bl = properties2.containsKey("signingCertificateV2") ? Boolean.parseBoolean(properties2.getProperty("signingCertificateV2")) : !SHA1_ALGORITHM.equals(AOSignConstants.getDigestAlgorithmName(string));
        }
        String string4 = properties2.getProperty("contentTypeOid");
        String string5 = properties2.getProperty("contentDescription");
        boolean bl3 = Boolean.parseBoolean(properties2.getProperty("doNotIncludePolicyOnSigningCertificate", Boolean.FALSE.toString()));
        String[] stringArray = null;
        String string6 = properties2.getProperty("signerClaimedRoles");
        if (string6 != null && !string6.isEmpty()) {
            stringArray = string6.split(Pattern.quote("|"));
        }
        P7ContentSignerParameters p7ContentSignerParameters = new P7ContentSignerParameters(byArray, string);
        String string7 = "1.2.840.113549.1.7.1";
        String string8 = "binary";
        if (byArray != null && (string4 == null || string5 == null)) {
            try {
                object = new MimeHelper(byArray);
                string7 = MimeHelper.transformMimeTypeToOid(((MimeHelper)object).getMimeType());
                string8 = ((MimeHelper)object).getDescription();
            }
            catch (Exception exception) {
                LOGGER.warning("No se han podido cargar las librerias para identificar el tipo de dato firmado: " + exception);
            }
        }
        object = null;
        if (string3 != null) {
            object = byArray;
        }
        try {
            Certificate[] certificateArray2;
            boolean bl4 = "explicit".equalsIgnoreCase(string2) || string3 != null;
            CAdESCoSigner cAdESCoSigner = new CAdESCoSigner();
            AdESPolicy adESPolicy = AdESPolicy.buildAdESPolicy(properties2);
            if (bl2) {
                X509Certificate[] x509CertificateArray = new X509Certificate[1];
                certificateArray2 = x509CertificateArray;
                x509CertificateArray[0] = (X509Certificate)certificateArray[0];
            } else {
                certificateArray2 = certificateArray;
            }
            return cAdESCoSigner.coSigner(p7ContentSignerParameters, byArray2, bl4, adESPolicy, bl, privateKey, certificateArray2, (byte[])object, string4 != null ? string4 : string7, string5 != null ? string5 : string8, CommitmentTypeIndicationsHelper.getCommitmentTypeIndications(properties2), stringArray, Boolean.parseBoolean(properties2.getProperty("includeSigningTimeAttribute", Boolean.FALSE.toString())), CAdESSignerMetadataHelper.getCAdESSignerMetadata(properties2), bl3);
        }
        catch (Exception exception) {
            throw new AOException("Error generando la Cofirma CAdES: " + exception, exception);
        }
    }

    @Override
    public byte[] cosign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        boolean bl;
        CAdESMultiUtil.checkUnsupportedAttributes(byArray);
        Properties properties2 = properties != null ? properties : new Properties();
        boolean bl2 = Boolean.parseBoolean(properties2.getProperty("includeOnlySignningCertificate"));
        if (AOSignConstants.isSHA2SignatureAlgorithm(string)) {
            bl = true;
            if (properties2.containsKey("signingCertificateV2")) {
                LOGGER.warning("Se ignorara la propiedad 'signingCertificateV2' porque las firmas SHA2 siempre usan SigningCertificateV2");
            }
        } else {
            bl = properties2.containsKey("signingCertificateV2") ? Boolean.parseBoolean(properties2.getProperty("signingCertificateV2")) : !SHA1_ALGORITHM.equals(AOSignConstants.getDigestAlgorithmName(string));
        }
        String string2 = properties2.getProperty("contentTypeOid");
        String string3 = properties2.getProperty("contentDescription");
        boolean bl3 = Boolean.parseBoolean(properties2.getProperty("doNotIncludePolicyOnSigningCertificate", Boolean.FALSE.toString()));
        String[] stringArray = null;
        String string4 = properties2.getProperty("signerClaimedRoles");
        if (string4 != null && !string4.isEmpty()) {
            stringArray = string4.split(Pattern.quote("|"));
        }
        String string5 = string;
        String string6 = "1.2.840.113549.1.7.1";
        String string7 = "binary";
        byte[] byArray2 = new AOCAdESSigner().getData(byArray);
        if (byArray2 != null && (string2 == null || string3 == null)) {
            try {
                MimeHelper mimeHelper = new MimeHelper(byArray2);
                string6 = MimeHelper.transformMimeTypeToOid(mimeHelper.getMimeType());
                string7 = mimeHelper.getDescription();
            }
            catch (Exception exception) {
                LOGGER.warning("No se han podido cargar las librerias para identificar el tipo de dato firmado: " + exception);
            }
        }
        try {
            X509Certificate[] x509CertificateArray;
            CAdESCoSigner cAdESCoSigner = new CAdESCoSigner();
            if (bl2) {
                X509Certificate[] x509CertificateArray2 = new X509Certificate[1];
                x509CertificateArray = x509CertificateArray2;
                x509CertificateArray2[0] = (X509Certificate)certificateArray[0];
            } else {
                x509CertificateArray = (X509Certificate[])certificateArray;
            }
            return cAdESCoSigner.coSigner(string5, x509CertificateArray, new ByteArrayInputStream(byArray), AdESPolicy.buildAdESPolicy(properties2), bl, privateKey, certificateArray, null, string2 != null ? string2 : string6, string3 != null ? string3 : string7, CommitmentTypeIndicationsHelper.getCommitmentTypeIndications(properties2), stringArray, Boolean.parseBoolean(properties2.getProperty("includeSigningTimeAttribute", Boolean.FALSE.toString())), CAdESSignerMetadataHelper.getCAdESSignerMetadata(properties2), bl3);
        }
        catch (Exception exception) {
            throw new AOException("Error generando la Cofirma CADES: " + exception, exception);
        }
    }
}

