/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cms;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.signers.cms.CmsUtil;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import es.gob.afirma.signers.pkcs7.P7ContentSignerParameters;
import es.gob.afirma.signers.pkcs7.SigUtils;
import java.io.FilterInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1InputStream;
import org.spongycastle.asn1.ASN1Object;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1OctetString;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.ASN1Set;
import org.spongycastle.asn1.ASN1TaggedObject;
import org.spongycastle.asn1.ASN1UTCTime;
import org.spongycastle.asn1.BERSet;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.DERPrintableString;
import org.spongycastle.asn1.DERSet;
import org.spongycastle.asn1.cms.Attribute;
import org.spongycastle.asn1.cms.AttributeTable;
import org.spongycastle.asn1.cms.CMSAttributes;
import org.spongycastle.asn1.cms.ContentInfo;
import org.spongycastle.asn1.cms.IssuerAndSerialNumber;
import org.spongycastle.asn1.cms.SignedData;
import org.spongycastle.asn1.cms.SignerIdentifier;
import org.spongycastle.asn1.cms.SignerInfo;
import org.spongycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.spongycastle.asn1.x500.X500Name;
import org.spongycastle.asn1.x500.style.RFC4519Style;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.asn1.x509.TBSCertificate;

final class CounterSigner {
    private int actualIndex = 0;
    private ASN1Set signedAttr2;
    private Map<String, byte[]> atrib2 = new HashMap<String, byte[]>();
    private Map<String, byte[]> uatrib2 = new HashMap<String, byte[]>();

    CounterSigner() {
    }

    byte[] counterSigner(P7ContentSignerParameters p7ContentSignerParameters, byte[] byArray, CounterSignTarget counterSignTarget, int[] nArray, PrivateKey privateKey, Certificate[] certificateArray, Map<String, byte[]> map, Map<String, byte[]> map2) throws IOException, NoSuchAlgorithmException, CertificateException, AOException {
        ASN1Sequence aSN1Sequence;
        this.atrib2 = map;
        this.uatrib2 = map2;
        Object object = new ASN1InputStream(byArray);
        Object object2 = null;
        try {
            aSN1Sequence = (ASN1Sequence)((ASN1InputStream)object).readObject();
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (object2 != null) {
                    try {
                        ((FilterInputStream)object).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    ((FilterInputStream)object).close();
                }
            }
        }
        object = aSN1Sequence.getObjects();
        object.nextElement();
        object2 = (ASN1TaggedObject)object.nextElement();
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)((ASN1TaggedObject)object2).getObject();
        SignedData signedData = SignedData.getInstance(aSN1Sequence2);
        ASN1Set aSN1Set = signedData.getSignerInfos();
        BERSet bERSet = null;
        ASN1Set aSN1Set2 = signedData.getCertificates();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Enumeration enumeration = aSN1Set2.getObjects();
        while (enumeration.hasMoreElements()) {
            aSN1EncodableVector.add((ASN1Encodable)enumeration.nextElement());
        }
        if (certificateArray.length != 0) {
            aSN1EncodableVector.add(org.spongycastle.asn1.x509.Certificate.getInstance(ASN1Primitive.fromByteArray(certificateArray[0].getEncoded())));
            bERSet = new BERSet(aSN1EncodableVector);
        }
        ASN1Set aSN1Set3 = null;
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        if (CounterSignTarget.TREE.equals((Object)counterSignTarget)) {
            aSN1EncodableVector2 = this.counterTree(aSN1Set, p7ContentSignerParameters, privateKey, certificateArray);
        } else if (CounterSignTarget.LEAFS.equals((Object)counterSignTarget)) {
            aSN1EncodableVector2 = this.counterLeaf(aSN1Set, p7ContentSignerParameters, privateKey, certificateArray);
        } else {
            if (CounterSignTarget.NODES.equals((Object)counterSignTarget) || counterSignTarget.equals((Object)CounterSignTarget.SIGNERS)) {
                SignedData signedData2 = signedData;
                for (int i = nArray.length - 1; i >= 0; --i) {
                    ASN1Sequence aSN1Sequence3;
                    aSN1EncodableVector2 = this.counterNode(signedData2, p7ContentSignerParameters, privateKey, certificateArray, nArray[i]);
                    SignedData signedData3 = new SignedData(signedData.getDigestAlgorithms(), signedData.getEncapContentInfo(), bERSet, aSN1Set3, new DERSet(aSN1EncodableVector2));
                    try (ASN1InputStream aSN1InputStream = new ASN1InputStream(signedData3.getEncoded("DER"));){
                        aSN1Sequence3 = (ASN1Sequence)aSN1InputStream.readObject();
                    }
                    signedData2 = SignedData.getInstance(aSN1Sequence3);
                }
                return new ContentInfo(PKCSObjectIdentifiers.signedData, signedData2).getEncoded("DER");
            }
            throw new IllegalArgumentException("Tipo de objetivo para la contrafirma no soportado: " + (Object)((Object)counterSignTarget));
        }
        return new ContentInfo(PKCSObjectIdentifiers.signedData, new SignedData(signedData.getDigestAlgorithms(), signedData.getEncapContentInfo(), bERSet, aSN1Set3, new DERSet(aSN1EncodableVector2))).getEncoded("DER");
    }

    private ASN1EncodableVector counterTree(ASN1Set aSN1Set, P7ContentSignerParameters p7ContentSignerParameters, PrivateKey privateKey, Certificate[] certificateArray) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i = 0; i < aSN1Set.size(); ++i) {
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Set.getObjectAt(i);
            SignerInfo signerInfo = SignerInfo.getInstance(aSN1Sequence);
            aSN1EncodableVector.add(this.getCounterUnsignedAtributes(signerInfo, p7ContentSignerParameters, privateKey, certificateArray));
        }
        return aSN1EncodableVector;
    }

    private ASN1EncodableVector counterLeaf(ASN1Set aSN1Set, P7ContentSignerParameters p7ContentSignerParameters, PrivateKey privateKey, Certificate[] certificateArray) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i = 0; i < aSN1Set.size(); ++i) {
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Set.getObjectAt(i);
            SignerInfo signerInfo = SignerInfo.getInstance(aSN1Sequence);
            aSN1EncodableVector.add(this.getCounterLeafUnsignedAtributes(signerInfo, p7ContentSignerParameters, privateKey, certificateArray));
        }
        return aSN1EncodableVector;
    }

    private ASN1EncodableVector counterNode(SignedData signedData, P7ContentSignerParameters p7ContentSignerParameters, PrivateKey privateKey, Certificate[] certificateArray, int n) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1Set aSN1Set = signedData.getSignerInfos();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1Set aSN1Set2 = aSN1Set;
        this.actualIndex = 0;
        for (int i = 0; i < aSN1Set2.size(); ++i) {
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Set2.getObjectAt(i);
            SignerInfo signerInfo = SignerInfo.getInstance(aSN1Sequence);
            SignerInfo signerInfo2 = null;
            if (this.actualIndex == n) {
                signerInfo2 = this.getCounterNodeUnsignedAtributes(signerInfo, p7ContentSignerParameters, privateKey, certificateArray);
            } else if (this.actualIndex != n) {
                signerInfo2 = this.getCounterNodeUnsignedAtributes(signerInfo, p7ContentSignerParameters, privateKey, certificateArray, n);
            }
            ++this.actualIndex;
            aSN1EncodableVector.add(signerInfo2);
        }
        return aSN1EncodableVector;
    }

    private SignerInfo getCounterUnsignedAtributes(SignerInfo signerInfo, P7ContentSignerParameters p7ContentSignerParameters, PrivateKey privateKey, Certificate[] certificateArray) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ArrayList arrayList = new ArrayList();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            Object object;
            Object object2;
            ASN1Object aSN1Object;
            Enumeration enumeration = signerInfo.getUnauthenticatedAttributes().getObjects();
            while (enumeration.hasMoreElements()) {
                aSN1Object = Attribute.getInstance(enumeration.nextElement());
                if (!aSN1Object.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) {
                    object2 = aSN1Object.getAttrValues();
                    object = ((ASN1Set)object2).getObjects();
                    while (object.hasMoreElements()) {
                        Object e = object.nextElement();
                        if (e instanceof ASN1Sequence) {
                            ASN1Sequence aSN1Sequence = (ASN1Sequence)e;
                            SignerInfo signerInfo2 = SignerInfo.getInstance(aSN1Sequence);
                            SignerInfo signerInfo3 = this.getCounterUnsignedAtributes(signerInfo2, p7ContentSignerParameters, privateKey, certificateArray);
                            aSN1EncodableVector.add(signerInfo3);
                            continue;
                        }
                        arrayList.add(e);
                    }
                    continue;
                }
                aSN1EncodableVector.add(aSN1Object);
            }
            aSN1EncodableVector.add(this.unsignedAtributte(p7ContentSignerParameters, signerInfo, privateKey, certificateArray));
            object2 = new ASN1EncodableVector();
            if (aSN1EncodableVector.size() > 1) {
                for (int i = 0; i < aSN1EncodableVector.size(); ++i) {
                    if (aSN1EncodableVector.get(i) instanceof Attribute) {
                        ((ASN1EncodableVector)object2).add(aSN1EncodableVector.get(i));
                        continue;
                    }
                    ((ASN1EncodableVector)object2).add(new Attribute(CMSAttributes.counterSignature, new DERSet(aSN1EncodableVector.get(i))));
                }
                aSN1Object = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object2));
                return new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), (ASN1Set)aSN1Object);
            }
            if (aSN1EncodableVector.size() == 1) {
                if (aSN1EncodableVector.get(0) instanceof Attribute) {
                    ((ASN1EncodableVector)object2).add(aSN1EncodableVector.get(0));
                    aSN1EncodableVector2.add(this.unsignedAtributte(p7ContentSignerParameters, signerInfo, privateKey, certificateArray));
                    object = new Attribute(CMSAttributes.counterSignature, new DERSet(aSN1EncodableVector2));
                    ((ASN1EncodableVector)object2).add((ASN1Encodable)object);
                } else {
                    ((ASN1EncodableVector)object2).add(new Attribute(CMSAttributes.counterSignature, new DERSet(aSN1EncodableVector.get(0))));
                }
                return new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object2)));
            }
            object = new Attribute(CMSAttributes.counterSignature, new DERSet(aSN1EncodableVector));
            return new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), this.generateUnsignerInfoFromCounter((Attribute)object));
        }
        aSN1EncodableVector2.add(this.unsignedAtributte(p7ContentSignerParameters, signerInfo, privateKey, certificateArray));
        Attribute attribute = new Attribute(CMSAttributes.counterSignature, new DERSet(aSN1EncodableVector2));
        return new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), this.generateUnsignerInfoFromCounter(attribute));
    }

    private SignerInfo getCounterLeafUnsignedAtributes(SignerInfo signerInfo, P7ContentSignerParameters p7ContentSignerParameters, PrivateKey privateKey, Certificate[] certificateArray) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ArrayList arrayList = new ArrayList();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            ASN1Object aSN1Object;
            Object object;
            Enumeration enumeration = signerInfo.getUnauthenticatedAttributes().getObjects();
            while (enumeration.hasMoreElements()) {
                object = Attribute.getInstance(enumeration.nextElement());
                if (!((Attribute)object).getAttrType().equals(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) {
                    aSN1Object = ((Attribute)object).getAttrValues();
                    Enumeration enumeration2 = aSN1Object.getObjects();
                    while (enumeration2.hasMoreElements()) {
                        Object e = enumeration2.nextElement();
                        if (e instanceof ASN1Sequence) {
                            SignerInfo signerInfo2 = SignerInfo.getInstance(e);
                            SignerInfo signerInfo3 = this.getCounterLeafUnsignedAtributes(signerInfo2, p7ContentSignerParameters, privateKey, certificateArray);
                            aSN1EncodableVector.add(signerInfo3);
                            continue;
                        }
                        arrayList.add(e);
                    }
                    continue;
                }
                aSN1EncodableVector.add((ASN1Encodable)object);
            }
            object = new ASN1EncodableVector();
            if (aSN1EncodableVector.size() > 1) {
                for (int i = 0; i < aSN1EncodableVector.size(); ++i) {
                    if (aSN1EncodableVector.get(i) instanceof Attribute) {
                        ((ASN1EncodableVector)object).add(aSN1EncodableVector.get(i));
                        continue;
                    }
                    ((ASN1EncodableVector)object).add(new Attribute(CMSAttributes.counterSignature, new DERSet(aSN1EncodableVector.get(i))));
                }
                return new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object)));
            }
            if (aSN1EncodableVector.size() == 1) {
                if (aSN1EncodableVector.get(0) instanceof Attribute) {
                    ((ASN1EncodableVector)object).add(aSN1EncodableVector.get(0));
                    aSN1EncodableVector2.add(this.unsignedAtributte(p7ContentSignerParameters, signerInfo, privateKey, certificateArray));
                    aSN1Object = new Attribute(CMSAttributes.counterSignature, new DERSet(aSN1EncodableVector2));
                    ((ASN1EncodableVector)object).add(aSN1Object);
                } else {
                    ((ASN1EncodableVector)object).add(new Attribute(CMSAttributes.counterSignature, new DERSet(aSN1EncodableVector.get(0))));
                }
                return new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object)));
            }
            aSN1Object = new Attribute(CMSAttributes.counterSignature, new DERSet(aSN1EncodableVector));
            return new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), this.generateUnsignerInfoFromCounter((Attribute)aSN1Object));
        }
        aSN1EncodableVector2.add(this.unsignedAtributte(p7ContentSignerParameters, signerInfo, privateKey, certificateArray));
        Attribute attribute = new Attribute(CMSAttributes.counterSignature, new DERSet(aSN1EncodableVector2));
        return new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(attribute));
    }

    private SignerInfo getCounterNodeUnsignedAtributes(SignerInfo signerInfo, P7ContentSignerParameters p7ContentSignerParameters, PrivateKey privateKey, Certificate[] certificateArray) throws NoSuchAlgorithmException, IOException, CertificateException {
        ArrayList arrayList = new ArrayList();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            ASN1Object aSN1Object;
            Object object;
            Enumeration enumeration = signerInfo.getUnauthenticatedAttributes().getObjects();
            while (enumeration.hasMoreElements()) {
                object = Attribute.getInstance(enumeration.nextElement());
                if (!((Attribute)object).getAttrType().equals(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) {
                    aSN1Object = ((Attribute)object).getAttrValues();
                    Enumeration enumeration2 = aSN1Object.getObjects();
                    while (enumeration2.hasMoreElements()) {
                        Object e = enumeration2.nextElement();
                        if (e instanceof ASN1Sequence) {
                            aSN1EncodableVector.add(SignerInfo.getInstance(e));
                            continue;
                        }
                        arrayList.add(e);
                    }
                    continue;
                }
                aSN1EncodableVector.add((ASN1Encodable)object);
            }
            aSN1EncodableVector.add(this.unsignedAtributte(p7ContentSignerParameters, signerInfo, privateKey, certificateArray));
            object = new ASN1EncodableVector();
            if (aSN1EncodableVector.size() > 1) {
                for (int i = 0; i < aSN1EncodableVector.size(); ++i) {
                    if (aSN1EncodableVector.get(i) instanceof Attribute) {
                        ((ASN1EncodableVector)object).add(aSN1EncodableVector.get(i));
                        continue;
                    }
                    ((ASN1EncodableVector)object).add(new Attribute(CMSAttributes.counterSignature, new DERSet(aSN1EncodableVector.get(i))));
                }
                return new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object)));
            }
            if (aSN1EncodableVector.size() == 1) {
                if (aSN1EncodableVector.get(0) instanceof Attribute) {
                    ((ASN1EncodableVector)object).add(aSN1EncodableVector.get(0));
                    aSN1EncodableVector2.add(this.unsignedAtributte(p7ContentSignerParameters, signerInfo, privateKey, certificateArray));
                    aSN1Object = new Attribute(CMSAttributes.counterSignature, new DERSet(aSN1EncodableVector2));
                    ((ASN1EncodableVector)object).add(aSN1Object);
                } else {
                    ((ASN1EncodableVector)object).add(new Attribute(CMSAttributes.counterSignature, new DERSet(aSN1EncodableVector.get(0))));
                }
                return new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object)));
            }
            aSN1Object = new Attribute(CMSAttributes.counterSignature, new DERSet(aSN1EncodableVector));
            return new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), this.generateUnsignerInfoFromCounter((Attribute)aSN1Object));
        }
        aSN1EncodableVector2.add(this.unsignedAtributte(p7ContentSignerParameters, signerInfo, privateKey, certificateArray));
        Attribute attribute = new Attribute(CMSAttributes.counterSignature, new DERSet(aSN1EncodableVector2));
        return new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(attribute));
    }

    private SignerInfo getCounterNodeUnsignedAtributes(SignerInfo signerInfo, P7ContentSignerParameters p7ContentSignerParameters, PrivateKey privateKey, Certificate[] certificateArray, int n) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ArrayList arrayList = new ArrayList();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        SignerInfo signerInfo2 = null;
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            Object object;
            ASN1Object aSN1Object;
            Enumeration enumeration = signerInfo.getUnauthenticatedAttributes().getObjects();
            while (enumeration.hasMoreElements()) {
                aSN1Object = Attribute.getInstance(enumeration.nextElement());
                if (!aSN1Object.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) {
                    object = aSN1Object.getAttrValues();
                    Enumeration enumeration2 = ((ASN1Set)object).getObjects();
                    while (enumeration2.hasMoreElements()) {
                        Object e = enumeration2.nextElement();
                        if (e instanceof ASN1Sequence) {
                            ASN1Sequence aSN1Sequence = (ASN1Sequence)e;
                            SignerInfo signerInfo3 = SignerInfo.getInstance(aSN1Sequence);
                            ++this.actualIndex;
                            if (this.actualIndex != n) {
                                if (this.actualIndex < n) {
                                    aSN1EncodableVector.add(this.getCounterNodeUnsignedAtributes(signerInfo3, p7ContentSignerParameters, privateKey, certificateArray, n));
                                    continue;
                                }
                                aSN1EncodableVector.add(signerInfo3);
                                continue;
                            }
                            aSN1EncodableVector.add(this.getCounterNodeUnsignedAtributes(signerInfo3, p7ContentSignerParameters, privateKey, certificateArray));
                            continue;
                        }
                        arrayList.add(e);
                    }
                    continue;
                }
                aSN1EncodableVector.add(aSN1Object);
            }
            object = new ASN1EncodableVector();
            if (aSN1EncodableVector.size() > 1) {
                for (int i = 0; i < aSN1EncodableVector.size(); ++i) {
                    if (aSN1EncodableVector.get(i) instanceof Attribute) {
                        ((ASN1EncodableVector)object).add(aSN1EncodableVector.get(i));
                        continue;
                    }
                    ((ASN1EncodableVector)object).add(new Attribute(CMSAttributes.counterSignature, new DERSet(aSN1EncodableVector.get(i))));
                }
                aSN1Object = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object));
                signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), (ASN1Set)aSN1Object);
            } else if (aSN1EncodableVector.size() == 1) {
                if (aSN1EncodableVector.get(0) instanceof Attribute) {
                    ((ASN1EncodableVector)object).add(aSN1EncodableVector.get(0));
                } else {
                    ((ASN1EncodableVector)object).add(new Attribute(CMSAttributes.counterSignature, new DERSet(aSN1EncodableVector.get(0))));
                }
                aSN1Object = SigUtils.getAttributeSet(new AttributeTable((ASN1EncodableVector)object));
                signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), (ASN1Set)aSN1Object);
            }
        } else {
            signerInfo2 = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), null);
        }
        return signerInfo2;
    }

    private ASN1Set generateSignerInfo(X509Certificate x509Certificate, String string, byte[] byArray) throws NoSuchAlgorithmException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new Attribute(CMSAttributes.signingTime, new DERSet(new ASN1UTCTime(new Date()))));
        aSN1EncodableVector.add(new Attribute(CMSAttributes.messageDigest, new DERSet(new DEROctetString(MessageDigest.getInstance(AOSignConstants.getDigestAlgorithmName(string)).digest(byArray)))));
        aSN1EncodableVector.add(new Attribute(RFC4519Style.serialNumber, new DERSet(new DERPrintableString(x509Certificate.getSerialNumber().toString()))));
        if (this.atrib2.size() != 0) {
            for (Map.Entry<String, byte[]> entry : this.atrib2.entrySet()) {
                aSN1EncodableVector.add(new Attribute(new ASN1ObjectIdentifier(entry.getKey().toString()), new DERSet(new DERPrintableString(new String(entry.getValue())))));
            }
        }
        this.signedAttr2 = SigUtils.getAttributeSet(new AttributeTable(aSN1EncodableVector));
        return SigUtils.getAttributeSet(new AttributeTable(aSN1EncodableVector));
    }

    private ASN1Set generateUnsignerInfo() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.uatrib2.size() != 0) {
            for (Map.Entry<String, byte[]> entry : this.uatrib2.entrySet()) {
                aSN1EncodableVector.add(new Attribute(new ASN1ObjectIdentifier(entry.getKey().toString()), new DERSet(new DERPrintableString(new String(entry.getValue())))));
            }
        } else {
            return null;
        }
        return SigUtils.getAttributeSet(new AttributeTable(aSN1EncodableVector));
    }

    private ASN1Set generateUnsignerInfoFromCounter(Attribute attribute) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.uatrib2.size() != 0) {
            for (Map.Entry<String, byte[]> entry : this.uatrib2.entrySet()) {
                aSN1EncodableVector.add(new Attribute(new ASN1ObjectIdentifier(entry.getKey().toString()), new DERSet(new DERPrintableString(new String(entry.getValue())))));
            }
        }
        aSN1EncodableVector.add(attribute);
        return SigUtils.getAttributeSet(new AttributeTable(aSN1EncodableVector));
    }

    private SignerInfo unsignedAtributte(P7ContentSignerParameters p7ContentSignerParameters, SignerInfo signerInfo, PrivateKey privateKey, Certificate[] certificateArray) throws NoSuchAlgorithmException, IOException, CertificateException {
        ASN1OctetString aSN1OctetString;
        String string = p7ContentSignerParameters.getSignatureAlgorithm();
        String string2 = AOSignConstants.getDigestAlgorithmName(string);
        ASN1Set aSN1Set = this.generateSignerInfo((X509Certificate)certificateArray[0], string2, signerInfo.getEncryptedDigest().getOctets());
        ASN1Set aSN1Set2 = this.generateUnsignerInfo();
        TBSCertificate tBSCertificate = TBSCertificate.getInstance(ASN1Primitive.fromByteArray(((X509Certificate)certificateArray[0]).getTBSCertificate()));
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(X500Name.getInstance(tBSCertificate.getIssuer()), tBSCertificate.getSerialNumber().getValue());
        SignerIdentifier signerIdentifier = new SignerIdentifier(issuerAndSerialNumber);
        AlgorithmIdentifier algorithmIdentifier = SigUtils.makeAlgId(AOAlgorithmID.getOID(string2));
        AlgorithmIdentifier algorithmIdentifier2 = SigUtils.makeAlgId(AOAlgorithmID.getOID("RSA"));
        try {
            aSN1OctetString = CmsUtil.firma(string, privateKey, this.signedAttr2);
        }
        catch (Exception exception) {
            throw new IOException("Error realizando la firma: " + exception, exception);
        }
        return new SignerInfo(signerIdentifier, algorithmIdentifier, aSN1Set, algorithmIdentifier2, aSN1OctetString, aSN1Set2);
    }
}

