/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cms;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.signers.cms.CmsUtil;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import es.gob.afirma.signers.pkcs7.ContainsNoDataException;
import es.gob.afirma.signers.pkcs7.P7ContentSignerParameters;
import es.gob.afirma.signers.pkcs7.SigUtils;
import java.io.FilterInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1InputStream;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1OctetString;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.ASN1Set;
import org.spongycastle.asn1.ASN1TaggedObject;
import org.spongycastle.asn1.ASN1UTCTime;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.DERPrintableString;
import org.spongycastle.asn1.DERSet;
import org.spongycastle.asn1.cms.Attribute;
import org.spongycastle.asn1.cms.AttributeTable;
import org.spongycastle.asn1.cms.CMSAttributes;
import org.spongycastle.asn1.cms.ContentInfo;
import org.spongycastle.asn1.cms.IssuerAndSerialNumber;
import org.spongycastle.asn1.cms.SignedData;
import org.spongycastle.asn1.cms.SignerIdentifier;
import org.spongycastle.asn1.cms.SignerInfo;
import org.spongycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.spongycastle.asn1.x500.X500Name;
import org.spongycastle.asn1.x500.style.RFC4519Style;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.asn1.x509.TBSCertificate;

final class CoSigner {
    private ASN1Set signedAttr2;

    CoSigner() {
    }

    byte[] coSigner(P7ContentSignerParameters p7ContentSignerParameters, byte[] byArray, boolean bl, String string, PrivateKey privateKey, Certificate[] certificateArray, Map<String, byte[]> map, Map<String, byte[]> map2, byte[] byArray2) throws IOException, NoSuchAlgorithmException, CertificateException {
        ASN1OctetString aSN1OctetString;
        Object object2;
        ASN1Sequence aSN1Sequence;
        Object object3 = new ASN1InputStream(byArray);
        Object object4 = null;
        try {
            aSN1Sequence = (ASN1Sequence)((ASN1InputStream)object3).readObject();
        }
        catch (Throwable throwable) {
            object4 = throwable;
            throw throwable;
        }
        finally {
            if (object3 != null) {
                if (object4 != null) {
                    try {
                        ((FilterInputStream)object3).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object4).addSuppressed(throwable);
                    }
                } else {
                    ((FilterInputStream)object3).close();
                }
            }
        }
        object3 = aSN1Sequence.getObjects();
        object3.nextElement();
        object4 = (ASN1TaggedObject)object3.nextElement();
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)((ASN1TaggedObject)object4).getObject();
        SignedData signedData = SignedData.getInstance(aSN1Sequence2);
        byte[] byArray3 = p7ContentSignerParameters.getContent();
        ContentInfo contentInfo = CmsUtil.getContentInfo(byArray3, bl, string);
        ASN1Set aSN1Set = null;
        ASN1Set aSN1Set2 = signedData.getCertificates();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Enumeration enumeration = aSN1Set2.getObjects();
        while (enumeration.hasMoreElements()) {
            aSN1EncodableVector.add((ASN1Encodable)enumeration.nextElement());
        }
        if (certificateArray.length != 0) {
            object2 = new ArrayList();
            for (Certificate certificate : certificateArray) {
                object2.add(org.spongycastle.asn1.x509.Certificate.getInstance(ASN1Primitive.fromByteArray(certificate.getEncoded())));
            }
            aSN1Set = SigUtils.fillRestCerts((List<ASN1Encodable>)object2, aSN1EncodableVector);
        }
        object2 = p7ContentSignerParameters.getSignatureAlgorithm();
        String string2 = AOSignConstants.getDigestAlgorithmName((String)object2);
        AlgorithmIdentifier algorithmIdentifier = SigUtils.makeAlgId(AOAlgorithmID.getOID(string2));
        TBSCertificate tBSCertificate = TBSCertificate.getInstance(ASN1Primitive.fromByteArray(((X509Certificate)certificateArray[0]).getTBSCertificate()));
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(X500Name.getInstance(tBSCertificate.getIssuer()), tBSCertificate.getSerialNumber().getValue());
        SignerIdentifier signerIdentifier = new SignerIdentifier(issuerAndSerialNumber);
        ASN1Set aSN1Set3 = null;
        aSN1Set3 = byArray2 == null ? this.generateSignerInfo(string2, byArray3 != null ? byArray3 : p7ContentSignerParameters.getContent(), string, map) : this.generateSignerInfoFromHash((X509Certificate)certificateArray[0], byArray2, string, map);
        ASN1Set aSN1Set4 = CoSigner.generateUnsignerInfo(map2);
        AlgorithmIdentifier algorithmIdentifier2 = SigUtils.makeAlgId(AOAlgorithmID.getOID("RSA"));
        ASN1Set aSN1Set5 = signedData.getSignerInfos();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        for (int i = 0; i < aSN1Set5.size(); ++i) {
            SignerInfo signerInfo = SignerInfo.getInstance(aSN1Set5.getObjectAt(i));
            aSN1EncodableVector2.add(signerInfo);
        }
        try {
            aSN1OctetString = CmsUtil.firma((String)object2, privateKey, this.signedAttr2);
        }
        catch (Exception exception) {
            throw new IOException("Error al generar la firma: " + exception, exception);
        }
        aSN1EncodableVector2.add(new SignerInfo(signerIdentifier, algorithmIdentifier, aSN1Set3, algorithmIdentifier2, aSN1OctetString, aSN1Set4));
        return new ContentInfo(PKCSObjectIdentifiers.signedData, new SignedData(signedData.getDigestAlgorithms(), contentInfo, aSN1Set, null, new DERSet(aSN1EncodableVector2))).getEncoded("DER");
    }

    byte[] coSigner(String string, X509Certificate[] x509CertificateArray, byte[] byArray, String string2, PrivateKey privateKey, Map<String, byte[]> map, Map<String, byte[]> map2, byte[] byArray2) throws IOException, NoSuchAlgorithmException, CertificateException, ContainsNoDataException {
        ASN1OctetString aSN1OctetString;
        Object object2;
        ASN1Sequence aSN1Sequence;
        byte[] byArray3 = byArray2 != null ? (byte[])byArray2.clone() : null;
        Object object3 = new ASN1InputStream(byArray);
        Object object4 = null;
        try {
            aSN1Sequence = (ASN1Sequence)((ASN1InputStream)object3).readObject();
        }
        catch (Throwable throwable) {
            object4 = throwable;
            throw throwable;
        }
        finally {
            if (object3 != null) {
                if (object4 != null) {
                    try {
                        ((FilterInputStream)object3).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object4).addSuppressed(throwable);
                    }
                } else {
                    ((FilterInputStream)object3).close();
                }
            }
        }
        object3 = aSN1Sequence.getObjects();
        object3.nextElement();
        object4 = (ASN1TaggedObject)object3.nextElement();
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)((ASN1TaggedObject)object4).getObject();
        SignedData signedData = SignedData.getInstance(aSN1Sequence2);
        ContentInfo contentInfo = signedData.getEncapContentInfo();
        DEROctetString dEROctetString = (DEROctetString)contentInfo.getContent();
        byte[] byArray4 = null;
        if (dEROctetString != null) {
            byArray4 = AOUtil.getDataFromInputStream(dEROctetString.getOctetStream());
        }
        ASN1Set aSN1Set = null;
        ASN1Set aSN1Set2 = signedData.getCertificates();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Enumeration enumeration = aSN1Set2.getObjects();
        while (enumeration.hasMoreElements()) {
            aSN1EncodableVector.add((ASN1Encodable)enumeration.nextElement());
        }
        if (x509CertificateArray.length != 0) {
            object2 = new ArrayList();
            for (X509Certificate x509Certificate : x509CertificateArray) {
                object2.add(org.spongycastle.asn1.x509.Certificate.getInstance(ASN1Primitive.fromByteArray(x509Certificate.getEncoded())));
            }
            aSN1Set = SigUtils.fillRestCerts((List<ASN1Encodable>)object2, aSN1EncodableVector);
        }
        object2 = AOSignConstants.getDigestAlgorithmName(string);
        AlgorithmIdentifier algorithmIdentifier = SigUtils.makeAlgId(AOAlgorithmID.getOID((String)object2));
        TBSCertificate tBSCertificate = TBSCertificate.getInstance(ASN1Primitive.fromByteArray(x509CertificateArray[0].getTBSCertificate()));
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(X500Name.getInstance(tBSCertificate.getIssuer()), tBSCertificate.getSerialNumber().getValue());
        SignerIdentifier signerIdentifier = new SignerIdentifier(issuerAndSerialNumber);
        ASN1Set aSN1Set3 = null;
        ASN1Set aSN1Set4 = CoSigner.generateUnsignerInfo(map2);
        AlgorithmIdentifier algorithmIdentifier2 = SigUtils.makeAlgId(AOAlgorithmID.getOID("RSA"));
        ASN1Set aSN1Set5 = signedData.getSignerInfos();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        for (int i = 0; i < aSN1Set5.size(); ++i) {
            SignerInfo signerInfo = SignerInfo.getInstance(aSN1Set5.getObjectAt(i));
            AlgorithmIdentifier algorithmIdentifier3 = signerInfo.getDigestAlgorithm();
            if (algorithmIdentifier3.getAlgorithm().toString().equals(AOAlgorithmID.getOID((String)object2))) {
                ASN1Set aSN1Set6 = signerInfo.getAuthenticatedAttributes();
                for (int j = 0; j < aSN1Set6.size(); ++j) {
                    ASN1Sequence aSN1Sequence3 = (ASN1Sequence)aSN1Set6.getObjectAt(j);
                    ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)aSN1Sequence3.getObjectAt(0);
                    if (!CMSAttributes.messageDigest.getId().toString().equals(aSN1ObjectIdentifier.toString())) continue;
                    DERSet dERSet = (DERSet)aSN1Sequence3.getObjectAt(1);
                    DEROctetString dEROctetString2 = (DEROctetString)dERSet.getObjectAt(0);
                    byArray3 = dEROctetString2.getOctets();
                }
            }
            aSN1EncodableVector2.add(signerInfo);
        }
        if (byArray4 != null) {
            aSN1Set3 = this.generateSignerInfo((String)object2, byArray4, string2, map);
        } else if (byArray3 != null) {
            aSN1Set3 = this.generateSignerInfoFromHash(x509CertificateArray[0], byArray3, string2, map);
        } else {
            throw new ContainsNoDataException("No se puede crear la cofirma ya que no se han encontrado ni los datos firmados ni una huella digital compatible con el algoritmo de firma");
        }
        try {
            aSN1OctetString = CmsUtil.firma(string, privateKey, this.signedAttr2);
        }
        catch (Exception exception) {
            throw new IOException("Error al generar la firma: " + exception, exception);
        }
        aSN1EncodableVector2.add(new SignerInfo(signerIdentifier, algorithmIdentifier, aSN1Set3, algorithmIdentifier2, aSN1OctetString, aSN1Set4));
        return new ContentInfo(PKCSObjectIdentifiers.signedData, new SignedData(signedData.getDigestAlgorithms(), contentInfo, aSN1Set, null, new DERSet(aSN1EncodableVector2))).getEncoded("DER");
    }

    private ASN1Set generateSignerInfo(String string, byte[] byArray, String string2, Map<String, byte[]> map) throws NoSuchAlgorithmException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new Attribute(CMSAttributes.contentType, new DERSet(new ASN1ObjectIdentifier(string2))));
        aSN1EncodableVector.add(new Attribute(CMSAttributes.signingTime, new DERSet(new ASN1UTCTime(new Date()))));
        byte[] byArray2 = MessageDigest.getInstance(AOSignConstants.getDigestAlgorithmName(string)).digest(byArray);
        aSN1EncodableVector.add(new Attribute(CMSAttributes.messageDigest, new DERSet(new DEROctetString((byte[])byArray2.clone()))));
        if (map.size() != 0) {
            for (Map.Entry<String, byte[]> entry : map.entrySet()) {
                aSN1EncodableVector.add(new Attribute(new ASN1ObjectIdentifier(entry.getKey().toString()), new DERSet(new DERPrintableString(new String(entry.getValue())))));
            }
        }
        this.signedAttr2 = SigUtils.getAttributeSet(new AttributeTable(aSN1EncodableVector));
        return SigUtils.getAttributeSet(new AttributeTable(aSN1EncodableVector));
    }

    private ASN1Set generateSignerInfoFromHash(X509Certificate x509Certificate, byte[] byArray, String string, Map<String, byte[]> map) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new Attribute(CMSAttributes.contentType, new DERSet(new ASN1ObjectIdentifier(string))));
        aSN1EncodableVector.add(new Attribute(CMSAttributes.signingTime, new DERSet(new ASN1UTCTime(new Date()))));
        aSN1EncodableVector.add(new Attribute(CMSAttributes.messageDigest, new DERSet(new DEROctetString(byArray))));
        aSN1EncodableVector.add(new Attribute(RFC4519Style.serialNumber, new DERSet(new DERPrintableString(x509Certificate.getSerialNumber().toString()))));
        if (map.size() != 0) {
            for (Map.Entry<String, byte[]> entry : map.entrySet()) {
                aSN1EncodableVector.add(new Attribute(new ASN1ObjectIdentifier(entry.getKey().toString()), new DERSet(new DERPrintableString(new String(entry.getValue())))));
            }
        }
        this.signedAttr2 = SigUtils.getAttributeSet(new AttributeTable(aSN1EncodableVector));
        return SigUtils.getAttributeSet(new AttributeTable(aSN1EncodableVector));
    }

    private static ASN1Set generateUnsignerInfo(Map<String, byte[]> map) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (map.size() != 0) {
            for (Map.Entry<String, byte[]> entry : map.entrySet()) {
                aSN1EncodableVector.add(new Attribute(new ASN1ObjectIdentifier(entry.getKey().toString()), new DERSet(new DERPrintableString(new String(entry.getValue())))));
            }
        } else {
            return null;
        }
        return SigUtils.getAttributeSet(new AttributeTable(aSN1EncodableVector));
    }
}

