/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cadestri.client;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.misc.http.UrlHttpManager;
import es.gob.afirma.core.misc.http.UrlHttpManagerFactory;
import es.gob.afirma.core.signers.AOPkcs1Signer;
import es.gob.afirma.core.signers.AOSignInfo;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.core.signers.TriphaseData;
import es.gob.afirma.core.signers.TriphaseDataSigner;
import es.gob.afirma.core.util.tree.AOTreeModel;
import es.gob.afirma.signers.cadestri.client.PostSigner;
import es.gob.afirma.signers.cadestri.client.PreSigner;
import java.io.IOException;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Properties;
import java.util.logging.Logger;

public class AOCAdESTriPhaseSigner
implements AOSigner {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String CRYPTO_OPERATION_SIGN = "sign";
    private static final String CRYPTO_OPERATION_COSIGN = "cosign";
    private static final String CRYPTO_OPERATION_COUNTERSIGN = "countersign";
    private static final String PROPERTY_NAME_CS_TARGET = "target";
    private static final String SUCCESS = "OK";

    @Override
    public byte[] sign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        return AOCAdESTriPhaseSigner.triPhaseOperation("CAdES", CRYPTO_OPERATION_SIGN, byArray, string, privateKey, certificateArray, properties);
    }

    @Override
    public byte[] cosign(byte[] byArray, byte[] byArray2, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        return this.cosign(byArray2, string, privateKey, certificateArray, properties);
    }

    @Override
    public byte[] cosign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        return AOCAdESTriPhaseSigner.triPhaseOperation("CAdES", CRYPTO_OPERATION_COSIGN, byArray, string, privateKey, certificateArray, properties);
    }

    @Override
    public byte[] countersign(byte[] byArray, String string, CounterSignTarget counterSignTarget, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        if (counterSignTarget == null) {
            throw new IllegalArgumentException("No se han indicado los nodos objetivo de la contrafirma");
        }
        if (counterSignTarget != CounterSignTarget.TREE && counterSignTarget != CounterSignTarget.LEAFS) {
            throw new UnsupportedOperationException("El objetivo indicado para la contrafirma no esta soportado: " + (Object)((Object)counterSignTarget));
        }
        properties.setProperty(PROPERTY_NAME_CS_TARGET, counterSignTarget.toString());
        return AOCAdESTriPhaseSigner.triPhaseOperation("CAdES", CRYPTO_OPERATION_COUNTERSIGN, byArray, string, privateKey, certificateArray, properties);
    }

    @Override
    public AOTreeModel getSignersStructure(byte[] byArray, boolean bl) {
        throw new UnsupportedOperationException("No se soporta la obtencion de estructura de firmas en firma trifasica");
    }

    @Override
    public boolean isSign(byte[] byArray) {
        throw new UnsupportedOperationException("No se soporta comprobacion de si es firma en modo trifasico");
    }

    @Override
    public boolean isValidDataFile(byte[] byArray) {
        if (byArray == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        return true;
    }

    @Override
    public String getSignedName(String string, String string2) {
        return string + (string2 != null ? string2 : "") + ".csig";
    }

    @Override
    public byte[] getData(byte[] byArray) {
        throw new UnsupportedOperationException("No se soporta ela obtencion de datos en firma trifasica");
    }

    @Override
    public AOSignInfo getSignInfo(byte[] byArray) {
        throw new UnsupportedOperationException("No se soporta la obtencion de informacion de la firma en modo trifasico");
    }

    protected static byte[] triPhaseOperation(String string, String string2, byte[] byArray, String string3, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        byte[] byArray2;
        TriphaseData triphaseData;
        byte[] byArray3;
        URL uRL;
        if (properties == null) {
            throw new IllegalArgumentException("Se necesitan parametros adicionales");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("Es necesario proporcionar la clave privada de firma");
        }
        if (certificateArray == null || certificateArray.length == 0) {
            throw new IllegalArgumentException("Es necesario proporcionar el certificado de firma");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("No se ha proporcionado el identificador de documento a firmar");
        }
        try {
            uRL = new URL(properties.getProperty("serverUrl"));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("No se ha proporcionado una URL valida para el servidor de firma: " + properties.getProperty("serverUrl"), exception);
        }
        String string4 = Base64.encode(byArray, true);
        UrlHttpManager urlHttpManager = UrlHttpManagerFactory.getInstalledManager();
        try {
            byArray3 = PreSigner.preSign(string, string3, certificateArray, string2, string4, urlHttpManager, uRL, properties);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new AOException("Error decodificando el certificado del firmante: " + certificateEncodingException, certificateEncodingException);
        }
        catch (IOException iOException) {
            throw new AOException("Error en la llamada de prefirma al servidor: " + iOException, iOException);
        }
        try {
            triphaseData = TriphaseData.parser(Base64.decode(byArray3, 0, byArray3.length, true));
        }
        catch (Exception exception) {
            LOGGER.severe("Error al analizar la prefirma enviada por el servidor: " + exception);
            throw new AOException("Error al analizar la prefirma enviada por el servidor", exception);
        }
        String string5 = Base64.encode(TriphaseDataSigner.doSign(new AOPkcs1Signer(), string3, privateKey, certificateArray, triphaseData).toString().getBytes(), true);
        try {
            byArray2 = PostSigner.postSign(string, string3, certificateArray, string2, string4, properties, true, urlHttpManager, uRL, string5);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new AOException("Error en el tratamiento del certificado del firmante en la postfirma: " + certificateEncodingException, certificateEncodingException);
        }
        catch (IOException iOException) {
            throw new AOException("Error en la postfirma: " + iOException, iOException);
        }
        String string6 = new String(byArray2).trim();
        if (!string6.startsWith(SUCCESS)) {
            throw new AOException("La firma trifasica no ha finalizado correctamente: " + new String(byArray2));
        }
        try {
            return Base64.decode(string6.substring("OK NEWID=".length()), true);
        }
        catch (IOException iOException) {
            LOGGER.warning("El resultado de NEWID del servidor no estaba en Base64: " + iOException);
            throw new AOException("El resultado devuelto por el servidor no es correcto", iOException);
        }
    }
}

