/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cades.asic;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.AOInvalidFormatException;
import es.gob.afirma.core.signers.AOCoSigner;
import es.gob.afirma.core.signers.AOCounterSigner;
import es.gob.afirma.core.signers.AOSignInfo;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.core.signers.asic.ASiCUtil;
import es.gob.afirma.core.util.tree.AOTreeModel;
import es.gob.afirma.signers.cades.AOCAdESSigner;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Properties;
import java.util.logging.Logger;

public final class AOCAdESASiCSSigner
implements AOSigner {
    private static final Logger LOGGER = Logger.getLogger("es.agob.afirma");

    @Override
    public byte[] sign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        Properties properties2 = properties != null ? properties : new Properties();
        properties2.put("mode", "explicit");
        byte[] byArray2 = new AOCAdESSigner().sign(byArray, string, privateKey, certificateArray, properties2);
        return ASiCUtil.createSContainer(byArray2, byArray, "META-INF/signature.p7s", properties2.getProperty("asicsFilename"));
    }

    @Override
    public AOTreeModel getSignersStructure(byte[] byArray, boolean bl) throws AOInvalidFormatException, IOException {
        return new AOCAdESSigner().getSignersStructure(ASiCUtil.getASiCSBinarySignature(byArray), bl);
    }

    @Override
    public boolean isSign(byte[] byArray) throws IOException {
        byte[] byArray2;
        try {
            byArray2 = ASiCUtil.getASiCSBinarySignature(byArray);
        }
        catch (Exception exception) {
            return false;
        }
        return new AOCAdESASiCSSigner().isSign(byArray2);
    }

    @Override
    public boolean isValidDataFile(byte[] byArray) {
        if (byArray == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        return true;
    }

    @Override
    public String getSignedName(String string, String string2) {
        return string + (string2 != null ? string2 : "") + ".asics";
    }

    @Override
    public byte[] getData(byte[] byArray) throws IOException {
        return ASiCUtil.getASiCSData(byArray);
    }

    @Override
    public AOSignInfo getSignInfo(byte[] byArray) throws AOException, IOException {
        return new AOCAdESASiCSSigner().getSignInfo(ASiCUtil.getASiCSBinarySignature(byArray));
    }

    @Override
    public byte[] cosign(byte[] byArray, byte[] byArray2, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        try {
            return ((AOCoSigner)Class.forName("es.gob.afirma.signers.multi.cades.asic.AOCAdESASiCSCoSigner").getConstructor(new Class[0]).newInstance(new Object[0])).cosign(byArray, byArray2, string, privateKey, certificateArray, properties);
        }
        catch (InstantiationException instantiationException) {
            throw new AOException("Error al instanciar la clase de cofirmas CAdES: " + instantiationException, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AOException("No se ha podido instanciar la clase de cofirmas CAdES ASiC: " + illegalAccessException, illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AOException("No se ha encontrado la clase de cofirmas CAdES ASiC: " + classNotFoundException, classNotFoundException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AOException("No se ha podido instanciar la clase de cofirmas CAdES ASiC: " + illegalArgumentException, illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AOException("No se ha podido instanciar la clase de cofirmas CAdES ASiC: " + invocationTargetException, invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AOException("No se ha podido instanciar la clase de cofirmas CAdES ASiC por falta de un constructor por defecto sin parametros: " + noSuchMethodException, noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new AOException("No se ha podido instanciar la clase de cofirmas CAdES ASiC por motivos de seguridad: " + securityException, securityException);
        }
    }

    @Override
    public byte[] cosign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        return this.cosign(null, byArray, string, privateKey, certificateArray, properties);
    }

    @Override
    public byte[] countersign(byte[] byArray, String string, CounterSignTarget counterSignTarget, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        try {
            return ((AOCounterSigner)Class.forName("es.gob.afirma.signers.multi.cades.asic.AOCAdESASiCSCounterSigner").getConstructor(new Class[0]).newInstance(new Object[0])).countersign(byArray, string, counterSignTarget, objectArray, privateKey, certificateArray, properties);
        }
        catch (InstantiationException instantiationException) {
            throw new AOException("Error al instanciar la clase de cofirmas CAdES ASiC: " + instantiationException, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AOException("No se ha podido instanciar la clase de cofirmas CAdES ASiC: " + illegalAccessException, illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AOException("No se ha encontrado la clase de cofirmas CAdES ASiC: " + classNotFoundException, classNotFoundException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AOException("No se ha podido instanciar la clase de cofirmas CAdES ASiC: " + illegalArgumentException, illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AOException("No se ha podido instanciar la clase de cofirmas CAdES ASiC: " + invocationTargetException, invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AOException("No se ha podido instanciar la clase de cofirmas CAdES ASiC por falta de un constructor por defecto sin parametros: " + noSuchMethodException, noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new AOException("No se ha podido instanciar la clase de cofirmas CAdES ASiC por motivos de seguridad: " + securityException, securityException);
        }
    }
}

