/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cades;

import es.gob.afirma.signers.cades.CommitmentTypeIndicationBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.DERSequence;
import org.spongycastle.asn1.esf.CommitmentTypeIdentifier;
import org.spongycastle.asn1.esf.CommitmentTypeIndication;

public final class CommitmentTypeIndicationsHelper {
    private static final ASN1ObjectIdentifier COMMITMENT_TYPE_IDENTIFIER_PROOF_OF_ORIGIN = CommitmentTypeIdentifier.proofOfOrigin;
    private static final ASN1ObjectIdentifier COMMITMENT_TYPE_IDENTIFIER_PROOF_OF_RECEIPT = CommitmentTypeIdentifier.proofOfReceipt;
    private static final ASN1ObjectIdentifier COMMITMENT_TYPE_IDENTIFIER_PROOF_OF_DELIVERY = CommitmentTypeIdentifier.proofOfDelivery;
    private static final ASN1ObjectIdentifier COMMITMENT_TYPE_IDENTIFIER_PROOF_OF_SENDER = CommitmentTypeIdentifier.proofOfSender;
    private static final ASN1ObjectIdentifier COMMITMENT_TYPE_IDENTIFIER_PROOF_OF_APPROVAL = CommitmentTypeIdentifier.proofOfApproval;
    private static final ASN1ObjectIdentifier COMMITMENT_TYPE_IDENTIFIER_PROOF_OF_CREATION = CommitmentTypeIdentifier.proofOfCreation;
    private static final Map<String, ASN1ObjectIdentifier> COMMITMENT_TYPE_IDENTIFIERS = new HashMap<String, ASN1ObjectIdentifier>(6);
    private static final Logger LOGGER;

    private CommitmentTypeIndicationsHelper() {
    }

    public static List<CommitmentTypeIndicationBean> getCommitmentTypeIndications(Properties properties) {
        int n;
        ArrayList<CommitmentTypeIndicationBean> arrayList = new ArrayList<CommitmentTypeIndicationBean>();
        if (properties == null) {
            return arrayList;
        }
        String string = properties.getProperty("commitmentTypeIndications");
        if (string == null) {
            return arrayList;
        }
        try {
            n = Integer.parseInt(string);
            if (n < 1) {
                throw new NumberFormatException();
            }
        }
        catch (Exception exception) {
            LOGGER.severe("El parametro adicional 'CommitmentTypeIndications' debe contener un valor numerico entero (el valor actual es " + string + "), no se anadira el CommitmentTypeIndication: " + exception);
            return arrayList;
        }
        for (int i = 0; i <= n; ++i) {
            ArrayList<String> arrayList2;
            string = properties.getProperty("commitmentTypeIndication" + Integer.toString(i) + "Identifier");
            if (string == null) continue;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = COMMITMENT_TYPE_IDENTIFIERS.get(string);
            if (aSN1ObjectIdentifier == null) {
                LOGGER.severe("El identificador del CommitmentTypeIndication " + i + " no es un tipo soportado (" + string + "), se omitira y se continuara con el siguiente");
                continue;
            }
            String string2 = aSN1ObjectIdentifier.toString();
            string = properties.getProperty("commitmentTypeIndication" + Integer.toString(i) + "CommitmentTypeQualifiers");
            if (string == null) {
                arrayList2 = null;
            } else {
                String[] stringArray;
                arrayList2 = new ArrayList<String>();
                for (String string3 : stringArray = string.split(Pattern.quote("|"))) {
                    arrayList2.add(string3);
                }
            }
            arrayList.add(new CommitmentTypeIndicationBean(string2, arrayList2));
        }
        return arrayList;
    }

    static CommitmentTypeIndication generateCommitmentTypeIndication(CommitmentTypeIndicationBean commitmentTypeIndicationBean) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        if (commitmentTypeIndicationBean == null) {
            throw new IllegalArgumentException("El CommitmentTypeIndicationBean no puede ser nulo");
        }
        try {
            aSN1ObjectIdentifier = new ASN1ObjectIdentifier(commitmentTypeIndicationBean.getIdentifier());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("El identificador del CommitmentTypeIndication debe ser un OID valido: " + exception, exception);
        }
        if (commitmentTypeIndicationBean.getQualifiers() == null || commitmentTypeIndicationBean.getQualifiers().size() < 1) {
            return new CommitmentTypeIndication(aSN1ObjectIdentifier);
        }
        String[] stringArray = commitmentTypeIndicationBean.getQualifiers().toArray(new String[0]);
        ASN1Encodable[] aSN1EncodableArray = new ASN1ObjectIdentifier[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                aSN1EncodableArray[i] = new ASN1ObjectIdentifier(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("El calificador proporcionado no es un OID (" + stringArray[i] + "): " + exception, exception);
            }
        }
        return new CommitmentTypeIndication(aSN1ObjectIdentifier, new DERSequence(aSN1EncodableArray));
    }

    static {
        COMMITMENT_TYPE_IDENTIFIERS.put("1", COMMITMENT_TYPE_IDENTIFIER_PROOF_OF_ORIGIN);
        COMMITMENT_TYPE_IDENTIFIERS.put("2", COMMITMENT_TYPE_IDENTIFIER_PROOF_OF_RECEIPT);
        COMMITMENT_TYPE_IDENTIFIERS.put("3", COMMITMENT_TYPE_IDENTIFIER_PROOF_OF_DELIVERY);
        COMMITMENT_TYPE_IDENTIFIERS.put("4", COMMITMENT_TYPE_IDENTIFIER_PROOF_OF_SENDER);
        COMMITMENT_TYPE_IDENTIFIERS.put("5", COMMITMENT_TYPE_IDENTIFIER_PROOF_OF_APPROVAL);
        COMMITMENT_TYPE_IDENTIFIERS.put("6", COMMITMENT_TYPE_IDENTIFIER_PROOF_OF_CREATION);
        LOGGER = Logger.getLogger("es.gob.afirma");
    }
}

