/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cades;

import es.gob.afirma.signers.pkcs7.DigestedData;
import es.gob.afirma.signers.pkcs7.SignedAndEnvelopedData;
import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Logger;
import org.spongycastle.asn1.ASN1InputStream;
import org.spongycastle.asn1.ASN1Integer;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.ASN1Set;
import org.spongycastle.asn1.ASN1TaggedObject;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.cms.Attribute;
import org.spongycastle.asn1.cms.EncryptedContentInfo;
import org.spongycastle.asn1.cms.EnvelopedData;
import org.spongycastle.asn1.cms.SignedData;
import org.spongycastle.asn1.cms.SignerInfo;
import org.spongycastle.asn1.pkcs.PKCSObjectIdentifiers;

public final class CAdESValidator {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afima");

    private CAdESValidator() {
    }

    private static Enumeration<?> getCAdESObjects(byte[] byArray) throws IOException {
        try (ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);){
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
            Enumeration enumeration = aSN1Sequence.getObjects();
            return enumeration;
        }
    }

    static boolean isCAdESData(byte[] byArray) throws IOException {
        Enumeration<?> enumeration = CAdESValidator.getCAdESObjects(byArray);
        ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
        if (!aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.data)) {
            return false;
        }
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
        try {
            new DEROctetString(aSN1TaggedObject.getObject());
        }
        catch (Exception exception) {
            LOGGER.fine("Los datos proporcionados no son de tipo Data: " + exception);
            return false;
        }
        return true;
    }

    public static boolean isCAdESSignedData(byte[] byArray, boolean bl) {
        try {
            Enumeration<?> enumeration = CAdESValidator.getCAdESObjects(byArray);
            ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
            if (!aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.signedData)) {
                LOGGER.fine("Los datos proporcionados no son de tipo SignedData de CAdES (no esta declarado el OID de SignedData)");
                return false;
            }
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1TaggedObject.getObject();
            SignedData signedData = SignedData.getInstance(aSN1Sequence);
            ASN1Set aSN1Set = signedData.getSignerInfos();
            if (bl) {
                for (int i = 0; i < aSN1Set.size(); ++i) {
                    if (CAdESValidator.verifySignerInfo(SignerInfo.getInstance(aSN1Set.getObjectAt(i)))) continue;
                    LOGGER.fine("Los datos proporcionados no son de tipo SignedData de CAdES (al menos un SignerInfo no se ha declarado de tipo CAdES)");
                    return false;
                }
            }
        }
        catch (Exception exception) {
            LOGGER.fine("Los datos proporcionados no son de tipo SignedData de CAdES: " + exception);
            return false;
        }
        return true;
    }

    private static boolean verifySignerInfo(SignerInfo signerInfo) {
        boolean bl = false;
        ASN1Set aSN1Set = signerInfo.getAuthenticatedAttributes();
        Enumeration enumeration = aSN1Set.getObjects();
        while (enumeration.hasMoreElements()) {
            ASN1Sequence aSN1Sequence = (ASN1Sequence)enumeration.nextElement();
            Attribute attribute = new Attribute((ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(0), (ASN1Set)aSN1Sequence.getObjectAt(1));
            if (!attribute.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signingCertificate) && !attribute.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signingCertificateV2)) continue;
            bl = true;
        }
        return bl;
    }

    static boolean isCAdESDigestedData(byte[] byArray) throws IOException {
        boolean bl = false;
        Enumeration<?> enumeration = CAdESValidator.getCAdESObjects(byArray);
        ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
        if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.digestedData)) {
            bl = true;
        }
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
        try {
            new DigestedData((ASN1Sequence)aSN1TaggedObject.getObject());
        }
        catch (Exception exception) {
            LOGGER.fine("Los datos proporcionados no son de tipo DigestedData: " + exception);
            return false;
        }
        return bl;
    }

    static boolean isCAdESEncryptedData(byte[] byArray) throws IOException {
        boolean bl = false;
        Enumeration<?> enumeration = CAdESValidator.getCAdESObjects(byArray);
        ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
        if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.encryptedData)) {
            bl = true;
        }
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1TaggedObject.getObject();
        try {
            ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0));
            EncryptedContentInfo.getInstance(aSN1Sequence.getObjectAt(1));
            if (aSN1Sequence.size() == 3) {
                aSN1Sequence.getObjectAt(2);
            }
        }
        catch (Exception exception) {
            LOGGER.fine("Los datos proporcionados no son de tipo EncryptedData: " + exception);
            return false;
        }
        return bl;
    }

    static boolean isCAdESEnvelopedData(byte[] byArray) throws IOException {
        boolean bl = false;
        Enumeration<?> enumeration = CAdESValidator.getCAdESObjects(byArray);
        ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
        if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.envelopedData)) {
            bl = true;
        }
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
        try {
            EnvelopedData.getInstance(aSN1TaggedObject.getObject());
        }
        catch (Exception exception) {
            LOGGER.fine("Los datos proporcionados no son de tipo EnvelopedData: " + exception);
            return false;
        }
        return bl;
    }

    static boolean isCAdESSignedAndEnvelopedData(byte[] byArray) throws IOException {
        SignedAndEnvelopedData signedAndEnvelopedData;
        boolean bl = false;
        Enumeration<?> enumeration = CAdESValidator.getCAdESObjects(byArray);
        ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
        if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.signedData)) {
            bl = true;
        }
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1TaggedObject.getObject();
        try {
            signedAndEnvelopedData = new SignedAndEnvelopedData(aSN1Sequence);
        }
        catch (Exception exception) {
            LOGGER.fine("Los datos proporcionados no son de tipo SignedAndEnvelopedData: " + exception);
            return false;
        }
        ASN1Set aSN1Set = signedAndEnvelopedData.getSignerInfos();
        for (int i = 0; i < aSN1Set.size(); ++i) {
            SignerInfo signerInfo = SignerInfo.getInstance(aSN1Set.getObjectAt(i));
            bl = CAdESValidator.verifySignerInfo(signerInfo);
        }
        return bl;
    }

    public static boolean isCAdESValid(byte[] byArray, String string, boolean bl) throws IOException {
        if (string.equals("Data")) {
            return CAdESValidator.isCAdESData(byArray);
        }
        if (string.equals("SignedData")) {
            return CAdESValidator.isCAdESSignedData(byArray, bl);
        }
        if (string.equals("DigestedData")) {
            return CAdESValidator.isCAdESDigestedData(byArray);
        }
        if (string.equals("EncryptedData")) {
            return CAdESValidator.isCAdESEncryptedData(byArray);
        }
        if (string.equals("EnvelopedData")) {
            return CAdESValidator.isCAdESEnvelopedData(byArray);
        }
        if (string.equals("SignedAndEnvelopedData")) {
            return CAdESValidator.isCAdESSignedAndEnvelopedData(byArray);
        }
        LOGGER.fine("Tipo de contenido CADES no reconocido");
        return false;
    }

    public static boolean isCAdESValid(byte[] byArray, boolean bl) throws IOException {
        if (byArray == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        boolean bl2 = CAdESValidator.isCAdESData(byArray);
        if (!bl2) {
            bl2 = CAdESValidator.isCAdESSignedData(byArray, bl);
        }
        if (!bl2) {
            bl2 = CAdESValidator.isCAdESDigestedData(byArray);
        }
        if (!bl2) {
            bl2 = CAdESValidator.isCAdESEncryptedData(byArray);
        }
        if (!bl2) {
            bl2 = CAdESValidator.isCAdESEnvelopedData(byArray);
        }
        if (!bl2) {
            bl2 = CAdESValidator.isCAdESSignedAndEnvelopedData(byArray);
        }
        return bl2;
    }
}

