/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cades;

import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AdESPolicy;
import es.gob.afirma.signers.cades.AOSigPolicyQualifierInfo;
import es.gob.afirma.signers.cades.CAdESSignerMetadata;
import es.gob.afirma.signers.cades.CAdESSignerMetadataHelper;
import es.gob.afirma.signers.cades.CommitmentTypeIndicationBean;
import es.gob.afirma.signers.cades.CommitmentTypeIndicationsHelper;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import es.gob.afirma.signers.pkcs7.SigUtils;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1OctetString;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.ASN1UTCTime;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.DERSequence;
import org.spongycastle.asn1.DERSet;
import org.spongycastle.asn1.DERTaggedObject;
import org.spongycastle.asn1.DERUTCTime;
import org.spongycastle.asn1.DERUTF8String;
import org.spongycastle.asn1.cms.Attribute;
import org.spongycastle.asn1.cms.CMSAttributes;
import org.spongycastle.asn1.ess.ContentHints;
import org.spongycastle.asn1.ess.ESSCertID;
import org.spongycastle.asn1.ess.ESSCertIDv2;
import org.spongycastle.asn1.ess.SigningCertificate;
import org.spongycastle.asn1.ess.SigningCertificateV2;
import org.spongycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.spongycastle.asn1.x500.X500Name;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.asn1.x509.CertificatePolicies;
import org.spongycastle.asn1.x509.DigestInfo;
import org.spongycastle.asn1.x509.GeneralName;
import org.spongycastle.asn1.x509.GeneralNames;
import org.spongycastle.asn1.x509.IssuerSerial;
import org.spongycastle.asn1.x509.PolicyInformation;
import org.spongycastle.asn1.x509.X509AttributeIdentifiers;

public final class CAdESUtils {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    private CAdESUtils() {
    }

    private static Attribute getSigningCertificateV2(X509Certificate x509Certificate, String string, boolean bl) throws CertificateEncodingException, NoSuchAlgorithmException {
        String string2 = AOAlgorithmID.getOID(string);
        AlgorithmIdentifier algorithmIdentifier = "2.16.840.1.101.3.4.2.1".equals(string2) ? null : SigUtils.makeAlgId(string2);
        GeneralNames generalNames = new GeneralNames(new GeneralName(X500Name.getInstance(x509Certificate.getIssuerX500Principal().getEncoded())));
        IssuerSerial issuerSerial = new IssuerSerial(generalNames, x509Certificate.getSerialNumber());
        byte[] byArray = MessageDigest.getInstance(string).digest(x509Certificate.getEncoded());
        ESSCertIDv2[] eSSCertIDv2Array = new ESSCertIDv2[]{new ESSCertIDv2(algorithmIdentifier, byArray, issuerSerial)};
        PolicyInformation[] policyInformationArray = bl ? null : CAdESUtils.getPolicyInformation(x509Certificate);
        SigningCertificateV2 signingCertificateV2 = policyInformationArray != null ? new SigningCertificateV2(eSSCertIDv2Array, policyInformationArray) : new SigningCertificateV2(eSSCertIDv2Array);
        return new Attribute(PKCSObjectIdentifiers.id_aa_signingCertificateV2, new DERSet(signingCertificateV2));
    }

    private static Attribute getSigningCertificateV1(X509Certificate x509Certificate, String string, boolean bl) throws CertificateEncodingException, NoSuchAlgorithmException {
        SigningCertificate signingCertificate;
        ASN1Encodable[] aSN1EncodableArray;
        GeneralName generalName = new GeneralName(X500Name.getInstance(x509Certificate.getIssuerX500Principal().getEncoded()));
        GeneralNames generalNames = new GeneralNames(generalName);
        IssuerSerial issuerSerial = new IssuerSerial(generalNames, x509Certificate.getSerialNumber());
        byte[] byArray = MessageDigest.getInstance(string).digest(x509Certificate.getEncoded());
        ESSCertID eSSCertID = new ESSCertID(byArray, issuerSerial);
        ASN1Encodable[] aSN1EncodableArray2 = aSN1EncodableArray = bl ? null : CAdESUtils.getPolicyInformation(x509Certificate);
        if (aSN1EncodableArray != null) {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            aSN1EncodableVector.add(new DERSequence(eSSCertID));
            aSN1EncodableVector.add(new DERSequence(aSN1EncodableArray));
            signingCertificate = SigningCertificate.getInstance(new DERSequence(aSN1EncodableVector));
        } else {
            signingCertificate = new SigningCertificate(eSSCertID);
        }
        return new Attribute(PKCSObjectIdentifiers.id_aa_signingCertificate, new DERSet(signingCertificate));
    }

    private static Attribute getSigPolicyId(String string, AdESPolicy adESPolicy) throws IOException {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier(adESPolicy.getPolicyIdentifier().toLowerCase(Locale.US).replace("urn:oid:", ""));
        AlgorithmIdentifier algorithmIdentifier = adESPolicy.getPolicyIdentifierHashAlgorithm() != null ? SigUtils.makeAlgId(AOAlgorithmID.getOID(AOSignConstants.getDigestAlgorithmName(adESPolicy.getPolicyIdentifierHashAlgorithm()))) : SigUtils.makeAlgId(AOAlgorithmID.getOID(string));
        byte[] byArray = adESPolicy.getPolicyIdentifierHash() != null ? Base64.decode(adESPolicy.getPolicyIdentifierHash()) : new byte[]{0};
        DigestInfo digestInfo = new DigestInfo(algorithmIdentifier, byArray);
        AOSigPolicyQualifierInfo aOSigPolicyQualifierInfo = null;
        if (adESPolicy.getPolicyQualifier() != null) {
            aOSigPolicyQualifierInfo = new AOSigPolicyQualifierInfo(adESPolicy.getPolicyQualifier().toString());
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(aSN1ObjectIdentifier);
        aSN1EncodableVector.add(digestInfo.toASN1Primitive());
        if (aOSigPolicyQualifierInfo != null) {
            aSN1EncodableVector.add(new DERSequence(aOSigPolicyQualifierInfo.toASN1Primitive()));
        }
        DERSequence dERSequence = new DERSequence(aSN1EncodableVector);
        return new Attribute(PKCSObjectIdentifiers.id_aa_ets_sigPolicyId, new DERSet(dERSequence.toASN1Primitive()));
    }

    public static ASN1EncodableVector generateSignerInfo(Certificate certificate, String string, byte[] byArray, AdESPolicy adESPolicy, boolean bl, byte[] byArray2, Date date, boolean bl2, boolean bl3, String string2, String string3, List<CommitmentTypeIndicationBean> list, String[] stringArray, CAdESSignerMetadata cAdESSignerMetadata, boolean bl4, boolean bl5) throws NoSuchAlgorithmException, IOException, CertificateEncodingException {
        Object object;
        if (bl3) {
            LOGGER.info("Se ha seleccionado la generacion de CAdES para inclusion en PAdES");
        }
        if (bl2) {
            LOGGER.info("Se incluira el atributo SigningTime (OID:1.2.840.113549.1.9.5) en la firma CAdES");
        }
        ASN1EncodableVector aSN1EncodableVector = CAdESUtils.initContextSpecific(string, byArray, byArray2, date, bl4, bl3);
        if (bl) {
            aSN1EncodableVector.add(CAdESUtils.getSigningCertificateV2((X509Certificate)certificate, string, bl5));
        } else {
            aSN1EncodableVector.add(CAdESUtils.getSigningCertificateV1((X509Certificate)certificate, string, bl5));
        }
        if (adESPolicy != null && adESPolicy.getPolicyIdentifier() != null) {
            aSN1EncodableVector.add(CAdESUtils.getSigPolicyId(string, adESPolicy));
        }
        if (string2 != null && !bl3) {
            object = string3 != null ? new ContentHints(new ASN1ObjectIdentifier(string2), new DERUTF8String(string3)) : new ContentHints(new ASN1ObjectIdentifier(string2));
            aSN1EncodableVector.add(new Attribute(PKCSObjectIdentifiers.id_aa_contentHint, new DERSet(((ContentHints)object).toASN1Primitive())));
        }
        if (list != null && list.size() > 0) {
            for (CommitmentTypeIndicationBean object2 : list) {
                aSN1EncodableVector.add(new Attribute(PKCSObjectIdentifiers.id_aa_ets_commitmentType, new DERSet(CommitmentTypeIndicationsHelper.generateCommitmentTypeIndication(object2).toASN1Primitive())));
            }
        }
        if (!bl3 && cAdESSignerMetadata != null && CAdESSignerMetadataHelper.getSignerLocation(cAdESSignerMetadata.getSignerLocation()) != null) {
            aSN1EncodableVector.add(new Attribute(PKCSObjectIdentifiers.id_aa_ets_signerLocation, new DERSet(CAdESSignerMetadataHelper.getSignerLocation(cAdESSignerMetadata.getSignerLocation()))));
        }
        if (stringArray != null && stringArray.length > 0) {
            object = new ArrayList();
            for (String string4 : stringArray) {
                if (string4 == null || string4.isEmpty()) continue;
                object.add(new Attribute(X509AttributeIdentifiers.id_at_role, new DERSet(new DERUTF8String(string4))));
            }
            if (!object.isEmpty()) {
                ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Attribute attribute = (Attribute)iterator.next();
                    aSN1EncodableVector2.add(attribute);
                }
                aSN1EncodableVector.add(new Attribute(PKCSObjectIdentifiers.id_aa_ets_signerAttr, new DERSet(new DERSequence(new DERTaggedObject(0, new DERSequence(aSN1EncodableVector2))))));
            }
        }
        if (bl2) {
            aSN1EncodableVector.add(new Attribute(PKCSObjectIdentifiers.pkcs_9_at_signingTime, new DERSet(new DERUTCTime(date))));
        }
        return aSN1EncodableVector;
    }

    private static PolicyInformation[] getPolicyInformation(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            throw new IllegalArgumentException("El certificado no puede ser nulo");
        }
        byte[] byArray = x509Certificate.getExtensionValue("2.5.29.32");
        if (byArray == null || byArray.length < 1) {
            return null;
        }
        return CertificatePolicies.getInstance(ASN1Sequence.getInstance(ASN1OctetString.getInstance(byArray).getOctets())).getPolicyInformation();
    }

    private static ASN1EncodableVector initContextSpecific(String string, byte[] byArray, byte[] byArray2, Date date, boolean bl, boolean bl2) throws NoSuchAlgorithmException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (!bl) {
            aSN1EncodableVector.add(new Attribute(CMSAttributes.contentType, new DERSet(PKCSObjectIdentifiers.data)));
        }
        if (!bl2) {
            aSN1EncodableVector.add(new Attribute(CMSAttributes.signingTime, new DERSet(new ASN1UTCTime(date))));
        }
        aSN1EncodableVector.add(new Attribute(CMSAttributes.messageDigest, new DERSet(new DEROctetString(byArray2 != null ? byArray2 : MessageDigest.getInstance(string).digest(byArray)))));
        return aSN1EncodableVector;
    }
}

