/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cades;

import es.gob.afirma.signers.cades.CAdESSignerMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.DERSequence;
import org.spongycastle.asn1.DERUTF8String;
import org.spongycastle.asn1.esf.SignerLocation;

public final class CAdESSignerMetadataHelper {
    private CAdESSignerMetadataHelper() {
    }

    public static CAdESSignerMetadata getCAdESSignerMetadata(Properties properties) {
        if (properties == null) {
            return null;
        }
        String string = properties.getProperty("signatureProductionPostalCode");
        List<String> list = string == null ? null : Arrays.asList(string.split("\n"));
        String string2 = properties.getProperty("signatureProductionCountry");
        String string3 = properties.getProperty("signatureProductionCity");
        if (list != null || string2 != null || string3 != null) {
            return new CAdESSignerMetadata(string2, string3, list);
        }
        return null;
    }

    public static SignerLocation getSignerLocation(CAdESSignerMetadata.CAdESSignerLocation cAdESSignerLocation) {
        if (cAdESSignerLocation == null) {
            return null;
        }
        if (cAdESSignerLocation.getCountryName() == null && cAdESSignerLocation.getLocalityName() == null && cAdESSignerLocation.getPostalAddress() == null) {
            return null;
        }
        List<String> list = cAdESSignerLocation.getPostalAddress();
        ArrayList<DERUTF8String> arrayList = null;
        if (list != null) {
            arrayList = new ArrayList<DERUTF8String>(list.size());
            for (String string : list) {
                arrayList.add(new DERUTF8String(string));
            }
        }
        return new SignerLocation(cAdESSignerLocation.getCountryName() != null ? new DERUTF8String(cAdESSignerLocation.getCountryName()) : null, cAdESSignerLocation.getLocalityName() != null ? new DERUTF8String(cAdESSignerLocation.getLocalityName()) : null, arrayList != null ? new DERSequence(arrayList.toArray(new ASN1Encodable[0])) : null);
    }
}

