/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cades;

import java.util.List;

public final class CAdESSignerMetadata {
    private final CAdESSignerLocation signerLocation;
    private static final int POSTAL_ADDRESS_MAX_LINES = 6;

    public CAdESSignerMetadata(String string, String string2, List<String> list) {
        this.signerLocation = new CAdESSignerLocation(string, string2, list);
    }

    public CAdESSignerLocation getSignerLocation() {
        return this.signerLocation;
    }

    public static final class CAdESSignerLocation {
        private final String countryName;
        private final String localityName;
        private final List<String> postalAddress;

        CAdESSignerLocation(String string, String string2, List<String> list) {
            if (list != null && list.size() > 6) {
                throw new IllegalArgumentException("La direccion postal debe tener un maximo de seis lineas, y se han proporcionado " + list.size());
            }
            this.countryName = string;
            this.localityName = string2;
            this.postalAddress = list;
        }

        public String getCountryName() {
            return this.countryName;
        }

        public String getLocalityName() {
            return this.localityName;
        }

        public List<String> getPostalAddress() {
            return this.postalAddress;
        }
    }
}

