/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cades;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.AOException;
import es.gob.afirma.core.AOInvalidFormatException;
import es.gob.afirma.core.misc.MimeHelper;
import es.gob.afirma.core.signers.AOCoSigner;
import es.gob.afirma.core.signers.AOCounterSigner;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AOSignInfo;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.AdESPolicy;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.core.util.tree.AOTreeModel;
import es.gob.afirma.signers.cades.CAdESSignerMetadataHelper;
import es.gob.afirma.signers.cades.CAdESValidator;
import es.gob.afirma.signers.cades.CommitmentTypeIndicationsHelper;
import es.gob.afirma.signers.cades.GenCAdESEPESSignedData;
import es.gob.afirma.signers.pkcs7.ObtainContentSignedData;
import es.gob.afirma.signers.pkcs7.P7ContentSignerParameters;
import es.gob.afirma.signers.pkcs7.ReadNodesTree;
import es.gob.afirma.signers.pkcs7.SCChecker;
import es.gob.afirma.signers.tsp.pkcs7.CMSTimestamper;
import es.gob.afirma.signers.tsp.pkcs7.TsaParams;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public final class AOCAdESSigner
implements AOSigner {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    @Override
    public byte[] sign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        byte[] byArray2;
        Object object;
        byte[] byArray3;
        String string2;
        boolean bl;
        Properties properties2;
        if (certificateArray == null || certificateArray.length < 1) {
            throw new IllegalArgumentException("La cadena de certificados debe contener al menos un elemento");
        }
        AOCAdESSigner.checkAlgorithm(string);
        new SCChecker().checkSpongyCastle();
        Properties properties3 = properties2 = properties != null ? properties : new Properties();
        if (AOSignConstants.isSHA2SignatureAlgorithm(string)) {
            bl = true;
            if (properties2.containsKey("signingCertificateV2")) {
                LOGGER.warning("Se ignorara la propiedad 'signingCertificateV2' porque las firmas SHA2 siempre usan SigningCertificateV2");
            }
        } else {
            bl = properties2.containsKey("signingCertificateV2") ? Boolean.parseBoolean(properties2.getProperty("signingCertificateV2")) : !"SHA1".equals(AOSignConstants.getDigestAlgorithmName(string));
        }
        String string3 = properties2.getProperty("precalculatedHashAlgorithm");
        String string4 = properties2.getProperty("mode", "explicit");
        if (string3 != null && properties2.containsKey("mode")) {
            LOGGER.warning("Se ignorara el parametro 'mode' por haberse proporcionado tambien el parametro 'precalculatedHashAlgorithm'. La firma sera explicita.");
        }
        boolean bl2 = false;
        if ("explicit".equalsIgnoreCase(string4) || string3 != null) {
            bl2 = true;
        }
        String string5 = properties2.getProperty("contentTypeOid");
        String string6 = properties2.getProperty("contentDescription");
        boolean bl3 = Boolean.parseBoolean(properties2.getProperty("doNotIncludePolicyOnSigningCertificate", Boolean.FALSE.toString()));
        String[] stringArray = null;
        String string7 = properties2.getProperty("signerClaimedRoles");
        System.out.println("Parametro signatureClaimedRoles: " + string7);
        if (string7 != null && !string7.isEmpty()) {
            stringArray = string7.split(Pattern.quote("|"));
            System.out.println("Numero de parametros: " + stringArray.length);
        }
        if (string3 != null) {
            string2 = AOSignConstants.getDigestAlgorithmName(string3);
            byArray3 = byArray;
        } else {
            string2 = AOSignConstants.getDigestAlgorithmName(string);
            try {
                byArray3 = MessageDigest.getInstance(AOSignConstants.getDigestAlgorithmName(string)).digest(byArray);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new AOException("Algoritmo no soportado: " + noSuchAlgorithmException, noSuchAlgorithmException);
            }
        }
        String string8 = "1.2.840.113549.1.7.1";
        String string9 = "binary";
        try {
            Certificate[] certificateArray2;
            if (byArray != null && (string5 == null || string6 == null)) {
                try {
                    object = new MimeHelper(byArray);
                    string8 = MimeHelper.transformMimeTypeToOid(((MimeHelper)object).getMimeType());
                    string9 = ((MimeHelper)object).getDescription();
                }
                catch (Exception exception) {
                    LOGGER.warning("No se han podido cargar las librerias para identificar el tipo de dato firmado: " + exception);
                }
            }
            P7ContentSignerParameters p7ContentSignerParameters = new P7ContentSignerParameters(string3 != null ? null : byArray, string);
            AdESPolicy adESPolicy = AdESPolicy.buildAdESPolicy(properties2);
            if (Boolean.parseBoolean(properties2.getProperty("includeOnlySignningCertificate", Boolean.FALSE.toString()))) {
                X509Certificate[] x509CertificateArray = new X509Certificate[1];
                certificateArray2 = x509CertificateArray;
                x509CertificateArray[0] = (X509Certificate)certificateArray[0];
            } else {
                certificateArray2 = certificateArray;
            }
            byArray2 = GenCAdESEPESSignedData.generateSignedData(p7ContentSignerParameters, bl2, adESPolicy, bl, privateKey, certificateArray2, byArray3, string2, Boolean.parseBoolean(properties2.getProperty("includeSigningTimeAttribute", Boolean.FALSE.toString())), Boolean.parseBoolean(properties2.getProperty("padesMode", Boolean.FALSE.toString())), string5 != null ? string5 : string8, string6 != null ? string6 : string9, CommitmentTypeIndicationsHelper.getCommitmentTypeIndications(properties2), stringArray, CAdESSignerMetadataHelper.getCAdESSignerMetadata(properties2), bl3);
        }
        catch (Exception exception) {
            if ("es.gob.jmulticard.CancelledOperationException".equals(exception.getClass().getName())) {
                throw new AOCancelledOperationException();
            }
            throw new AOException("Error generando la firma CAdES: " + exception, exception);
        }
        try {
            object = new TsaParams(properties2);
        }
        catch (Exception exception) {
            object = null;
        }
        if (object != null) {
            try {
                return new CMSTimestamper((TsaParams)object).addTimestamp(byArray2, ((TsaParams)object).getTsaHashAlgorithm(), new GregorianCalendar());
            }
            catch (Exception exception) {
                LOGGER.severe("No se ha podido aplicar el sello de tiempo: " + exception);
            }
        }
        return byArray2;
    }

    @Override
    public byte[] cosign(byte[] byArray, byte[] byArray2, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        AOCAdESSigner.checkAlgorithm(string);
        new SCChecker().checkSpongyCastle();
        try {
            return ((AOCoSigner)Class.forName("es.gob.afirma.signers.multi.cades.AOCAdESCoSigner").getConstructor(new Class[0]).newInstance(new Object[0])).cosign(byArray, byArray2, string, privateKey, certificateArray, properties);
        }
        catch (InstantiationException instantiationException) {
            throw new AOException("No se ha podido instanciar la clase de cofirmas CAdES: " + instantiationException, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AOException("No se ha podido instanciar la clase de cofirmas CAdES por acceso ilegal: " + illegalAccessException, illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AOException("No se ha encontrado la clase de cofirmas CAdES: " + classNotFoundException, classNotFoundException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AOException("No se ha podido instanciar la clase de cofirmas CAdES: " + illegalArgumentException, illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AOException("No se ha podido instanciar la clase de cofirmas CAdES por error en la invocacion al constructor: " + invocationTargetException, invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AOException("No se ha podido instanciar la clase de cofirmas CAdES por falta de un constructor por defecto sin parametros: " + noSuchMethodException, noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new AOException("No se ha podido instanciar la clase de cofirmas CAdES por falta de permisos: " + securityException, securityException);
        }
    }

    @Override
    public byte[] cosign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        AOCAdESSigner.checkAlgorithm(string);
        new SCChecker().checkSpongyCastle();
        try {
            return ((AOCoSigner)Class.forName("es.gob.afirma.signers.multi.cades.AOCAdESCoSigner").getConstructor(new Class[0]).newInstance(new Object[0])).cosign(byArray, string, privateKey, certificateArray, properties);
        }
        catch (IOException iOException) {
            throw new AOException("Error en tratamiento de datos para la cofirma: " + iOException, iOException);
        }
        catch (InstantiationException instantiationException) {
            throw new AOException("No se ha podido instanciar el cofirmador: " + instantiationException, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AOException("No tienen permisos para instanciar el cofirmador: " + illegalAccessException, illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AOException("No se ha encontrado el cofirmador: " + classNotFoundException, classNotFoundException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AOException("No se ha podido instanciar el cofirmador: " + illegalArgumentException, illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AOException("No se ha podido instanciar el cofirmador: " + invocationTargetException, invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AOException("No se ha podido instanciar el cofirmador por falta de un constructor por defecto sin parametros: " + noSuchMethodException, noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new AOException("No se ha podido instanciar el cofirmador por motivos de seguridad: " + securityException, securityException);
        }
    }

    @Override
    public byte[] countersign(byte[] byArray, String string, CounterSignTarget counterSignTarget, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        AOCAdESSigner.checkAlgorithm(string);
        new SCChecker().checkSpongyCastle();
        try {
            return ((AOCounterSigner)Class.forName("es.gob.afirma.signers.multi.cades.AOCAdESCounterSigner").getConstructor(new Class[0]).newInstance(new Object[0])).countersign(byArray, string, counterSignTarget, objectArray, privateKey, certificateArray, properties);
        }
        catch (IOException iOException) {
            throw new AOException("Error en el tratamiemto de datos durante la contrafirma: " + iOException, iOException);
        }
        catch (InstantiationException instantiationException) {
            throw new AOException("Error al instanciar el contrafirmador: " + instantiationException, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AOException("No ha permisos para invocar al contrafirmador: " + illegalAccessException, illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AOException("No se ha encontrado el contrafirmador: " + classNotFoundException, classNotFoundException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AOException("No se ha podido instanciar el contrafirmador: " + illegalArgumentException, illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AOException("No se ha podido instanciar el contrafirmador: " + invocationTargetException, invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AOException("No se ha podido instanciar el contrafirmador por falta de un constructor por defecto sin parametros: " + noSuchMethodException, noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new AOException("No se ha podido instanciar el contrafirmador por motivos de seguridad: " + securityException, securityException);
        }
    }

    @Override
    public AOTreeModel getSignersStructure(byte[] byArray, boolean bl) throws AOInvalidFormatException, IOException {
        new SCChecker().checkSpongyCastle();
        if (!CAdESValidator.isCAdESValid(byArray, false)) {
            throw new AOInvalidFormatException("Los datos introducidos no se corresponden con un objeto de firma CAdES");
        }
        try {
            return new ReadNodesTree().readNodesTree(byArray, bl);
        }
        catch (Exception exception) {
            LOGGER.severe("No se ha podido obtener el arbol de firmantes de la firma, se devolvera null: " + exception);
            return null;
        }
    }

    @Override
    public boolean isSign(byte[] byArray) {
        if (byArray == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        new SCChecker().checkSpongyCastle();
        return CAdESValidator.isCAdESSignedData(byArray, true);
    }

    @Override
    public boolean isValidDataFile(byte[] byArray) {
        if (byArray == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        return true;
    }

    @Override
    public byte[] getData(byte[] byArray) throws AOInvalidFormatException, IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("Se han introducido datos nulos para su comprobacion");
        }
        new SCChecker().checkSpongyCastle();
        if (!CAdESValidator.isCAdESValid(byArray, false)) {
            throw new AOInvalidFormatException("Los datos introducidos no se corresponden con un objeto de firma");
        }
        return ObtainContentSignedData.obtainData(byArray);
    }

    @Override
    public String getSignedName(String string, String string2) {
        return string + (string2 != null ? string2 : "") + ".csig";
    }

    @Override
    public AOSignInfo getSignInfo(byte[] byArray) throws AOInvalidFormatException {
        if (byArray == null) {
            throw new IllegalArgumentException("No se han introducido datos para analizar");
        }
        if (!this.isSign(byArray)) {
            throw new AOInvalidFormatException("Los datos introducidos no se corresponden con un objeto de firma");
        }
        return new AOSignInfo("CAdES");
    }

    private static void checkAlgorithm(String string) throws AOException {
        if (string == null) {
            throw new IllegalArgumentException("El algoritmo de firma no puede ser nulo");
        }
        if (string.toUpperCase(Locale.US).startsWith("MD")) {
            throw new AOException("CAdES no permite huellas digitales MD2 o MD5 (Decision 130/2011 CE)");
        }
    }
}

