/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.batch.client;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.misc.http.HttpError;
import es.gob.afirma.core.misc.http.UrlHttpManagerFactory;
import es.gob.afirma.core.misc.http.UrlHttpMethod;
import es.gob.afirma.core.signers.AOPkcs1Signer;
import es.gob.afirma.core.signers.TriphaseData;
import es.gob.afirma.core.signers.TriphaseDataSigner;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class BatchSigner {
    private static final String BATCH_XML_PARAM = "xml";
    private static final String BATCH_CRT_PARAM = "certs";
    private static final String BATCH_TRI_PARAM = "tridata";
    private static final String EQU = "=";
    private static final String AMP = "&";
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    private BatchSigner() {
    }

    public static String sign(String string, String string2, String string3, Certificate[] certificateArray, PrivateKey privateKey) throws CertificateEncodingException, IOException, AOException {
        byte[] byArray;
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("El lote de firma no puede ser nulo ni vacio");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("La URL de preproceso de lotes no puede se nula ni vacia");
        }
        if (string3 == null || string3.isEmpty()) {
            throw new IllegalArgumentException("La URL de postproceso de lotes no puede ser nula ni vacia");
        }
        if (certificateArray == null || certificateArray.length < 1) {
            throw new IllegalArgumentException("La cadena de certificados del firmante no puede ser nula ni vacia");
        }
        String string4 = string.replace("+", "-").replace("/", "_");
        try {
            byArray = UrlHttpManagerFactory.getInstalledManager().readUrl(string2 + "?" + BATCH_XML_PARAM + EQU + string4 + AMP + BATCH_CRT_PARAM + EQU + BatchSigner.getCertChainAsBase64(certificateArray), UrlHttpMethod.POST);
        }
        catch (HttpError httpError) {
            LOGGER.warning("El servicio de firma devolvio un  error durante la prefirma: " + httpError.getResponseDescription());
            throw httpError;
        }
        TriphaseData triphaseData = TriphaseData.parser(byArray);
        TriphaseData triphaseData2 = TriphaseDataSigner.doSign(new AOPkcs1Signer(), BatchSigner.getAlgorithm(string), privateKey, certificateArray, triphaseData);
        try {
            byArray = UrlHttpManagerFactory.getInstalledManager().readUrl(string3 + "?" + BATCH_XML_PARAM + EQU + string4 + AMP + BATCH_CRT_PARAM + EQU + BatchSigner.getCertChainAsBase64(certificateArray) + AMP + BATCH_TRI_PARAM + EQU + Base64.encode(triphaseData2.toString().getBytes(), true), UrlHttpMethod.POST);
        }
        catch (HttpError httpError) {
            LOGGER.warning("El servicio de firma devolvio un  error durante la postfirma: " + httpError.getResponseDescription());
            throw httpError;
        }
        return new String(byArray);
    }

    private static String getCertChainAsBase64(Certificate[] certificateArray) throws CertificateEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        for (Certificate certificate : certificateArray) {
            stringBuilder.append(Base64.encode(certificate.getEncoded(), true));
            stringBuilder.append(";");
        }
        String string = stringBuilder.toString();
        return string.substring(0, string.length() - 1);
    }

    private static String getAlgorithm(String string) throws IOException {
        Document document;
        Object object;
        Object object2;
        byte[] byArray = Base64.decode(string.replace("-", "+").replace("_", "/"));
        try {
            object2 = new ByteArrayInputStream(byArray);
            object = null;
            try {
                document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse((InputStream)object2);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object != null) {
                        try {
                            ((InputStream)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)object2).close();
                    }
                }
            }
        }
        catch (Exception exception) {
            LOGGER.severe("Error al cargar el fichero XML de lote: " + exception + "\n" + new String(byArray));
            throw new IOException("Error al cargar el fichero XML de lote: " + exception, exception);
        }
        object2 = document.getDocumentElement();
        if (!"signbatch".equalsIgnoreCase(object2.getNodeName())) {
            throw new IllegalArgumentException("No se encontro el nodo 'signbatch' en el XML proporcionado");
        }
        object = object2.getAttributes();
        if (object != null) {
            Node node = object.getNamedItem("algorithm");
            if (node != null) {
                return node.getNodeValue();
            }
            throw new IllegalArgumentException("El nodo 'signbatch' debe contener al manos el atributo de algoritmo");
        }
        throw new IllegalArgumentException("El nodo 'signbatch' debe contener al manos el atributo de algoritmo");
    }
}

