/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.miniapplet;

import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.AOSignerFactory;
import es.gob.afirma.miniapplet.DataAnalizerUtil;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Logger;

final class SelectSignerAction
implements PrivilegedExceptionAction<AOSigner> {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private final String format;
    private final byte[] data;

    SelectSignerAction(String string) {
        this.format = string;
        this.data = null;
    }

    SelectSignerAction(byte[] byArray) {
        this.data = byArray != null ? (byte[])byArray.clone() : null;
        this.format = null;
    }

    SelectSignerAction(String string, byte[] byArray) {
        this.format = string;
        this.data = byArray;
    }

    @Override
    public AOSigner run() throws IOException {
        AOSigner aOSigner = null;
        if (this.format != null) {
            if (!"auto".equalsIgnoreCase(this.format)) {
                LOGGER.info("Seleccionamos el signer correspondiente al formato " + this.format);
                aOSigner = AOSignerFactory.getSigner(this.format);
            } else if (this.data != null) {
                LOGGER.info("Seleccion automatica de formato");
                if (DataAnalizerUtil.isPDF(this.data)) {
                    LOGGER.info("Se selecciona el formato PAdES");
                    aOSigner = AOSignerFactory.getSigner("PAdES");
                } else if (DataAnalizerUtil.isFacturae(this.data)) {
                    LOGGER.info("Se selecciona el formato FacturaE");
                    aOSigner = AOSignerFactory.getSigner("FacturaE");
                } else if (DataAnalizerUtil.isXML(this.data)) {
                    LOGGER.info("Se selecciona el formato XAdES");
                    aOSigner = AOSignerFactory.getSigner("XAdES");
                } else if (DataAnalizerUtil.isODF(this.data)) {
                    LOGGER.info("Se selecciona el formato ODF (Open Document Format)");
                    aOSigner = AOSignerFactory.getSigner("ODF (Open Document Format)");
                } else if (DataAnalizerUtil.isOOXML(this.data)) {
                    LOGGER.info("Se selecciona el formato OOXML (Office Open XML)");
                    aOSigner = AOSignerFactory.getSigner("OOXML (Office Open XML)");
                } else {
                    LOGGER.info("Se selecciona el formato CAdES");
                    aOSigner = AOSignerFactory.getSigner("CAdES");
                }
            } else {
                LOGGER.warning("No se han indicado datos a partir de los cuales determinar el formato");
            }
        } else if (this.data != null) {
            aOSigner = AOSignerFactory.getSigner(this.data);
        }
        return aOSigner;
    }
}

