/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.miniapplet;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.keystores.AOKeyStore;
import es.gob.afirma.keystores.AOKeyStoreDialog;
import es.gob.afirma.keystores.AOKeyStoreManager;
import es.gob.afirma.keystores.AOKeyStoreManagerFactory;
import es.gob.afirma.keystores.AOKeystoreAlternativeException;
import es.gob.afirma.keystores.AggregatedKeyStoreManager;
import es.gob.afirma.keystores.filters.CertFilterManager;
import es.gob.afirma.keystores.filters.CertificateFilter;
import java.awt.Component;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedExceptionAction;
import java.security.UnrecoverableEntryException;
import java.util.List;

final class SelectPrivateKeyAction
implements PrivilegedExceptionAction<KeyStore.PrivateKeyEntry> {
    private final AOKeyStore keyStore;
    private final Component parent;
    private final CertFilterManager filterManager;
    private String library = null;

    SelectPrivateKeyAction(AOKeyStore aOKeyStore, String string, CertFilterManager certFilterManager, Component component) {
        if (aOKeyStore == null) {
            throw new IllegalArgumentException("El tipo de almacen no puede ser nulo");
        }
        this.keyStore = aOKeyStore;
        this.filterManager = certFilterManager;
        this.parent = component;
        this.library = string;
    }

    SelectPrivateKeyAction(Platform.OS oS, Platform.BROWSER bROWSER, CertFilterManager certFilterManager, Component component) {
        this.keyStore = bROWSER == Platform.BROWSER.FIREFOX ? AOKeyStore.MOZ_UNI : (oS == Platform.OS.WINDOWS ? AOKeyStore.WINDOWS : (oS == Platform.OS.LINUX ? AOKeyStore.SHARED_NSS : (oS == Platform.OS.SOLARIS ? AOKeyStore.MOZ_UNI : (oS == Platform.OS.MACOSX ? AOKeyStore.APPLE : AOKeyStore.PKCS12))));
        this.filterManager = certFilterManager;
        this.parent = component;
    }

    @Override
    public KeyStore.PrivateKeyEntry run() throws AOKeystoreAlternativeException, AOException, UnrecoverableEntryException, NoSuchAlgorithmException, KeyStoreException, IOException {
        AggregatedKeyStoreManager aggregatedKeyStoreManager = AOKeyStoreManagerFactory.getAOKeyStoreManager(this.keyStore, this.library, null, this.keyStore.getStorePasswordCallback(this.parent), this.parent);
        boolean bl = false;
        List<CertificateFilter> list = null;
        if (this.filterManager != null) {
            list = this.filterManager.getFilters();
            bl = this.filterManager.isMandatoryCertificate();
        }
        AOKeyStoreDialog aOKeyStoreDialog = new AOKeyStoreDialog(aggregatedKeyStoreManager, this, true, true, true, list, bl);
        aOKeyStoreDialog.allowOpenExternalStores(this.filterManager.isExternalStoresOpeningAllowed());
        aOKeyStoreDialog.show();
        aggregatedKeyStoreManager.setParentComponent(this.parent);
        return ((AOKeyStoreManager)aggregatedKeyStoreManager).getKeyEntry(aOKeyStoreDialog.getSelectedAlias());
    }
}

