/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.miniapplet;

import com.dmurph.tracking.AnalyticsConfigData;
import com.dmurph.tracking.JGoogleAnalyticsTracker;
import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.AOException;
import es.gob.afirma.core.AOFormatFileException;
import es.gob.afirma.core.LogManager;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.AOSignerFactory;
import es.gob.afirma.core.signers.ExtraParamsProcessor;
import es.gob.afirma.keystores.AOKeyStore;
import es.gob.afirma.keystores.SmartCardException;
import es.gob.afirma.keystores.filters.CertFilterManager;
import es.gob.afirma.miniapplet.CoSignAction;
import es.gob.afirma.miniapplet.CounterSignAction;
import es.gob.afirma.miniapplet.GetCurrentLogAction;
import es.gob.afirma.miniapplet.GetFileContentAction;
import es.gob.afirma.miniapplet.GetFileNameContentAction;
import es.gob.afirma.miniapplet.GetPropertyAction;
import es.gob.afirma.miniapplet.MiniAfirma;
import es.gob.afirma.miniapplet.MiniAppletMessages;
import es.gob.afirma.miniapplet.SaveFileAction;
import es.gob.afirma.miniapplet.SelectPrivateKeyAction;
import es.gob.afirma.miniapplet.SelectSignerAction;
import es.gob.afirma.miniapplet.SignAction;
import es.gob.afirma.signers.batch.client.BatchSigner;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertificateEncodingException;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.logging.Logger;
import javax.swing.JApplet;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.mozilla.universalchardet.UniversalDetector;

public final class MiniAfirmaApplet
extends JApplet
implements MiniAfirma {
    private static final long serialVersionUID = -4364574240099120486L;
    static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String GOOGLE_ANALYTICS_TRACKING_CODE = "UA-41615516-2";
    private static final String EOF = "%%EOF%%";
    private static final String DEFAULT_CHUNK_ENCODING = "ISO-8859-1";
    private static final String APPLET_PARAM_USER_AGENT = "userAgent";
    private static final String APPLET_PARAM_SYSTEM_PROPERTIES = "system_properties";
    private static final String APPLET_PARAM_LOCALE = "locale";
    private static final String APPLET_PARAM_USER_KEYSTORE = "keystore";
    private static final String SIGNATURE_FORMAT_AUTO = "AUTO";
    private static final String CRYPTO_OPERATION_SIGN = "sign";
    private static final String CRYPTO_OPERATION_COSIGN = "cosign";
    private static final String CRYPTO_OPERATION_COUNTERSIGN = "countersign";
    private static final int BUFFER_SIZE = 0x100000;
    private final StringBuilder dataStore = new StringBuilder();
    private InputStream chunkedReturnStream;
    private KeyStore.PrivateKeyEntry stickyKeyEntry = null;
    private boolean stickySignatory = false;
    private String userAgent = null;
    private AOKeyStore keystoreType = null;
    private String keystoreLib = null;
    private String errorMessage = null;
    private String errorType = null;

    @Override
    public void setStickySignatory(boolean bl) {
        this.stickySignatory = bl;
        if (!bl) {
            this.stickyKeyEntry = null;
        }
    }

    @Override
    public String sign(String string, String string2, String string3) throws PrivilegedActionException, IOException, AOException, CertificateEncodingException, ExtraParamsProcessor.IncompatiblePolicyException {
        byte[] byArray;
        LOGGER.info("Solicitada firma con algoritmo " + string + " y formato " + string2);
        this.clearError();
        Properties properties = ExtraParamsProcessor.convertToProperties(string3);
        if (this.dataStore.length() > 0) {
            try {
                byArray = Base64.decode(this.dataStore.toString());
            }
            catch (Exception exception) {
                this.setError(exception, "Los datos proporcionados est\u00e1n mal codificados en base 64");
                throw exception;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.setError(outOfMemoryError, "Error de falta de memoria durante la carga de los datos");
                throw outOfMemoryError;
            }
            finally {
                this.dataStore.setLength(0);
            }
        }
        Object object = properties.getProperty("filenameExts", null);
        Object object2 = object == null ? MiniAppletMessages.getString("MiniAfirmaApplet.1") : String.format(MiniAppletMessages.getString("MiniAfirmaApplet.6"), ((String)object).replace(",", ",*."));
        try {
            byArray = AccessController.doPrivileged(new GetFileContentAction(MiniAppletMessages.getString("MiniAfirmaApplet.0"), object != null ? ((String)object).split(",") : null, (String)object2, this));
        }
        catch (AOCancelledOperationException aOCancelledOperationException) {
            this.setError(aOCancelledOperationException);
            throw aOCancelledOperationException;
        }
        catch (CancellationException cancellationException) {
            AOCancelledOperationException aOCancelledOperationException = new AOCancelledOperationException("Operacion cancelada por el usuario", cancellationException);
            this.setError(aOCancelledOperationException);
            throw aOCancelledOperationException;
        }
        catch (Exception exception) {
            this.setError(exception);
            throw exception;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.setError(outOfMemoryError, "Error de falta de memoria durante la carga del fichero de datos");
            throw outOfMemoryError;
        }
        catch (Error error) {
            this.setError(error);
            throw error;
        }
        object = new ByteArrayOutputStream();
        object2 = new PrintStream((OutputStream)object);
        properties.list((PrintStream)object2);
        LOGGER.info("Recibidos los siguientes parametros adicionales:\n" + ((ByteArrayOutputStream)object).toString());
        try {
            String string4 = MiniAfirmaApplet.cleanParam(string2);
            AOSigner aOSigner = MiniAfirmaApplet.selectSigner(string4, byArray, null);
            if (SIGNATURE_FORMAT_AUTO.equalsIgnoreCase(string4)) {
                string4 = AOSignerFactory.getSignFormat(aOSigner);
                ExtraParamsProcessor.configAutoFormat(aOSigner, byArray, properties);
            }
            if (MiniAfirmaApplet.isXadesEnvelopedExplicit(string4, properties)) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("El formato Enveloped es incompatible con el modo de firma explicito");
                this.setError(illegalArgumentException);
                throw illegalArgumentException;
            }
            if (MiniAfirmaApplet.isXadesExplicitConfigurated(string4, properties)) {
                LOGGER.warning("Se ha pedido una firma XAdES explicita, este formato dejara de soportarse en proximas versiones");
                try {
                    byArray = MessageDigest.getInstance("SHA1").digest(byArray);
                    properties.setProperty("mimeType", "hash/sha1");
                }
                catch (Exception exception) {
                    LOGGER.warning("Error al generar la huella digital de los datos para firmar como 'XAdES explicit', se realizara una firma XAdES corriente: " + exception);
                }
            }
            KeyStore.PrivateKeyEntry privateKeyEntry = this.selectPrivateKey(properties);
            byte[] byArray2 = AccessController.doPrivileged(new SignAction(aOSigner, byArray, MiniAfirmaApplet.cleanParam(string), privateKeyEntry, ExtraParamsProcessor.expandProperties(properties, byArray, string4)));
            StringBuilder stringBuilder = new StringBuilder((int)Math.floor((double)byArray2.length * 1.4));
            return this.chunkReturn(stringBuilder.append(Base64.encode(privateKeyEntry.getCertificate().getEncoded())).append('|').append(Base64.encode(byArray2)).toString());
        }
        catch (ExtraParamsProcessor.IncompatiblePolicyException incompatiblePolicyException) {
            this.setError(incompatiblePolicyException);
            throw incompatiblePolicyException;
        }
        catch (AOFormatFileException aOFormatFileException) {
            this.setError(aOFormatFileException);
            throw aOFormatFileException;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            this.setError(certificateEncodingException);
            throw certificateEncodingException;
        }
        catch (SmartCardException smartCardException) {
            this.setError(smartCardException);
            throw smartCardException;
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.setError(privilegedActionException);
            throw privilegedActionException;
        }
        catch (RuntimeException runtimeException) {
            this.setError(runtimeException);
            throw runtimeException;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.setError(outOfMemoryError, "Error de falta de memoria durante la operaci\u00f3n de firma");
            throw outOfMemoryError;
        }
        catch (Error error) {
            this.setError(error);
            throw new AOException("Ocurrio un error grave durante la operaci\u00f3n de firma", error);
        }
    }

    @Override
    public String coSign(String string, String string2, String string3, String string4) throws PrivilegedActionException, IOException, AOException, CertificateEncodingException, ExtraParamsProcessor.IncompatiblePolicyException {
        byte[] byArray;
        this.clearError();
        Properties properties = ExtraParamsProcessor.convertToProperties(string4);
        if (this.dataStore.length() > 0) {
            try {
                byArray = Base64.decode(this.dataStore.toString());
            }
            catch (Exception exception) {
                this.setError(exception, "La firma proporcionada est\u00e1 mal codificada en base 64");
                throw exception;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.setError(outOfMemoryError, "Error de falta de memoria durante la carga de la firma");
                throw outOfMemoryError;
            }
            finally {
                this.dataStore.setLength(0);
            }
        }
        Object object = properties.getProperty("filenameExts", null);
        String string5 = object == null ? MiniAppletMessages.getString("MiniAfirmaApplet.1") : String.format(MiniAppletMessages.getString("MiniAfirmaApplet.6"), ((String)object).replace(",", ",*."));
        try {
            byArray = AccessController.doPrivileged(new GetFileContentAction(MiniAppletMessages.getString("MiniAfirmaApplet.2"), object != null ? ((String)object).split(",") : null, string5, this));
        }
        catch (AOCancelledOperationException aOCancelledOperationException) {
            this.setError(aOCancelledOperationException);
            throw aOCancelledOperationException;
        }
        catch (CancellationException cancellationException) {
            AOCancelledOperationException aOCancelledOperationException = new AOCancelledOperationException("Operacion cancelada por el usuario", cancellationException);
            this.setError(aOCancelledOperationException);
            throw aOCancelledOperationException;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.setError(outOfMemoryError, "Error de falta de memoria durante la carga del fichero de firma");
            throw outOfMemoryError;
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.setError(privilegedActionException);
            throw privilegedActionException;
        }
        catch (Error error) {
            this.setError(error);
            throw new AOException("Ocurrio un error grave durante la operaci\u00f3n de firma", error);
        }
        try {
            object = string == null ? null : Base64.decode(string);
        }
        catch (IOException iOException) {
            this.setError(iOException, "Los datos proporcionados est\u00e1n mal codificados en base 64");
            throw iOException;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.setError(outOfMemoryError, "Error de falta de memoria durante la carga de los datos");
            throw outOfMemoryError;
        }
        catch (Error error) {
            this.setError(error);
            throw new AOException("Ocurrio un error grave durante la operaci\u00f3n de firma", error);
        }
        try {
            string5 = string3;
            AOSigner aOSigner = MiniAfirmaApplet.selectSigner(MiniAfirmaApplet.cleanParam(string5), null, byArray);
            if (SIGNATURE_FORMAT_AUTO.equalsIgnoreCase(string5)) {
                string5 = AOSignerFactory.getSignFormat(aOSigner);
                ExtraParamsProcessor.configAutoFormat(aOSigner, byArray, properties);
            }
            KeyStore.PrivateKeyEntry privateKeyEntry = this.selectPrivateKey(properties);
            byte[] byArray2 = AccessController.doPrivileged(new CoSignAction(aOSigner, byArray, (byte[])object, MiniAfirmaApplet.cleanParam(string2), privateKeyEntry, ExtraParamsProcessor.expandProperties(properties, (byte[])object, string5)));
            StringBuilder stringBuilder = new StringBuilder((int)Math.floor((double)byArray2.length * 1.4));
            return this.chunkReturn(stringBuilder.append(Base64.encode(privateKeyEntry.getCertificate().getEncoded())).append('|').append(Base64.encode(byArray2)).toString());
        }
        catch (ExtraParamsProcessor.IncompatiblePolicyException incompatiblePolicyException) {
            this.setError(incompatiblePolicyException);
            throw incompatiblePolicyException;
        }
        catch (AOFormatFileException aOFormatFileException) {
            this.setError(aOFormatFileException);
            throw aOFormatFileException;
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.setError(privilegedActionException);
            throw privilegedActionException;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            this.setError(certificateEncodingException);
            throw certificateEncodingException;
        }
        catch (SmartCardException smartCardException) {
            this.setError(smartCardException);
            throw smartCardException;
        }
        catch (RuntimeException runtimeException) {
            this.setError(runtimeException);
            throw runtimeException;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.setError(outOfMemoryError, "Error de falta de memoria durante la operaci\u00f3n de cofirma");
            throw outOfMemoryError;
        }
        catch (Error error) {
            this.setError(error);
            throw new AOException("Ocurrio un error grave durante la operaci\u00f3n de cofirma", error);
        }
    }

    @Override
    public String counterSign(String string, String string2, String string3) throws PrivilegedActionException, IOException, AOException, CertificateEncodingException, ExtraParamsProcessor.IncompatiblePolicyException {
        byte[] byArray;
        this.clearError();
        Properties properties = ExtraParamsProcessor.convertToProperties(string3);
        if (this.dataStore.length() > 0) {
            try {
                byArray = Base64.decode(this.dataStore.toString());
            }
            catch (Exception exception) {
                this.setError(exception, "La firma proporcionada est\u00e1 mal codificada en base 64");
                throw exception;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.setError(outOfMemoryError, "Error de falta de memoria durante la carga de la firma");
                throw outOfMemoryError;
            }
            finally {
                this.dataStore.setLength(0);
            }
        }
        String string4 = properties.getProperty("filenameExts", null);
        Object object = string4 == null ? MiniAppletMessages.getString("MiniAfirmaApplet.1") : String.format(MiniAppletMessages.getString("MiniAfirmaApplet.6"), string4.replace(",", ",*."));
        try {
            byArray = AccessController.doPrivileged(new GetFileContentAction(MiniAppletMessages.getString("MiniAfirmaApplet.2"), string4 != null ? string4.split(",") : null, (String)object, this));
        }
        catch (AOCancelledOperationException aOCancelledOperationException) {
            this.setError(aOCancelledOperationException);
            throw aOCancelledOperationException;
        }
        catch (CancellationException cancellationException) {
            AOCancelledOperationException aOCancelledOperationException = new AOCancelledOperationException("Operacion cancelada por el usuario", cancellationException);
            this.setError(aOCancelledOperationException);
            throw aOCancelledOperationException;
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.setError(privilegedActionException);
            throw privilegedActionException;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.setError(outOfMemoryError, "Error de falta de memoria durante la carga del fichero de firma");
            throw outOfMemoryError;
        }
        try {
            string4 = string2;
            object = MiniAfirmaApplet.selectSigner(MiniAfirmaApplet.cleanParam(string4), null, byArray);
            if (SIGNATURE_FORMAT_AUTO.equalsIgnoreCase(string4)) {
                string4 = AOSignerFactory.getSignFormat((AOSigner)object);
                ExtraParamsProcessor.configAutoFormat((AOSigner)object, byArray, properties);
            }
            KeyStore.PrivateKeyEntry privateKeyEntry = this.selectPrivateKey(properties);
            byte[] byArray2 = AccessController.doPrivileged(new CounterSignAction((AOSigner)object, byArray, MiniAfirmaApplet.cleanParam(string), privateKeyEntry, ExtraParamsProcessor.expandProperties(properties, null, string4)));
            StringBuilder stringBuilder = new StringBuilder((int)Math.floor((double)byArray2.length * 1.4));
            return this.chunkReturn(stringBuilder.append(Base64.encode(privateKeyEntry.getCertificate().getEncoded())).append('|').append(Base64.encode(byArray2)).toString());
        }
        catch (ExtraParamsProcessor.IncompatiblePolicyException incompatiblePolicyException) {
            this.setError(incompatiblePolicyException);
            throw incompatiblePolicyException;
        }
        catch (AOFormatFileException aOFormatFileException) {
            this.setError(aOFormatFileException);
            throw aOFormatFileException;
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.setError(privilegedActionException);
            throw privilegedActionException;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            this.setError(certificateEncodingException);
            throw certificateEncodingException;
        }
        catch (SmartCardException smartCardException) {
            this.setError(smartCardException);
            throw smartCardException;
        }
        catch (RuntimeException runtimeException) {
            this.setError(runtimeException);
            throw runtimeException;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.setError(outOfMemoryError, "Error de falta de memoria durante la operaci\u00f3n de contrafirma");
            throw outOfMemoryError;
        }
        catch (Error error) {
            this.setError(error);
            throw new AOException("Ocurrio un error grave durante la operaci\u00f3n de contrafirma", error);
        }
    }

    @Override
    public boolean saveDataToFile(String string, String string2, String string3, String string4) throws PrivilegedActionException, IOException {
        String[] stringArray;
        this.clearError();
        if (this.dataStore.length() < 1) {
            LOGGER.warning("Se ha solicitado guardar en disco un contenido nulo, se ignorara la peticion");
            return false;
        }
        String string5 = MiniAfirmaApplet.cleanParam(string);
        String string6 = MiniAfirmaApplet.cleanParam(string3);
        if (string6 == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string6;
        }
        String[] stringArray3 = stringArray;
        String string7 = MiniAfirmaApplet.cleanParam(string4);
        try {
            AccessController.doPrivileged(new SaveFileAction(string5, Base64.decode(this.dataStore.toString()), stringArray3, string7, MiniAfirmaApplet.cleanParam(string2), this));
            boolean bl = true;
            return bl;
        }
        catch (AOCancelledOperationException aOCancelledOperationException) {
            boolean bl = false;
            return bl;
        }
        catch (CancellationException cancellationException) {
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            this.setError(iOException, "Los datos proporcionados est\u00e1n mal codificados en base 64");
            throw iOException;
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.setError(privilegedActionException);
            throw privilegedActionException;
        }
        catch (RuntimeException runtimeException) {
            this.setError(runtimeException);
            throw runtimeException;
        }
        finally {
            this.dataStore.setLength(0);
        }
    }

    @Override
    public String signAndSaveToFile(String string, String string2, String string3, String string4, String string5) throws PrivilegedActionException, IOException, AOException, CertificateEncodingException, ExtraParamsProcessor.IncompatiblePolicyException {
        String string6;
        String string7;
        if (string == null || CRYPTO_OPERATION_SIGN.equalsIgnoreCase(string)) {
            string7 = this.sign(string2, string3, string4);
            string6 = MiniAppletMessages.getString("MiniAfirmaApplet.3");
        } else if (CRYPTO_OPERATION_COSIGN.equalsIgnoreCase(string)) {
            string7 = this.coSign(null, string2, string3, string4);
            string6 = MiniAppletMessages.getString("MiniAfirmaApplet.4");
        } else if (CRYPTO_OPERATION_COUNTERSIGN.equalsIgnoreCase(string)) {
            string7 = this.counterSign(string2, string3, string4);
            string6 = MiniAppletMessages.getString("MiniAfirmaApplet.5");
        } else {
            throw new UnsupportedOperationException("La operacion criptografica no soportada: " + string);
        }
        this.dataStore.append(string7.substring(string7.indexOf(124) + 1));
        try {
            this.saveDataToFile(string6, string5, null, MiniAppletMessages.getString("MiniAfirmaApplet.1"));
        }
        catch (Exception exception) {
            LOGGER.warning("No se pudo completar el guardado de la firma: " + exception);
        }
        return string7;
    }

    @Override
    public String getFileNameContentBase64(String string, String string2, String string3, String string4) throws PrivilegedActionException, IOException {
        this.clearError();
        return this.chunkReturn(this.getFileNameContent(string, string2, string3, string4, true));
    }

    private String getFileNameContent(String string, String string2, String string3, String string4, boolean bl) throws PrivilegedActionException {
        this.clearError();
        String string5 = MiniAfirmaApplet.cleanParam(string);
        String string6 = MiniAfirmaApplet.cleanParam(string2);
        String[] stringArray = string6 == null ? null : string6.split(",");
        String string7 = MiniAfirmaApplet.cleanParam(string3);
        String string8 = MiniAfirmaApplet.cleanParam(string4);
        try {
            return AccessController.doPrivileged(new GetFileNameContentAction(string5, stringArray, string7, string8, false, bl, this))[0];
        }
        catch (AOCancelledOperationException aOCancelledOperationException) {
            this.setError(aOCancelledOperationException);
            throw aOCancelledOperationException;
        }
        catch (CancellationException cancellationException) {
            AOCancelledOperationException aOCancelledOperationException = new AOCancelledOperationException("Operacion cancelada por el usuario", cancellationException);
            this.setError(aOCancelledOperationException);
            throw aOCancelledOperationException;
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.setError(privilegedActionException);
            throw privilegedActionException;
        }
        catch (RuntimeException runtimeException) {
            this.setError(runtimeException);
            throw runtimeException;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.setError(outOfMemoryError, "Error de falta de memoria durante la carga del fichero");
            throw outOfMemoryError;
        }
    }

    @Override
    public String[] getMultiFileNameContentBase64(String string, String string2, String string3, String string4) throws PrivilegedActionException {
        return this.getMultiFileNameContent(string, string2, string3, string4, true);
    }

    private String[] getMultiFileNameContent(String string, String string2, String string3, String string4, boolean bl) throws PrivilegedActionException {
        this.clearError();
        String string5 = MiniAfirmaApplet.cleanParam(string);
        String string6 = MiniAfirmaApplet.cleanParam(string2);
        String[] stringArray = string6 == null ? null : string6.split(",");
        String string7 = MiniAfirmaApplet.cleanParam(string3);
        String string8 = MiniAfirmaApplet.cleanParam(string4);
        try {
            return AccessController.doPrivileged(new GetFileNameContentAction(string5, stringArray, string7, string8, true, bl, this));
        }
        catch (AOCancelledOperationException aOCancelledOperationException) {
            this.setError(aOCancelledOperationException);
            throw aOCancelledOperationException;
        }
        catch (CancellationException cancellationException) {
            AOCancelledOperationException aOCancelledOperationException = new AOCancelledOperationException("Operacion cancelada por el usuario", cancellationException);
            this.setError(aOCancelledOperationException);
            throw aOCancelledOperationException;
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.setError(privilegedActionException);
            throw privilegedActionException;
        }
        catch (RuntimeException runtimeException) {
            this.setError(runtimeException);
            throw runtimeException;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.setError(outOfMemoryError, "Error de falta de memoria durante la carga de los ficheros");
            throw outOfMemoryError;
        }
    }

    @Override
    public String getTextFromBase64(String string, String string2) throws IOException {
        this.clearError();
        if (string == null) {
            return null;
        }
        String string3 = MiniAfirmaApplet.getCharset(MiniAfirmaApplet.cleanParam(string2), string);
        try {
            return this.chunkReturn(new String(Base64.decode(string), string3));
        }
        catch (IOException iOException) {
            this.setError(iOException);
            throw iOException;
        }
    }

    @Override
    public String getBase64FromText(String string, String string2) throws UnsupportedEncodingException {
        this.clearError();
        if (string == null) {
            return null;
        }
        String string3 = MiniAfirmaApplet.getCharset(MiniAfirmaApplet.cleanParam(string2), null);
        try {
            return Base64.encode(string.getBytes(string3));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.setError(unsupportedEncodingException);
            throw unsupportedEncodingException;
        }
    }

    @Override
    public URL getCodeBase() {
        URL uRL = null;
        try {
            uRL = super.getCodeBase();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uRL != null) {
            return uRL;
        }
        try {
            return new URL(MiniAfirmaApplet.class.getResource("/miniappletmessages.properties").toString().replace("/miniappletmessages.properties", ""));
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException("No se puede determinar el codebase del Aeplet: " + malformedURLException, malformedURLException);
        }
    }

    @Override
    public void init() {
        MiniAfirmaApplet.setSystemProperties(this.getParameter(APPLET_PARAM_SYSTEM_PROPERTIES));
        MiniAfirmaApplet.setLocale(this.getParameter(APPLET_PARAM_LOCALE));
        this.userAgent = this.getParameter(APPLET_PARAM_USER_AGENT);
        String string = MiniAfirmaApplet.cleanParam(this.getParameter(APPLET_PARAM_USER_KEYSTORE));
        if (string != null && !string.equals("null")) {
            int n = string.indexOf(58);
            try {
                if (n == -1) {
                    this.keystoreType = AOKeyStore.valueOf(string);
                } else if (string.length() > 1) {
                    this.keystoreType = AOKeyStore.valueOf(string.substring(0, n).trim());
                    if (n < string.length() - 1 && string.substring(n + 1).trim().length() > 0) {
                        this.keystoreLib = string.substring(n + 1).trim();
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.warning("Se ha intentado cargar un almacen de certificados no soportado, se cargara el por defecto: " + exception);
            }
        }
        MiniAfirmaApplet.configureLookAndFeel();
        if (!Boolean.getBoolean("es.gob.afirma.doNotSendAnalytics") && !Boolean.parseBoolean(System.getenv("es.gob.afirma.doNotSendAnalytics"))) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        AnalyticsConfigData analyticsConfigData = new AnalyticsConfigData(MiniAfirmaApplet.GOOGLE_ANALYTICS_TRACKING_CODE);
                        JGoogleAnalyticsTracker jGoogleAnalyticsTracker = new JGoogleAnalyticsTracker(analyticsConfigData, JGoogleAnalyticsTracker.GoogleAnalyticsVersion.V_4_7_2);
                        jGoogleAnalyticsTracker.trackPageView(MiniAfirmaApplet.this.getCodeBase().toString(), "MiniApplet Cliente @firma " + MiniAfirmaApplet.getVersion(), MiniAfirmaApplet.this.getCodeBase().getHost().toString());
                    }
                    catch (Exception exception) {
                        LOGGER.warning("Error registrando datos en Google Analytics: " + exception);
                    }
                }
            }).start();
        }
        LOGGER.info("Miniapplet Afirma " + MiniAfirmaApplet.getVersion());
        LOGGER.info("Sistema operativo: " + System.getProperty("os.name"));
        LOGGER.info("Version del SO: " + System.getProperty("os.version"));
        LOGGER.info("Version de Java: " + System.getProperty("java.version"));
        LOGGER.info("Arquitectura del JRE: " + Platform.getJavaArch());
        LOGGER.info("Java Vendor: " + System.getProperty("java.vm.vendor"));
        LOGGER.info("Localizacion por defecto: " + Locale.getDefault());
        LOGGER.info("Tamano actual en memoria: " + Runtime.getRuntime().totalMemory() / 0x100000L + "MB");
        LOGGER.info("Tamano maximo de memoria: " + Runtime.getRuntime().maxMemory() / 0x100000L + "MB");
        LOGGER.info("Memoria actualmente libre: " + Runtime.getRuntime().freeMemory() / 0x100000L + "MB");
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String getErrorType() {
        return this.errorType;
    }

    private void setError(Throwable throwable) {
        this.setError(throwable, null);
    }

    private void setError(Throwable throwable, String string) {
        Throwable throwable2 = throwable;
        if (throwable instanceof PrivilegedActionException && throwable.getCause() != null) {
            throwable2 = throwable.getCause();
        }
        this.errorMessage = string != null ? string : (throwable2.getLocalizedMessage() != null ? throwable2.getLocalizedMessage() : (throwable2.getMessage() != null ? throwable2.getMessage() : throwable2.toString()));
        this.errorType = throwable2.getClass().getCanonicalName();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);){
            throwable.printStackTrace(printWriter);
            printWriter.flush();
        }
        LOGGER.severe(new String(byteArrayOutputStream.toByteArray()));
    }

    private void clearError() {
        this.errorType = null;
        this.errorMessage = null;
    }

    @Override
    public void setKeyStore(String string) throws AOException {
        LOGGER.info("Se configura el almacen de certificados " + string);
        this.clearError();
        if (string == null || string.length() == 0) {
            this.keystoreType = null;
            this.keystoreLib = null;
        } else {
            int n = string.indexOf(58);
            try {
                if (n == -1) {
                    this.keystoreType = AOKeyStore.valueOf(string);
                } else if (string.length() > 1) {
                    this.keystoreType = AOKeyStore.valueOf(string.substring(0, n).trim());
                    if (n < string.length() - 1 && string.substring(n + 1).trim().length() > 0) {
                        this.keystoreLib = string.substring(n + 1).trim();
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.severe("El tipo de almacen indicado (" + string + ") no existe: " + exception);
                this.setError(exception, "El tipo de almacen indicado no existe: " + string);
                throw new AOException("El tipo de almacen indicado no existe: " + string, exception);
            }
        }
    }

    public KeyStore.PrivateKeyEntry selectPrivateKey(Properties properties) throws PrivilegedActionException {
        if (this.stickySignatory && this.stickyKeyEntry != null) {
            return this.stickyKeyEntry;
        }
        SelectPrivateKeyAction selectPrivateKeyAction = this.keystoreType == null ? new SelectPrivateKeyAction(Platform.getOS(), Platform.getBrowser(this.userAgent), new CertFilterManager(properties), (Component)this) : new SelectPrivateKeyAction(this.keystoreType, this.keystoreLib, new CertFilterManager(properties), (Component)this);
        KeyStore.PrivateKeyEntry privateKeyEntry = AccessController.doPrivileged(selectPrivateKeyAction);
        if (this.stickySignatory) {
            this.stickyKeyEntry = privateKeyEntry;
        }
        return privateKeyEntry;
    }

    private static AOSigner selectSigner(String string, byte[] byArray, byte[] byArray2) throws AOFormatFileException, PrivilegedActionException {
        AOSigner aOSigner;
        if (string == null) {
            throw new IllegalArgumentException("No se ha indicado el formato para la operacion de firma");
        }
        if (!SIGNATURE_FORMAT_AUTO.equalsIgnoreCase(string)) {
            aOSigner = MiniAfirmaApplet.getSigner(string);
            if (aOSigner == null) {
                throw new AOFormatFileException("No esta soportado el formato de firma: " + string);
            }
        } else if (byArray != null) {
            aOSigner = MiniAfirmaApplet.getSigner(string, byArray);
        } else if (byArray2 != null) {
            aOSigner = MiniAfirmaApplet.getSigner(byArray2);
            if (aOSigner == null) {
                throw new IllegalArgumentException("Los datos introducidos no se corresponden con una firma soportada");
            }
        } else {
            throw new IllegalArgumentException("No se han introducido datos para la seleccion del signer");
        }
        return aOSigner;
    }

    private static AOSigner getSigner(String string) throws PrivilegedActionException {
        return AccessController.doPrivileged(new SelectSignerAction(string));
    }

    private static AOSigner getSigner(String string, byte[] byArray) throws PrivilegedActionException {
        return AccessController.doPrivileged(new SelectSignerAction(string, byArray));
    }

    private static AOSigner getSigner(byte[] byArray) throws PrivilegedActionException {
        return AccessController.doPrivileged(new SelectSignerAction(byArray));
    }

    private static void configureLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            LOGGER.warning("No se ha podido establecer el Look&Feel: " + exception);
        }
        JDialog.setDefaultLookAndFeelDecorated(true);
        JFrame.setDefaultLookAndFeelDecorated(true);
    }

    private static String cleanParam(String string) {
        return string == null || string.trim().length() < 1 ? null : string.trim();
    }

    private static String getCharset(String string, String string2) {
        if ("auto".equalsIgnoreCase(string)) {
            String string3;
            byte[] byArray;
            if (string2 == null) {
                LOGGER.warning("No se puede detectar el juego de caracteres de un texto nulo, se devolvera la codificacion por defecto");
                return MiniAfirmaApplet.getCharset("default", null);
            }
            try {
                byArray = Base64.decode(string2);
            }
            catch (IOException iOException) {
                LOGGER.warning("Los datos proporcionados est\u00e1n mal codificados en base 64");
                return MiniAfirmaApplet.getCharset("default", null);
            }
            UniversalDetector universalDetector = new UniversalDetector();
            universalDetector.handleData(byArray, 0, byArray.length);
            universalDetector.dataEnd();
            if (universalDetector.isDone() && (string3 = universalDetector.getDetectedCharset()) != null) {
                return string3;
            }
            LOGGER.warning("No se ha podido autodetectar el juego de caracteres, se devolvera el por defecto del sistema");
            return MiniAfirmaApplet.getCharset("default", null);
        }
        if ("default".equalsIgnoreCase(string) || string == null) {
            return AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
        }
        return string;
    }

    @Override
    public String echo() {
        String string = "Java vendor: " + System.getProperty("java.vm.vendor") + '\n' + "Java version: " + System.getProperty("java.version") + '\n' + "Java architecture: " + Platform.getJavaArch();
        LOGGER.info("MiniApplet cargado y en ejecuci\u00f3n");
        LOGGER.info(string);
        return string;
    }

    private byte[] readChunk() throws IOException {
        byte[] byArray;
        if (this.chunkedReturnStream == null) {
            return new byte[0];
        }
        boolean bl = false;
        int n = this.chunkedReturnStream.available();
        if (n > 0x100000) {
            byArray = new byte[0x100000];
        } else if (n > 0) {
            byArray = new byte[n];
            bl = true;
        } else {
            this.chunkedReturnStream = null;
            return new byte[0];
        }
        int n2 = this.chunkedReturnStream.read(byArray);
        if (n2 != byArray.length) {
            this.chunkedReturnStream = null;
            throw new IOException("Lectura incompleta de la porcion de datos resultantes");
        }
        if (bl) {
            this.chunkedReturnStream.close();
            this.chunkedReturnStream = null;
        }
        return byArray;
    }

    private String chunkReturn(String string) throws IOException {
        if (string == null || string.length() <= 0x100000) {
            return string;
        }
        LOGGER.info("El resultado es demasiado grande (" + string.length() + " caracteres), se ha devuelto un resultado parcial y debe solicitarse el resto en llamadas adicionales");
        this.chunkedReturnStream = new ByteArrayInputStream(string.getBytes(DEFAULT_CHUNK_ENCODING));
        return new String(this.readChunk(), DEFAULT_CHUNK_ENCODING);
    }

    @Override
    public String getRemainingData() throws IOException {
        byte[] byArray = this.readChunk();
        if (byArray == null) {
            throw new IOException("Se ha producido una lectura parcial nula");
        }
        if (byArray.length == 0) {
            LOGGER.info("Se ha terminado de devolver un resultado grande");
            return EOF;
        }
        LOGGER.info("Devolucion parcial de " + byArray.length + " caracteres");
        return new String(byArray, DEFAULT_CHUNK_ENCODING);
    }

    @Override
    public void addData(String string) {
        if (string == null) {
            this.dataStore.setLength(0);
        } else {
            this.dataStore.append(string);
            LOGGER.info("Anadida porcion de datos de longitud: " + string.length());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getVersion() {
        try (InputStream inputStream = MiniAfirmaApplet.class.getClassLoader().getResourceAsStream("miniapplet.version");){
            Properties properties = new Properties();
            properties.load(inputStream);
            String string = properties.getProperty("version", "");
            return string;
        }
        catch (Exception exception) {
            LOGGER.warning("No se ha podido leer el numero de version del MiniApplet del fichero de version: " + exception);
            return "";
        }
    }

    private static void setSystemProperties(String string) {
        LOGGER.info("setSystemProperties: " + string);
        if (string != null && string.trim().length() > 0) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("-D")) {
                int n = string2.indexOf(61);
                if (n == -1) continue;
                LOGGER.info("Establecemos la propiedad del sistema: " + string2.trim());
                System.setProperty(string2.substring(0, n).trim(), string2.substring(n + 1).trim());
            }
        }
    }

    private static void setLocale(String string) {
        LOGGER.info("setLocale: " + string);
        if (string == null || string.trim().length() == 0) {
            return;
        }
        String[] stringArray = string.replace('-', '_').split("_");
        if (stringArray.length == 1) {
            Locale.setDefault(new Locale(stringArray[0]));
        } else if (stringArray.length == 2) {
            Locale.setDefault(new Locale(stringArray[0], stringArray[1]));
        } else if (stringArray.length > 2) {
            Locale.setDefault(new Locale(stringArray[0], stringArray[1], stringArray[2]));
        }
    }

    @Override
    public String getCurrentLog() {
        return AccessController.doPrivileged(new GetCurrentLogAction());
    }

    @Deprecated
    private static boolean isXadesEnvelopedExplicit(String string, Properties properties) {
        return MiniAfirmaApplet.isXadesExplicitConfigurated(string, properties) && "XAdES Enveloped".equalsIgnoreCase(properties.getProperty("format"));
    }

    @Deprecated
    private static boolean isXadesExplicitConfigurated(String string, Properties properties) {
        return string != null && string.toLowerCase().startsWith("xades") && properties != null && "explicit".equalsIgnoreCase(properties.getProperty("mode"));
    }

    @Override
    public String signBatch(final String string, final String string2, final String string3, String string4) throws AOException, PrivilegedActionException {
        KeyStore.PrivateKeyEntry privateKeyEntry;
        Properties properties = ExtraParamsProcessor.convertToProperties(string4);
        try {
            privateKeyEntry = this.selectPrivateKey(properties);
        }
        catch (PrivilegedActionException privilegedActionException) {
            LOGGER.severe("error al seleccionar certificado: " + privilegedActionException);
            this.setError(privilegedActionException);
            throw privilegedActionException;
        }
        catch (SmartCardException smartCardException) {
            this.setError(smartCardException);
            throw smartCardException;
        }
        catch (RuntimeException runtimeException) {
            this.setError(runtimeException);
            throw runtimeException;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.setError(outOfMemoryError, "Error de falta de memoria durante la operaci\u00f3n de firma de lote");
            throw outOfMemoryError;
        }
        catch (Error error) {
            this.setError(error);
            throw new AOException("Ocurrio un error grave durante la operaci\u00f3n de firma de lote", error);
        }
        try {
            return Base64.encode(AccessController.doPrivileged(new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws Exception {
                    return BatchSigner.sign(string, string2, string3, privateKeyEntry.getCertificateChain(), privateKeyEntry.getPrivateKey()).getBytes(StandardCharsets.UTF_8.name());
                }
            }));
        }
        catch (Exception exception) {
            if (exception.getCause() instanceof CertificateEncodingException) {
                LOGGER.severe("Error al codificar el certificado al realizar la firma por lotes: " + exception);
                AOException aOException = new AOException(exception);
                this.setError(exception);
                throw aOException;
            }
            LOGGER.severe("Error al realizar la firma por lotes: " + exception);
            AOException aOException = new AOException(exception);
            this.setError(exception);
            throw aOException;
        }
    }

    @Override
    public String selectCertificate(String string) throws AOException, PrivilegedActionException, CertificateEncodingException {
        LOGGER.info("Solicitada la seleccion de un certificado");
        this.clearError();
        Properties properties = ExtraParamsProcessor.convertToProperties(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        properties.list(printStream);
        LOGGER.info("Recibidos los siguientes parametros adicionales:\n" + byteArrayOutputStream.toString());
        try {
            KeyStore.PrivateKeyEntry privateKeyEntry = this.selectPrivateKey(properties);
            return Base64.encode(privateKeyEntry.getCertificate().getEncoded());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            this.setError(certificateEncodingException);
            throw certificateEncodingException;
        }
        catch (SmartCardException smartCardException) {
            this.setError(smartCardException);
            throw smartCardException;
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.setError(privilegedActionException);
            throw privilegedActionException;
        }
        catch (RuntimeException runtimeException) {
            this.setError(runtimeException);
            throw runtimeException;
        }
        catch (Error error) {
            this.setError(error);
            throw new AOException("Ocurrio un error grave durante la seleccion de un certificado de firma", error);
        }
    }

    static {
        try {
            LogManager.install(LogManager.App.MINIAPPLET);
        }
        catch (Exception exception) {
            LOGGER.severe("No ha sido posible instalar el gestor de registro: " + exception);
        }
    }
}

