/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.miniapplet;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.ui.AOUIFactory;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;

final class GetFileNameContentAction
implements PrivilegedExceptionAction<String[]> {
    private static final String SEPARATOR = "|";
    private final String title;
    private final String[] exts;
    private final String desc;
    private final String path;
    private final boolean multiSel;
    private final boolean asBase64;
    private final Component parent;

    GetFileNameContentAction(String string, String[] stringArray, String string2, String string3, boolean bl, boolean bl2, Component component) {
        this.title = string;
        this.exts = stringArray != null ? (String[])stringArray.clone() : null;
        this.desc = string2;
        this.path = string3;
        this.multiSel = bl;
        this.asBase64 = bl2;
        this.parent = component;
    }

    @Override
    public String[] run() throws IOException {
        File[] fileArray;
        String string = null;
        String string2 = null;
        if (this.path != null) {
            fileArray = new File(this.path);
            if (fileArray.isDirectory()) {
                string = fileArray.getAbsolutePath();
            } else {
                string = fileArray.getParentFile() != null ? fileArray.getParentFile().getAbsolutePath() : null;
                string2 = fileArray.getName();
            }
        }
        fileArray = AOUIFactory.getLoadFiles(this.title, string, string2, this.exts, this.desc, false, this.multiSel, null, this.parent);
        String[] stringArray = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            FileInputStream fileInputStream = new FileInputStream(fileArray[i]);
            byte[] byArray = AOUtil.getDataFromInputStream(fileInputStream);
            fileInputStream.close();
            stringArray[i] = fileArray[i].getName() + SEPARATOR + (this.asBase64 ? Base64.encode(byArray) : new String(byArray));
        }
        return stringArray;
    }
}

