/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.miniapplet;

import es.gob.afirma.core.misc.AOFileUtils;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.AOSignerFactory;

final class DataAnalizerUtil {
    private DataAnalizerUtil() {
    }

    public static boolean isXML(byte[] byArray) {
        return AOFileUtils.isXML(byArray);
    }

    public static boolean isPDF(byte[] byArray) {
        try {
            AOSigner aOSigner = AOSignerFactory.getSigner("PAdES");
            if (aOSigner == null) {
                return false;
            }
            return aOSigner.isValidDataFile(byArray);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isFacturae(byte[] byArray) {
        try {
            AOSigner aOSigner = AOSignerFactory.getSigner("FacturaE");
            if (aOSigner == null) {
                return false;
            }
            return aOSigner.isValidDataFile(byArray);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isODF(byte[] byArray) {
        try {
            AOSigner aOSigner = AOSignerFactory.getSigner("ODF (Open Document Format)");
            if (aOSigner == null) {
                return false;
            }
            return aOSigner.isValidDataFile(byArray);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isOOXML(byte[] byArray) {
        try {
            AOSigner aOSigner = AOSignerFactory.getSigner("OOXML (Office Open XML)");
            if (aOSigner == null) {
                return false;
            }
            return aOSigner.isValidDataFile(byArray);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

