/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.miniapplet;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.signers.AOSigner;
import java.io.IOException;
import java.security.KeyStore;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;

final class CoSignAction
implements PrivilegedExceptionAction<byte[]> {
    private final AOSigner signer;
    private final byte[] sign;
    private final byte[] data;
    private final String algorithm;
    private final KeyStore.PrivateKeyEntry keyEntry;
    private final Properties extraParams;

    CoSignAction(AOSigner aOSigner, byte[] byArray, byte[] byArray2, String string, KeyStore.PrivateKeyEntry privateKeyEntry, Properties properties) {
        this.signer = aOSigner;
        this.sign = byArray != null ? (byte[])byArray.clone() : null;
        this.data = byArray2 != null ? (byte[])byArray2.clone() : null;
        this.algorithm = string;
        this.keyEntry = privateKeyEntry;
        this.extraParams = properties;
    }

    @Override
    public byte[] run() throws AOException, IOException {
        if (this.data == null) {
            return this.signer.cosign(this.sign, this.algorithm, this.keyEntry.getPrivateKey(), this.keyEntry.getCertificateChain(), this.extraParams);
        }
        return this.signer.cosign(this.data, this.sign, this.algorithm, this.keyEntry.getPrivateKey(), this.keyEntry.getCertificateChain(), this.extraParams);
    }
}

