/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.mozilla.shared;

import es.gob.afirma.keystores.mozilla.AOSecMod;
import es.gob.afirma.keystores.mozilla.MozillaKeyStoreUtilities;
import es.gob.afirma.keystores.mozilla.Pkcs11Txt;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SharedNssUtil {
    private static final String NSSDB_PATH_UNIX_GLOBAL = "/etc/pki/nssdb";
    private static final String NSSDB_PATH_UNIX_USER = System.getProperty("user.home") + "/.pki/nssdb";
    private static final String[] NSSDB_PATHS = new String[]{NSSDB_PATH_UNIX_USER, "/etc/pki/nssdb"};
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    private SharedNssUtil() {
    }

    private static boolean isNssProfileDirectory(String string) {
        if (string == null) {
            return false;
        }
        File file = new File(string);
        if (!file.isDirectory()) {
            return false;
        }
        return file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String string = file.getName();
                return string.startsWith("key") && string.endsWith(".db");
            }
        }).length > 0;
    }

    public static String getSharedUserProfileDirectory() throws FileNotFoundException {
        for (String string : NSSDB_PATHS) {
            if (!SharedNssUtil.isNssProfileDirectory(string)) continue;
            LOGGER.info("Detectado directorio de perfil de NSS: " + string.replace(System.getProperty("user.home"), "\u0334"));
            return string;
        }
        throw new FileNotFoundException();
    }

    static Map<String, String> getSharedNssPKCS11Modules(boolean bl, boolean bl2) {
        List<AOSecMod.ModuleName> list;
        if (!bl) {
            LOGGER.info("Se ha solicitado incluir los modulos nativos de DNIe");
        }
        try {
            list = Pkcs11Txt.getModules();
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "No se han podido obtener los modulos externos de Mozilla desde 'pkcs11.txt': " + exception, exception);
            return new ConcurrentHashMap<String, String>(0);
        }
        return MozillaKeyStoreUtilities.getPkcs11ModulesFromModuleNames(list, bl2, bl);
    }
}

