/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.mozilla.bintutil;

import java.util.Hashtable;

public enum PeMachineType {
    UNKNOWN("Desconocida"),
    MATSUSHITA_AM33("Matsushita AM33"),
    X64("x64"),
    ARM_LITTLE_ENDIAN("ARM little endian"),
    EFI_BYTECODE("EFI bytecode"),
    INTEL_386("Intel 386 o posteriores y compatibles"),
    INTEL_ITANIUM("Familia de procesadores Intel Itanium"),
    MITSUBISHI_M32R_LITTLE_ENDIAN("Mitsubishi M32R little endian"),
    MIPS16("MIPS 16"),
    MIPS_FPU("MIPS con FPU");

    private final String description;
    private static final Hashtable<String, PeMachineType> machineTypes;

    private PeMachineType(String string2) {
        this.description = string2;
    }

    public String toString() {
        return this.description;
    }

    static PeMachineType getPeMachineType(String string) {
        return machineTypes.get(string);
    }

    static {
        machineTypes = new Hashtable(10);
        machineTypes.put("00-00", UNKNOWN);
        machineTypes.put("01-D3", MATSUSHITA_AM33);
        machineTypes.put("86-64", X64);
        machineTypes.put("01-C0", ARM_LITTLE_ENDIAN);
        machineTypes.put("0E-BC", EFI_BYTECODE);
        machineTypes.put("01-4C", INTEL_386);
        machineTypes.put("02-00", INTEL_ITANIUM);
        machineTypes.put("90-41", MITSUBISHI_M32R_LITTLE_ENDIAN);
        machineTypes.put("02-66", MIPS16);
        machineTypes.put("03-66", MIPS_FPU);
    }
}

