/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.mozilla.bintutil;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.keystores.mozilla.bintutil.AOBinUtil;
import es.gob.afirma.keystores.mozilla.bintutil.PEParserException;
import es.gob.afirma.keystores.mozilla.bintutil.PeMachineType;
import java.util.logging.Logger;

public final class MsPortableExecutable {
    private static final byte PE_SIGNATURE_OFFSET = 60;
    private final String description;
    private final PeMachineType machine;

    public PeMachineType getPeMachineType() {
        return this.machine;
    }

    public String toString() {
        return this.description;
    }

    public MsPortableExecutable(byte[] byArray) throws PEParserException {
        int n;
        int n2 = AOBinUtil.getU2(byArray, 60) + 4;
        if (!"PE\u0000\u0000".equals(new String(new byte[]{byArray[n2 - 4], byArray[n2 - 3], byArray[n2 - 2], byArray[n2 - 1]}))) {
            throw new PEParserException("Cabecera PE\\0\\0 no encontrada en el offset " + AOUtil.hexify(new byte[]{60}, false));
        }
        StringBuilder stringBuilder = new StringBuilder("Fichero Microsoft PE");
        stringBuilder.append("\n Cabecera PE\\0\\0 encontrada en el offset " + AOUtil.hexify(new byte[]{60}, false));
        this.machine = PeMachineType.getPeMachineType(AOUtil.hexify(new byte[]{byArray[n2 + 1], byArray[n2]}, true));
        stringBuilder.append("\n Tipo de maquina: " + (Object)((Object)this.machine));
        int n3 = AOBinUtil.getU2(byArray, n2 + 2);
        stringBuilder.append("\n Numero de secciones de la tabla de secciones: " + n3);
        if (AOBinUtil.getInt(byArray, n2 + 8) != 0) {
            Logger.getLogger("es.gob.afirma").warning("El puntero a la informacion de depuracion del COFF no es cero (se implementa una caracteristica deprecada)");
        }
        if (AOBinUtil.getInt(byArray, n2 + 12) != 0) {
            Logger.getLogger("es.gob.afirma").warning("El numero de entradas de la tabla de simbolos no es cero (se implementa una caracteristica deprecada)");
        }
        if ((n = AOBinUtil.getU2(byArray, n2 + 16)) == 0) {
            stringBuilder.append("\n El fichero es un objeto (no tiene cabecera opcional)");
        } else {
            stringBuilder.append("\n El fichero es ejecutable (tamano de la cabecera opcional: " + n + ")");
        }
        byte[] byArray2 = new byte[]{byArray[n2 + 19], byArray[n2 + 18]};
        if (0 != (byte)(byArray2[1] & 1)) {
            stringBuilder.append("\n El fichero no contiene relocalizaciones de base");
        }
        if (0 != (byte)(byArray2[1] & 2)) {
            stringBuilder.append("\n Imagen valida");
        }
        if (0 != (byte)(byArray2[1] & 4)) {
            Logger.getLogger("es.gob.afirma").warning("Numeros de linea de la imagen COFF eliminados (se implementa una caracteristica deprecada");
        }
        if (0 != (byte)(byArray2[1] & 8)) {
            Logger.getLogger("es.gob.afirma").warning("Entradas de la tabla de simbolos de la imagen COFF para simbolos locales eliminadas (se implementa una caracteristica deprecada)");
        }
        if (0 != (byte)(byArray2[1] & 0x10)) {
            Logger.getLogger("es.gob.afirma").warning("Conjunto truncando agresivamente (se implementa una caracteristica deprecada para Windows 2000 y posteriores)");
        }
        if (0 != (byte)(byArray2[1] & 0x20)) {
            stringBuilder.append("\n La aplicacion puede gestionar direccionamiento superior a 2GB");
        }
        if (0 != (byte)(byArray2[1] & 0x40)) {
            Logger.getLogger("es.gob.afirma").warning("Se hace uso de un bit reservado para uso futuro");
        }
        if (0 != (byte)(byArray2[1] & 0xFFFFFF80)) {
            stringBuilder.append("\n Arquitectura Little Endian");
        }
        if (0 != (byte)(byArray2[0] & 1)) {
            stringBuilder.append("\n Arquitectura con palabras de 32 bits");
        }
        if (0 != (byte)(byArray2[0] & 2)) {
            stringBuilder.append("\n Informacion de depuracion eliminada de la imagen");
        }
        if (0 != (byte)(byArray2[0] & 4)) {
            stringBuilder.append("\n Si la imagen se encuentra en almacenamiento extraible, debe cargarse completamente y copiarse al fichero de intercambio");
        }
        if (0 != (byte)(byArray2[0] & 8)) {
            stringBuilder.append("\n Si la imagen se encuantra en almacenamiento en red, debe cargarse completamente y copiarse al fichero de intercambio");
        }
        if (0 != (byte)(byArray2[0] & 0x10)) {
            stringBuilder.append("\n La imagen es un fichero de sistema, no un programa de usuario");
        }
        if (0 != (byte)(byArray2[0] & 0x20)) {
            stringBuilder.append("\n La imagen es una biblioteca de enlace dinamico");
        }
        if (0 != (byte)(byArray2[0] & 0x40)) {
            stringBuilder.append("\n La imagen debe ejecutarse en una maquina con un unico procesador");
        }
        if (0 != (byte)(byArray2[0] & 0x20)) {
            stringBuilder.append("\n Arquitectura Big Endian");
        }
        if (n > 0) {
            boolean bl = false;
            if (byArray[n2 + 20 + 1] == 1) {
                if (byArray[n2 + 20 + 0] == 11) {
                    stringBuilder.append("\n La imagen es un ejecutable normal (PE32)");
                } else if (byArray[n2 + 20 + 0] == 7) {
                    stringBuilder.append("\n La imagen es una ROM");
                } else {
                    Logger.getLogger("es.gob.afirma").warning("El fichero de imagen es de un tipo desconocido (Magic: " + AOUtil.hexify(new byte[]{byArray[n2 + 21], byArray[n2 + 20]}, true) + ")");
                }
            } else if (byArray[n2 + 20 + 1] == 2 && byArray[n2 + 20] == 11) {
                stringBuilder.append("\n La imagen es un ejecutable PE32+");
                bl = true;
            } else {
                Logger.getLogger("es.gob.afirma").warning("El fichero de imagen es de un tipo desconocido (Magic: " + AOUtil.hexify(new byte[]{byArray[n2 + 21], byArray[n2 + 20]}, true) + ")");
            }
            stringBuilder.append("\n Version del enlazador usado para crear la imagen: " + byArray[n2 + 20 + 2] + "." + byArray[n2 + 20 + 3]);
            stringBuilder.append("\n Version requerida del sistema operativo: " + AOBinUtil.getU2(byArray, n2 + 20 + 40) + "." + AOBinUtil.getU2(byArray, n2 + 20 + 42));
            stringBuilder.append("\n Version de la imagen: " + AOBinUtil.getU2(byArray, n2 + 20 + 44) + "." + AOBinUtil.getU2(byArray, n2 + 20 + 46));
            stringBuilder.append("\n Version del subsistema: " + AOBinUtil.getU2(byArray, n2 + 20 + 48) + "." + AOBinUtil.getU2(byArray, n2 + 20 + 50));
            stringBuilder.append("\n Tamano de la imagen en memoria: " + AOUtil.hexify(new byte[]{byArray[n2 + 20 + 56], byArray[n2 + 20 + 57], byArray[n2 + 20 + 58], byArray[n2 + 20 + 59]}, false));
            stringBuilder.append('h');
            stringBuilder.append("\n Tamano de las cabeceras (DOS Stub, cabecera PE y cabeceras de seccion, en valor redondeado a un multiplo de 'FileAlignment'): " + AOUtil.hexify(new byte[]{byArray[n2 + 20 + 60], byArray[n2 + 20 + 61], byArray[n2 + 20 + 62], byArray[n2 + 20 + 63]}, false));
            stringBuilder.append('h');
            stringBuilder.append("\n Checksum de la imagen: " + AOUtil.hexify(new byte[]{byArray[n2 + 20 + 64], byArray[n2 + 20 + 65], byArray[n2 + 20 + 66], byArray[n2 + 20 + 67]}, false));
            stringBuilder.append("\n Tipo de subsistema Windows: ");
            switch (AOBinUtil.getU2(byArray, n2 + 20 + 68)) {
                case 0: {
                    stringBuilder.append(" Desconocido");
                    break;
                }
                case 1: {
                    stringBuilder.append(" Controlador de dispositiovo o proceso nativo Windows");
                    break;
                }
                case 2: {
                    stringBuilder.append(" Windows en modo grafico (GUI)");
                    break;
                }
                case 3: {
                    stringBuilder.append(" Windows en modo texto");
                    break;
                }
                case 7: {
                    stringBuilder.append(" POSIX en modo texto");
                    break;
                }
                case 9: {
                    stringBuilder.append(" Windows CE");
                    break;
                }
                case 10: {
                    stringBuilder.append(" Aplicacion EFI (Extensible Firmware Interface)");
                    break;
                }
                case 11: {
                    stringBuilder.append(" Controlador EFI (Extensible Firmware Interface) con servicios de arranque");
                    break;
                }
                case 12: {
                    stringBuilder.append(" Controlador EFI (Extensible Firmware Interface) con servicios de ejecucion");
                    break;
                }
                case 13: {
                    stringBuilder.append(" Imagen ROM EFI (Extensible Firmware Interface)");
                    break;
                }
                case 14: {
                    stringBuilder.append(" XBOX");
                    break;
                }
                default: {
                    stringBuilder.append(" No valido");
                }
            }
            int n4 = 112;
            if (bl) {
                n4 = 128;
            }
            int n5 = AOBinUtil.getDWord(byArray, n2 + 20 + n4);
            int n6 = AOBinUtil.getDWord(byArray, n2 + 20 + n4 + 4);
            stringBuilder.append("\n Tamano (en memoria) de la tabla de recursos: " + n6 + " (" + AOUtil.hexify(new byte[]{byArray[n2 + 20 + n4 + 7], byArray[n2 + 20 + n4 + 6], byArray[n2 + 20 + n4 + 5], byArray[n2 + 20 + n4 + 4]}, false) + "h)");
            stringBuilder.append("\n Offset (virtual) de la tabla de recursos: " + n5 + " (" + AOUtil.hexify(new byte[]{byArray[n2 + 20 + n4 + 3], byArray[n2 + 20 + n4 + 2], byArray[n2 + 20 + n4 + 1], byArray[n2 + 20 + n4]}, false) + "h)");
        }
        this.description = stringBuilder.toString();
    }
}

